/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

/**
 * This implementation of custom skies is based on the FabricSkyBoxes mod by AMereBagatelle
 * <a href="https://github.com/AMereBagatelle/FabricSkyBoxes">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 **/

@SuppressWarnings("deprecation")
public class FSBSkyboxInstance extends SkyboxInstance {

	public FSBSkyboxInstance(JsonObject json) {
		super(json);
		JsonObject props = json.get("properties").getAsJsonObject();
		JsonObject textures = json.get("textures").getAsJsonObject();
		this.textures[0] = new class_2960(textures.get("bottom").getAsString());
		this.textures[1] = new class_2960(textures.get("north").getAsString());
		this.textures[2] = new class_2960(textures.get("south").getAsString());
		this.textures[3] = new class_2960(textures.get("top").getAsString());
		this.textures[4] = new class_2960(textures.get("east").getAsString());
		this.textures[5] = new class_2960(textures.get("west").getAsString());
		try {
			this.fade[0] = props.get("fade").getAsJsonObject().get("startFadeIn").getAsInt();
			this.fade[1] = props.get("fade").getAsJsonObject().get("endFadeIn").getAsInt();
			this.fade[2] = props.get("fade").getAsJsonObject().get("startFadeOut").getAsInt();
			this.fade[3] = props.get("fade").getAsJsonObject().get("endFadeOut").getAsInt();
		} catch (Exception e) {
			alwaysOn = true;
		}
		try {
			JsonObject rotation = props.get("rotation").getAsJsonObject();
			this.rotate = props.get("shouldRotate").getAsBoolean();
			this.rotationSpeed = rotation.get("rotationSpeed").getAsFloat();
			JsonArray axis = rotation.get("axis").getAsJsonArray();
			for (int i = 0; i < axis.size(); i++) {
				this.rotationAxis[i] = axis.get(i).getAsFloat();
			}
			JsonArray staticRotation = rotation.get("static").getAsJsonArray();
			for (int i = 0; i < staticRotation.size(); i++) {
				this.rotationStatic[i] = staticRotation.get(i).getAsFloat();
			}
		} catch (Exception ignored) {
		}

		try {
			JsonObject jsonBlend = json.get("blend").getAsJsonObject();
			this.blendMode = parseBlend(jsonBlend.get("type").getAsString());
		} catch (Exception ignored) {
			try {
				AxolotlClient.LOGGER.debug(textures + ": Using manual blend!");
				JsonObject blend = json.get("blend").getAsJsonObject();
				this.blendEquation = blend.get("equation").getAsInt();
				this.blendDstFactor = blend.get("dfactor").getAsInt();
				this.blendSrcFactor = blend.get("sfactor").getAsInt();
				this.manualBlend = true;
			} catch (Exception e) {
				AxolotlClient.LOGGER.debug(textures + ": Manual Blend failed, using fallback blend!");
				manualBlend = false;
				blendMode = 8;
			}
		}

		try {
			JsonObject decorations = json.get("decorations").getAsJsonObject();
			this.showMoon = decorations.get("showMoon").getAsBoolean();
			this.showSun = decorations.get("showSun").getAsBoolean();
			this.showStars = decorations.get("showStars").getAsBoolean();
		} catch (Exception ignored) {
		}
	}

	@Override
	public void renderSkybox(class_4587 matrices) {
		this.alpha = getAlpha();

		RenderSystem.color4f(1, 1, 1, 1);

		class_289 tessellator = class_289.method_1348();
		class_287 bufferBuilder = tessellator.method_1349();

		for (int i = 0; i < 6; ++i) {
			// 0 = bottom
			// 1 = north
			// 2 = south
			// 3 = top
			// 4 = east
			// 5 = west

			if (textures[i] != null) {
				class_310.method_1551().method_1531().method_22813(textures[i]);
				matrices.method_22903();

				if (i == 1) {
					matrices.method_22907(class_1160.field_20703.method_23214(90.0F));
				} else if (i == 2) {
					matrices.method_22907(class_1160.field_20703.method_23214(-90.0F));
					matrices.method_22907(class_1160.field_20705.method_23214(180.0F));
				} else if (i == 3) {
					matrices.method_22907(class_1160.field_20703.method_23214(180.0F));
				} else if (i == 4) {
					matrices.method_22907(class_1160.field_20707.method_23214(90.0F));
					matrices.method_22907(class_1160.field_20705.method_23214(-90.0F));
				} else if (i == 5) {
					matrices.method_22907(class_1160.field_20707.method_23214(-90.0F));
					matrices.method_22907(class_1160.field_20705.method_23214(90.0F));
				}
				class_1159 matrix4f = matrices.method_23760().method_23761();
				bufferBuilder.method_1328(7, class_290.field_1575);
				bufferBuilder.method_22918(matrix4f, -100, -100, -100).method_22913(0F, 0F).method_22915(1F, 1F, 1F, alpha).method_1344();
				bufferBuilder.method_22918(matrix4f, -100, -100, 100).method_22913(0F, 1F).method_22915(1F, 1F, 1F, alpha).method_1344();
				bufferBuilder.method_22918(matrix4f, 100, -100, 100).method_22913(1F, 1F).method_22915(1F, 1F, 1F, alpha).method_1344();
				bufferBuilder.method_22918(matrix4f, 100, -100, -100).method_22913(1F, 0F).method_22915(1F, 1F, 1F, alpha).method_1344();
				class_286.method_1309(bufferBuilder);

				matrices.method_22909();
			}
		}
	}
}
