/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

/**
 * This utility allows us to separate the texture atlas parts in order to be able to make use of nine-slicing
 */
public class ButtonWidgetTextures {
	private static class_2960 disabledTexture, activeTexture, hoveredTexture;

	static {
		ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
			@Override
			public class_2960 getFabricId() {
				return new class_2960("axolotlclient", "buttonwidget/nineslicing");
			}

			@Override
			public void method_14491(class_3300 manager) {
				class_310.method_1551().method_1531().method_4615(disabledTexture);
				class_310.method_1551().method_1531().method_4615(activeTexture);
				class_310.method_1551().method_1531().method_4615(hoveredTexture);
				disabledTexture = activeTexture = hoveredTexture = null;
			}
		});
	}

	private static void load() {
		if (hoveredTexture != null) {
			return;
		}
		var mc = class_310.method_1551();
		var resMan = mc.method_1478();
		try (var in = resMan.method_14486(new class_2960("textures/gui/widgets.png")).method_14482()) {
			BufferedImage img = ImageIO.read(in);
			disabledTexture = register(img, "disabled", 46);
			activeTexture = register(img, "active", 46 + 20);
			hoveredTexture = register(img, "hovered", 46 + 40);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	private static class_2960 register(BufferedImage atlas, String name, int imageY) throws IOException {
		var id = new class_2960("axolotlclient", "minecraft/buttonwidget/" + name);
		class_1011 img;
		try (var out = new ByteArrayOutputStream()) {
			int scale = atlas.getHeight() / 256;
			ImageIO.write(atlas.getSubimage(0, imageY * scale, 200 * scale, 20 * scale), "png", out);
			var in = new ByteArrayInputStream(out.toByteArray());
			img = class_1011.method_4309(in);
			in.close();
		}
		var texture = new class_1043(img);
		class_310.method_1551().method_1531().method_4616(id, texture);
		return id;
	}

	public static class_2960 get(int state) {
		load();
		return switch (state) {
			case 2 -> hoveredTexture;
			case 1 -> activeTexture;
			default -> disabledTexture;
		};
	}
}
