/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Graphics;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;

public class Util {
	public static final Color GlColor = new Color();
	public static String lastgame;
	public static String game;

	public static int getTicksBetween(int start, int end) {
		if (end < start)
			end += 24000;
		return end - start;
	}

	public static String getGame() {
		List<String> sidebar = getSidebar();

		if (sidebar.isEmpty())
			game = "";
		else if (class_310.method_1551().method_1558() != null
			&& class_310.method_1551().method_1558().field_3761.toLowerCase()
			.contains(sidebar.get(0).toLowerCase())) {
			if (sidebar.get(sidebar.size() - 1).toLowerCase(Locale.ROOT)
				.contains(class_310.method_1551().method_1558().field_3761.toLowerCase(Locale.ROOT))
				|| sidebar.get(sidebar.size() - 1).contains("Playtime")) {
				game = "In Lobby";
			} else {
				if (sidebar.get(sidebar.size() - 1).contains("--------")) {
					game = "Playing Bridge Practice";
				} else {
					game = "Playing " + sidebar.get(sidebar.size() - 1);
				}
			}
		} else {
			game = "Playing " + sidebar.get(0);
		}

		if (!Objects.equals(lastgame, game) && game.isEmpty())
			game = lastgame;
		else
			lastgame = game;

		if (game == null) {
			game = "";
		}

		return game;
	}

	public static List<String> getSidebar() {
		List<String> lines = new ArrayList<>();
		class_310 client = class_310.method_1551();
		if (client.field_1687 == null)
			return lines;

		class_269 scoreboard = client.field_1687.method_8428();
		if (scoreboard == null)
			return lines;
		class_266 sidebar = scoreboard.method_1189(1);
		if (sidebar == null)
			return lines;

		Collection<class_267> scores = scoreboard.method_1184(sidebar);
		List<class_267> list = scores.stream().filter(
				input -> input != null && input.method_1129() != null && !input.method_1129().startsWith("#"))
			.collect(Collectors.toList());

		if (list.size() > 15) {
			scores = Lists.newArrayList(Iterables.skip(list, scores.size() - 15));
		} else {
			scores = list;
		}

		for (class_267 score : scores) {
			class_268 team = scoreboard.method_1164(score.method_1129());
			if (team == null)
				return lines;
			String text = team.method_1144().getString() + team.method_1136().getString();
			if (!text.trim().isEmpty())
				lines.add(text);
		}

		lines.add(sidebar.method_1114().getString());
		Collections.reverse(lines);

		return lines;
	}

	public static class_2561 formatFromCodes(String formattedString) {
		class_5250 text = class_2585.field_24366.method_27662();
		String[] arr = formattedString.split("§");

		List<class_124> modifiers = new ArrayList<>();
		for (int i = 0, length = arr.length; i < length; i++) {
			String s = arr[i];
			if (s.isEmpty()) {
				continue;
			} else if (i == 0) {
				text.method_27693(s);
				continue;
			}
			class_124 formatting = class_124.method_544(s.charAt(0));
			if (formatting != null && formatting.method_542()) {
				modifiers.add(formatting);
			}
			class_5250 part = new class_2585(formatting != null ? s.substring(1) : s);
			if (formatting != null) {
				part.method_27692(formatting);

				if (!modifiers.isEmpty()) {
					modifiers.forEach(part::method_27692);
					if (formatting.equals(class_124.field_1070)) {
						modifiers.clear();
					}
				}
			}
			text.method_10852(part);
		}
		return text;
	}

	public static void addMessageToChatHud(class_2561 msg) {
		class_310.method_1551().field_1705.method_1743().method_1812(msg);
	}

	public static class_2960 getTexture(GraphicsOption option) {
		return getTexture(option.get(), option.getName());
	}

	@SuppressWarnings("DataFlowIssue")
	public static class_2960 getTexture(Graphics graphics, String name) {
		class_2960 id = new class_2960("axolotlclient", "graphics_" + name.toLowerCase(Locale.ROOT));
		try {
			class_1043 texture;
			if (class_310.method_1551().method_1531().method_4619(id) == null) {
				texture = new class_1043(class_1011.method_4309(new ByteArrayInputStream(graphics.getPixelData())));
				class_310.method_1551().method_1531().method_4616(id, texture);
			} else {
				texture = (class_1043) class_310.method_1551().method_1531().method_4619(id);
				for (int x = 0; x < graphics.getWidth(); x++) {
					for (int y = 0; y < graphics.getHeight(); y++) {
						texture.method_4525().method_4305(x, y, graphics.getPixelColor(x, y));
					}
				}
			}

			texture.method_4524();
		} catch (IOException e) {
			AxolotlClient.LOGGER.error("Failed to bind texture for " + name + ": ", e);
		}
		return id;
	}

	public static void bindTexture(GraphicsOption option) {
		class_2960 id = getTexture(option);
		class_310.method_1551().method_1531().method_22813(id);
	}

	public static double lerp(double start, double end, double percent) {
		return start + ((end - start) * percent);
	}

	public static class Color {

		public float red = 1.0F;
		public float green = 1.0F;
		public float blue = 1.0F;
		public float alpha = 1.0F;

		public Color() {
		}

		public Color(float red, float green, float blue, float alpha) {
			this.red = red;
			this.green = green;
			this.blue = blue;
			this.alpha = alpha;
		}
	}
}
