/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.options.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.OptionCategoryImpl;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.BooleanWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.CategoryWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.util.ButtonWidgetTextures;
import io.github.axolotlclient.util.options.ForceableBooleanOption;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class QuickToggleCategoryWidget extends CategoryWidget {
	private BooleanWidget enabledButton;

	public QuickToggleCategoryWidget(int x, int y, int width, int height, OptionCategoryImpl category) {
		super(x, y, width, height, category);
		category.getOptions().stream()
			.filter(o -> o instanceof BooleanOption)
			.map(o -> (BooleanOption) o)
			.filter(o -> "enabled".equals(o.getName())).findFirst()
			.ifPresent(booleanOption -> {
				enabledButton = new BooleanWidget(x + (width - 33), y + 3, 30, height - 5, booleanOption) {
					@Override
					public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
						class_2960 tex = ButtonWidgetTextures.get(!this.field_22763 ? 0 : (this.method_25367() ? 2 : 1));
						RenderSystem.color4f(1.0F, 1.0F, 1.0F, this.field_22765);
						io.github.axolotlclient.modules.hud.util.DrawUtil.blitSprite(tex, this.getX(), this.getY(), this.method_25368(), this.method_25364(), new io.github.axolotlclient.modules.hud.util.DrawUtil.NineSlice(200, 20, 3));

						int textColor = this.field_22763 ? 16777215 : 10526880;
						this.drawScrollableText(matrices, class_310.method_1551().field_1772, textColor | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
					}
				};
				enabledButton.field_22763 = !(booleanOption instanceof ForceableBooleanOption o && o.isForceOff());
			});
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {

		if (enabledButton != null && enabledButton.method_25405(mouseX, mouseY)) {
			this.field_22762 = false;
			return true;
		}
		return super.method_25405(mouseX, mouseY);
	}

	@Override
	public void method_25359(class_4587 graphics, int mouseX, int mouseY, float delta) {
		super.method_25359(graphics, mouseX, mouseY, delta);

		if (enabledButton != null) {
			enabledButton.field_22761 = (getY() + 2);
			enabledButton.update();
			enabledButton.method_25394(graphics, mouseX, mouseY, delta);
		}
	}

	@Override
	protected void drawScrollableText(class_4587 matrices, class_327 textRenderer, int xOffset, int color) {
		int i = this.getX() + xOffset;
		int j = this.getX() + this.method_25368() - xOffset;
		int center = this.getX() + this.method_25368() / 2;
		if (enabledButton != null) {
			j -= enabledButton.method_25368() + 4;
			center -= enabledButton.method_25368() / 2 + 2;
		}
		DrawUtil.drawScrollingText(matrices, textRenderer, this.method_25369(), center, i, this.getY(), j, this.getY() + this.method_25364(), color);
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {

		if (enabledButton != null &&
			enabledButton.method_25367()) {
			method_25354(class_310.method_1551().method_1483());
			enabledButton.method_25306();
			return true;
		}
		return this.field_22762 && super.method_25402(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (!this.field_22763 || !this.field_22764) {
			return false;
		} else if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
			return false;
		} else {
			this.method_25354(class_310.method_1551().method_1483());
			method_25402(0, 0, 0);
			return true;
		}
	}
}
