/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.api.AddFriendScreen;
import io.github.axolotlclient.api.UserListWidget;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class FriendsScreen
extends class_437 {
    private final class_437 parent;
    private UserListWidget widget;
    private class_4185 chatButton;
    private class_4185 removeButton;
    private class_4185 onlineTab;
    private class_4185 allTab;
    private class_4185 pendingTab;
    private class_4185 blockedTab;
    private class_4185 denyButton;
    private class_4185 acceptButton;
    private class_4185 unblockButton;
    private class_4185 cancelButton;
    private Tab current = Tab.ONLINE;

    protected FriendsScreen(class_437 parent, Tab tab) {
        this(parent);
        this.current = tab;
    }

    public FriendsScreen(class_437 parent) {
        super((class_2561)new class_2588("api.screen.friends"));
        this.parent = parent;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.widget.method_25394(matrices, mouseX, mouseY, delta);
        FriendsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)20, (int)0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 294) {
            this.refresh();
            return true;
        }
        if (this.widget.method_25334() != null) {
            if (keyCode != 257 && keyCode != 335) {
                return this.widget.method_25404(keyCode, scanCode, modifiers);
            }
            this.openChat();
            return true;
        }
        return false;
    }

    protected void method_25426() {
        this.widget = new UserListWidget(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 64, 35);
        this.method_25429((class_364)this.widget);
        this.widget.method_25396().clear();
        if (this.current == Tab.ALL || this.current == Tab.ONLINE) {
            FriendRequest.getInstance().getFriends().whenCompleteAsync((list, t) -> this.widget.setUsers(list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).filter(user -> {
                if (this.current == Tab.ONLINE) {
                    return user.getStatus().isOnline();
                }
                return true;
            }).collect(Collectors.toList())));
        } else if (this.current == Tab.PENDING) {
            FriendRequest.getInstance().getFriendRequests().whenCompleteAsync((con, th) -> {
                ((List)con.getLeft()).stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.widget.addEntry(new UserListWidget.UserListEntry((User)user, (class_5250)new class_2588("api.friends.pending.incoming"))));
                ((List)con.getRight()).stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.widget.addEntry(new UserListWidget.UserListEntry((User)user, (class_5250)new class_2588("api.friends.pending.outgoing")).outgoing()));
            });
        } else if (this.current == Tab.BLOCKED) {
            FriendRequest.getInstance().getBlocked().whenCompleteAsync((list, th) -> this.widget.setUsers(list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).collect(Collectors.toList())));
        }
        this.blockedTab = new class_4185(this.field_22789 / 2 + 24, this.field_22790 - 52, 57, 20, (class_2561)new class_2588("api.friends.tab.blocked"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.BLOCKED)));
        this.method_25411((class_339)this.blockedTab);
        this.pendingTab = new class_4185(this.field_22789 / 2 - 34, this.field_22790 - 52, 57, 20, (class_2561)new class_2588("api.friends.tab.pending"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.PENDING)));
        this.method_25411((class_339)this.pendingTab);
        this.allTab = new class_4185(this.field_22789 / 2 - 94, this.field_22790 - 52, 57, 20, (class_2561)new class_2588("api.friends.tab.all"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.ALL)));
        this.method_25411((class_339)this.allTab);
        this.onlineTab = new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 52, 57, 20, (class_2561)new class_2588("api.friends.tab.online"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.ONLINE)));
        this.method_25411((class_339)this.onlineTab);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 88, this.field_22790 - 52, 66, 20, (class_2561)new class_2588("api.friends.add"), button -> this.field_22787.method_1507((class_437)new AddFriendScreen(this))));
        this.removeButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20, (class_2561)new class_2588("api.friends.remove"), button -> {
            UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
            if (entry != null) {
                this.removeButton.field_22763 = false;
                FriendRequest.getInstance().removeFriend(entry.getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
            }
        }));
        this.denyButton = new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 48, 20, (class_2561)new class_2588("api.friends.request.deny"), button -> this.denyRequest());
        this.method_25411((class_339)this.denyButton);
        this.acceptButton = new class_4185(this.field_22789 / 2 + 2, this.field_22790 - 28, 48, 20, (class_2561)new class_2588("api.friends.request.accept"), button -> this.acceptRequest());
        this.method_25411((class_339)this.acceptButton);
        this.unblockButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20, (class_2561)new class_2588("api.users.unblock"), b -> {
            b.field_22763 = false;
            FriendRequest.getInstance().unblockUser(((UserListWidget.UserListEntry)this.widget.method_25334()).getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
        }));
        this.cancelButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20, class_5244.field_24335, b -> {
            b.field_22763 = false;
            FriendRequest.getInstance().cancelFriendRequest(((UserListWidget.UserListEntry)this.widget.method_25334()).getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
        }));
        this.chatButton = new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 100, 20, (class_2561)new class_2588("api.friends.chat"), button -> this.openChat());
        this.method_25411((class_339)this.chatButton);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 4 + 50, this.field_22790 - 28, 100, 20, class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
        this.updateButtonActivationStates();
    }

    private void refresh() {
        this.field_22787.method_1507((class_437)new FriendsScreen(this.parent));
    }

    private void denyRequest() {
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        if (entry != null) {
            this.denyButton.field_22763 = false;
            FriendRequest.getInstance().denyFriendRequest(entry.getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
        }
    }

    private void acceptRequest() {
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        if (entry != null) {
            this.acceptButton.field_22763 = false;
            FriendRequest.getInstance().acceptFriendRequest(entry.getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
        }
    }

    private void updateButtonActivationStates() {
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        this.chatButton.field_22763 = entry != null && (this.current == Tab.ALL || this.current == Tab.ONLINE);
        this.removeButton.field_22764 = true;
        this.removeButton.field_22763 = entry != null;
        this.unblockButton.field_22763 = this.removeButton.field_22763;
        this.denyButton.field_22764 = false;
        this.cancelButton.field_22764 = false;
        this.unblockButton.field_22764 = false;
        this.acceptButton.field_22764 = false;
        if (this.current == Tab.ONLINE) {
            this.onlineTab.field_22763 = false;
            this.blockedTab.field_22763 = true;
            this.pendingTab.field_22763 = true;
            this.allTab.field_22763 = true;
        } else if (this.current == Tab.ALL) {
            this.allTab.field_22763 = false;
            this.blockedTab.field_22763 = true;
            this.pendingTab.field_22763 = true;
            this.onlineTab.field_22763 = true;
        } else if (this.current == Tab.PENDING) {
            this.pendingTab.field_22763 = false;
            this.blockedTab.field_22763 = true;
            this.allTab.field_22763 = true;
            this.onlineTab.field_22763 = true;
            this.removeButton.field_22764 = false;
            if (entry != null && entry.isOutgoingRequest()) {
                this.cancelButton.field_22764 = true;
            } else {
                this.denyButton.field_22764 = true;
                this.acceptButton.field_22764 = true;
            }
            this.acceptButton.field_22763 = entry != null;
            this.denyButton.field_22763 = this.acceptButton.field_22763;
        } else if (this.current == Tab.BLOCKED) {
            this.blockedTab.field_22763 = false;
            this.pendingTab.field_22763 = true;
            this.allTab.field_22763 = true;
            this.onlineTab.field_22763 = true;
            this.removeButton.field_22764 = false;
            this.unblockButton.field_22764 = true;
        }
    }

    public void openChat() {
        if (!this.chatButton.field_22763) {
            return;
        }
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        if (entry != null) {
            this.chatButton.field_22763 = false;
            ChannelRequest.getOrCreateDM((User)entry.getUser()).thenAccept(c -> this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new ChatScreen(this, (Channel)c))));
        }
    }

    public void select(UserListWidget.UserListEntry entry) {
        this.widget.method_25313((class_350.class_351)entry);
        this.updateButtonActivationStates();
    }

    public static enum Tab {
        ONLINE,
        ALL,
        PENDING,
        BLOCKED;

    }
}

