/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class UserListWidget
extends class_4280<UserListEntry> {
    private final FriendsScreen screen;

    public UserListWidget(FriendsScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, height, top, bottom, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users) {
        users.forEach(user -> this.addEntry(new UserListEntry((User)user)));
    }

    public int method_25322() {
        return super.method_25322() + 85;
    }

    public int addEntry(UserListEntry entry) {
        return super.method_25321((class_350.class_351)entry.init(this.screen));
    }

    protected int method_25329() {
        return super.method_25329() + 30;
    }

    public boolean method_25316() {
        return this.screen.method_25399() == this;
    }

    public static class UserListEntry
    extends class_4280.class_4281<UserListEntry> {
        private final User user;
        private final class_310 client = class_310.method_1551();
        private long time;
        private class_2561 note;
        private FriendsScreen screen;
        private boolean outgoingRequest;

        public UserListEntry(User user, class_5250 note) {
            this(user);
            this.note = note.method_27692(class_124.field_1056);
        }

        public UserListEntry(User user) {
            this.user = user;
        }

        public UserListEntry init(FriendsScreen screen) {
            this.screen = screen;
            return this;
        }

        public UserListEntry outgoing() {
            this.outgoingRequest = true;
            return this;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.user.isSystem()) {
                String fronters = this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/"));
                String tag = String.valueOf(class_124.field_1056) + class_124.field_1080.toString() + "(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")";
                this.client.field_1772.method_1729(matrices, fronters + " " + tag, (float)(x + 3), (float)(y + 1), -1);
            } else {
                this.client.field_1772.method_1729(matrices, this.user.getName(), (float)(x + 3 + 33), (float)(y + 1), -1);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                this.client.field_1772.method_1729(matrices, this.user.getStatus().getTitle(), (float)(x + 3 + 33), (float)(y + 12), 0x808080);
                this.client.field_1772.method_1729(matrices, this.user.getStatus().getDescription(), (float)(x + 3 + 40), (float)(y + 23), 0x808080);
            } else if (this.user.getStatus().getLastOnline() != null) {
                this.client.field_1772.method_1729(matrices, this.user.getStatus().getLastOnline(), (float)(x + 3 + 33), (float)(y + 12), 0x808080);
            }
            if (this.note != null) {
                this.client.field_1772.method_30883(matrices, this.note, (float)(x + entryWidth - this.client.field_1772.method_27525((class_5348)this.note) - 4), (float)(y + entryHeight - 10), 0x808080);
            }
            this.client.method_1531().method_22813(Auth.getInstance().getSkinTexture(this.user.getUuid(), this.user.getName()));
            RenderSystem.enableBlend();
            class_332.method_25293((class_4587)matrices, (int)(x - 1), (int)(y - 1), (int)33, (int)33, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)matrices, (int)(x - 1), (int)(y - 1), (int)33, (int)33, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.screen.select(this);
            if (class_156.method_658() - this.time < 250L && this.client.field_1687 == null) {
                this.screen.openChat();
            }
            this.time = class_156.method_658();
            return false;
        }

        @Generated
        public User getUser() {
            return this.user;
        }

        @Generated
        public boolean isOutgoingRequest() {
            return this.outgoingRequest;
        }
    }
}

