/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ChatUserListWidget
extends class_4280<UserListEntry> {
    private final ChatScreen screen;

    public ChatUserListWidget(ChatScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, bottom - top, top, bottom, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users, Channel channel) {
        users.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.addEntry(new UserListEntry((User)user, channel)));
    }

    public int method_25322() {
        return this.field_22742 - 5;
    }

    public int addEntry(UserListEntry entry) {
        return super.method_25321((class_350.class_351)entry.init(this.screen));
    }

    protected int method_25329() {
        return this.method_25342() + this.field_22742 - 8;
    }

    public boolean method_25316() {
        return this.screen.method_25399() == this;
    }

    public class UserListEntry
    extends class_4280.class_4281<UserListEntry> {
        private final User user;
        private final class_310 client = class_310.method_1551();
        private final Channel channel;
        private long time;
        private ChatScreen screen;

        public UserListEntry(User user, Channel channel) {
            this.user = user;
            this.channel = channel;
        }

        public UserListEntry init(ChatScreen screen) {
            this.screen = screen;
            return this;
        }

        public void method_25343(class_4587 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered && !this.screen.hasContextMenu()) {
                class_332.method_25294((class_4587)graphics, (int)(x - 2), (int)(y - 1), (int)(x + entryWidth - 3), (int)(y + entryHeight + 1), (int)0x55FFFFFF);
            }
            class_327 class_3272 = this.client.field_1772;
            class_2561 class_25612 = class_2561.method_30163((String)this.user.getName());
            Objects.requireNonNull(this.client.field_1772);
            DrawUtil.drawScrollableText(graphics, class_3272, class_25612, x + 3 + entryHeight, y + 1, x + entryWidth - 6, y + 1 + 9 + 2, -1);
            class_327 class_3273 = this.client.field_1772;
            class_2561 class_25613 = class_2561.method_30163((String)this.user.getStatus().getTitle());
            Objects.requireNonNull(this.client.field_1772);
            DrawUtil.drawScrollableText(graphics, class_3273, class_25613, x + 3 + entryHeight, y + 12, x + entryWidth - 6, y + 12 + 9 + 2, 0x808080);
            this.client.method_1531().method_22813(Auth.getInstance().getSkinTexture(this.user.getUuid(), this.user.getName()));
            RenderSystem.enableBlend();
            class_332.method_25293((class_4587)graphics, (int)x, (int)y, (int)entryHeight, (int)entryHeight, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)graphics, (int)x, (int)y, (int)entryHeight, (int)entryHeight, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            ChatUserListWidget.this.method_25313((class_350.class_351)this);
            if (button == 0) {
                if (class_156.method_658() - this.time >= 250L || this.client.field_1687 == null) {
                    // empty if block
                }
                this.time = class_156.method_658();
            } else if (button == 1 && !this.user.equals((Object)API.getInstance().getSelf())) {
                ContextMenu.Builder menu = ContextMenu.builder().title(class_2561.method_30163((String)this.user.getName())).spacer();
                if (!this.channel.isDM()) {
                    menu.entry((class_2561)new class_2588("api.friends.chat"), buttonWidget -> ChannelRequest.getOrCreateDM((User)this.user).whenCompleteAsync((channel, throwable) -> this.client.execute(() -> this.client.method_1507((class_437)new ChatScreen(this.screen.getParent(), (Channel)channel))))).spacer();
                }
                if (this.user.getRelation() != Relation.BLOCKED) {
                    if (this.user.getRelation() != Relation.FRIEND) {
                        menu.entry((class_2561)new class_2588("api.friends.add"), b -> FriendRequest.getInstance().addFriend(this.user.getUuid())).spacer();
                    }
                    menu.entry((class_2561)new class_2588("api.users.block"), buttonWidget -> FriendRequest.getInstance().blockUser(this.user));
                } else {
                    menu.entry((class_2561)new class_2588("api.users.unblock"), buttonWidget -> FriendRequest.getInstance().unblockUser(this.user));
                }
                if (this.channel.getOwner().equals((Object)API.getInstance().getSelf())) {
                    menu.spacer().entry((class_2561)new class_2588("api.channel.remove_user"), b -> ChannelRequest.removeUserFromChannel((Channel)this.channel, (User)this.user));
                }
                this.screen.setContextMenu(menu.build());
                return true;
            }
            return false;
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }
}

