/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.ChatMessage;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ClientColors;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_410;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ChatWidget
extends class_4280<ChatLine> {
    private final List<ChatMessage> messages = new ArrayList<ChatMessage>();
    private final Channel channel;
    private final class_310 client;
    private final ContextMenuScreen screen;

    public ChatWidget(Channel channel, int x, int y, int width, int height, ContextMenuScreen screen) {
        super(class_310.method_1551(), width, height, y, y + height, 13);
        this.channel = channel;
        this.client = class_310.method_1551();
        this.method_25333(x + 5);
        this.method_25315(false, 0);
        this.screen = screen;
        this.field_22742 = width;
        this.field_22743 = height;
        channel.getMessages().forEach(this::addMessage);
        ChatHandler.getInstance().setMessagesConsumer(chatMessages -> chatMessages.forEach(this::addMessage));
        ChatHandler.getInstance().setMessageConsumer(this::addMessage);
        ChatHandler.getInstance().setEnableNotifications(message -> !message.channelId().equals(channel.getId()));
        this.method_25307(this.getMaxScroll());
        this.method_29344(false);
    }

    public int getX() {
        return this.field_19088;
    }

    protected int getMaxScroll() {
        return Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - 6;
    }

    public int method_25322() {
        return this.field_22742 - 60;
    }

    private void addMessage(ChatMessage message) {
        boolean scrollToBottom;
        List list = this.client.field_1772.method_1728((class_5348)class_2561.method_30163((String)message.content()), this.method_25322());
        boolean bl = scrollToBottom = this.method_25341() == (double)this.getMaxScroll();
        if (!this.messages.isEmpty()) {
            ChatMessage prev = this.messages.get(this.messages.size() - 1);
            if (!prev.sender().equals((Object)message.sender()) || !prev.senderDisplayName().equals(message.senderDisplayName())) {
                this.method_25321((class_350.class_351)new NameChatLine(message));
            } else if (message.timestamp().getEpochSecond() - prev.timestamp().getEpochSecond() > 150L) {
                this.method_25321((class_350.class_351)new NameChatLine(message));
            }
        } else {
            this.method_25321((class_350.class_351)new NameChatLine(message));
        }
        list.forEach(t -> this.method_25321((class_350.class_351)new ChatLine((class_5481)t, message)));
        this.messages.add(message);
        this.method_25396().sort(Comparator.comparingLong(c -> c.getOrigin().timestamp().getEpochSecond()));
        if (scrollToBottom) {
            this.method_25307(this.getMaxScroll());
        }
        this.messages.sort(Comparator.comparingLong(value -> value.timestamp().getEpochSecond()));
    }

    private void loadMessages() {
        long before = !this.messages.isEmpty() ? this.messages.get(0).timestamp().getEpochSecond() : Instant.now().getEpochSecond();
        ChatHandler.getInstance().getMessagesBefore(this.channel, before);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountY) {
        double scrollAmount = this.method_25341() - amountY * (double)this.field_22741 / 2.0;
        if (scrollAmount < 0.0) {
            this.loadMessages();
        }
        this.method_25307(scrollAmount);
        return true;
    }

    public void remove() {
        ChatHandler.getInstance().setMessagesConsumer(ChatHandler.DEFAULT_MESSAGES_CONSUMER);
        ChatHandler.getInstance().setMessageConsumer(ChatHandler.DEFAULT_MESSAGE_CONSUMER);
        ChatHandler.getInstance().setEnableNotifications(ChatHandler.DEFAULT);
    }

    protected void method_25311(class_4587 matrices, int x, int y, int mouseX, int mouseY, float delta) {
        DrawUtil.enableScissor(this.field_19088, this.field_19085, this.field_19088 + this.field_22742, this.field_19085 + this.field_22743);
        super.method_25311(matrices, x, y, mouseX, mouseY, delta);
        DrawUtil.disableScissor();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int i = this.method_25329();
        int j = i + 6;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        this.client.method_1531().method_22813(class_332.field_22735);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.client.field_1687 == null) {
            bufferBuilder.method_1328(7, class_290.field_1575);
            bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19086, 0.0).method_22913((float)this.field_19088 / 32.0f, (float)(this.field_19086 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19086, 0.0).method_22913((float)this.field_19087 / 32.0f, (float)(this.field_19086 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19085, 0.0).method_22913((float)this.field_19087 / 32.0f, (float)(this.field_19085 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19085, 0.0).method_22913((float)this.field_19088 / 32.0f, (float)(this.field_19085 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            tessellator.method_1350();
        }
        int k = this.method_25342();
        int l = this.field_19085 + 4 - (int)this.method_25341();
        this.method_25311(matrices, k, l, mouseX, mouseY, delta);
        this.client.method_1531().method_22813(class_332.field_22735);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        bufferBuilder.method_1328(7, class_290.field_1575);
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19085, -100.0).method_22913(0.0f, (float)this.field_19085 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)(this.field_19088 + this.field_22742), (double)this.field_19085, -100.0).method_22913((float)this.field_22742 / 32.0f, (float)this.field_19085 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)(this.field_19088 + this.field_22742), 0.0, -100.0).method_22913((float)this.field_22742 / 32.0f, 0.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, 0.0, -100.0).method_22913(0.0f, 0.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_22743, -100.0).method_22913(0.0f, (float)this.field_22743 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)(this.field_19088 + this.field_22742), (double)this.field_22743, -100.0).method_22913((float)this.field_22742 / 32.0f, (float)this.field_22743 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)(this.field_19088 + this.field_22742), (double)this.field_19086, -100.0).method_22913((float)this.field_22742 / 32.0f, (float)this.field_19086 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19086, -100.0).method_22913(0.0f, (float)this.field_19086 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        tessellator.method_1350();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22544, (class_4493.class_4534)class_4493.class_4534.field_22518);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        int n = 4;
        bufferBuilder.method_1328(7, class_290.field_1575);
        bufferBuilder.method_22912((double)this.field_19088, (double)(this.field_19085 + 4), 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)(this.field_19085 + 4), 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19085, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19085, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19086, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19086, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)(this.field_19086 - 4), 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)(this.field_19086 - 4), 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        tessellator.method_1350();
        int o = this.getMaxScroll();
        if (o > 0) {
            int p = (int)((float)((this.field_19086 - this.field_19085) * (this.field_19086 - this.field_19085)) / (float)this.method_25317());
            p = class_3532.method_15340((int)p, (int)32, (int)(this.field_19086 - this.field_19085 - 8));
            int q = (int)this.method_25341() * (this.field_19086 - this.field_19085 - p) / o + this.field_19085;
            if (q < this.field_19085) {
                q = this.field_19085;
            }
            bufferBuilder.method_1328(7, class_290.field_1575);
            bufferBuilder.method_22912((double)i, (double)this.field_19086, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)j, (double)this.field_19086, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)j, (double)this.field_19085, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)i, (double)this.field_19085, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)i, (double)(q + p), 0.0).method_22913(0.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)j, (double)(q + p), 0.0).method_22913(1.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)j, (double)q, 0.0).method_22913(1.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)i, (double)q, 0.0).method_22913(0.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)i, (double)(q + p - 1), 0.0).method_22913(0.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
            bufferBuilder.method_22912((double)(j - 1), (double)(q + p - 1), 0.0).method_22913(1.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
            bufferBuilder.method_22912((double)(j - 1), (double)q, 0.0).method_22913(1.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
            bufferBuilder.method_22912((double)i, (double)q, 0.0).method_22913(0.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
            tessellator.method_1350();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    public class NameChatLine
    extends ChatLine {
        private final String formattedTime;

        public NameChatLine(ChatMessage message) {
            super(new class_2585(message.senderDisplayName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_30937(), message);
            DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("d/M/yyyy H:mm");
            this.formattedTime = DATE_FORMAT.format(message.timestamp().atZone(ZoneId.systemDefault()));
        }

        @Override
        protected void renderExtras(class_4587 graphics, int x, int y, int mouseX, int mouseY) {
            RenderSystem.disableBlend();
            class_2960 texture = Auth.getInstance().getSkinTexture(this.getOrigin().sender().getUuid(), this.getOrigin().sender().getName());
            this.client.method_1531().method_22813(texture);
            class_332.method_25293((class_4587)graphics, (int)(x - 22), (int)y, (int)18, (int)18, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)graphics, (int)(x - 22), (int)y, (int)18, (int)18, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            this.client.field_1772.method_1729(graphics, this.formattedTime, (float)(this.client.field_1772.method_30880(this.getContent()) + x + 5), (float)y, ClientColors.GRAY.toInt());
        }
    }

    public class ChatLine
    extends class_4280.class_4281<ChatLine> {
        protected final class_310 client = class_310.method_1551();
        private final class_5481 content;
        private final ChatMessage origin;

        public ChatLine(class_5481 content, ChatMessage origin) {
            this.content = content;
            this.origin = origin;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ChatWidget.this.method_25313((class_350.class_351)this);
                return true;
            }
            if (button == 1) {
                ContextMenu.Builder builder = ContextMenu.builder().title(class_2561.method_30163((String)this.origin.sender().getName())).spacer();
                if (!this.origin.sender().equals((Object)API.getInstance().getSelf())) {
                    builder.entry((class_2561)new class_2588("api.friends.chat"), buttonWidget -> ChannelRequest.getOrCreateDM((User)this.origin.sender()).whenCompleteAsync((channel, throwable) -> this.client.execute(() -> this.client.method_1507((class_437)new ChatScreen(ChatWidget.this.screen.getParent(), (Channel)channel))))).spacer();
                }
                builder.entry((class_2561)new class_2588("api.chat.report.message"), buttonWidget -> {
                    class_437 previous = this.client.field_1755;
                    this.client.method_1507((class_437)new class_410(b -> {
                        if (b) {
                            ChatHandler.getInstance().reportMessage(this.origin);
                        }
                        this.client.method_1507(previous);
                    }, (class_2561)new class_2588("api.channels.confirm_report"), (class_2561)new class_2588("api.channels.confirm_report.desc", new Object[]{this.origin.content()})));
                }).spacer().entry((class_2561)new class_2588("action.copy"), buttonWidget -> this.client.field_1774.method_1455(this.origin.content()));
                ChatWidget.this.screen.setContextMenu(builder.build());
                return true;
            }
            return false;
        }

        protected void renderExtras(class_4587 graphics, int x, int y, int mouseX, int mouseY) {
        }

        public void method_25343(class_4587 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (ChatLine l : ChatWidget.this.method_25396()) {
                if (!l.getOrigin().equals((Object)this.origin) || !l.method_25405(mouseX, mouseY) || !Objects.equals(ChatWidget.this.method_25308(mouseX, mouseY), (Object)l)) continue;
                hovered = true;
                break;
            }
            if (hovered && !ChatWidget.this.screen.hasContextMenu()) {
                class_332.method_25294((class_4587)graphics, (int)(x - 2 - 22), (int)(y - 2), (int)(x + entryWidth + 20), (int)(y + entryHeight - 1), (int)0x33FFFFFF);
                if (index < ChatWidget.this.method_25396().size() - 1 && ((ChatLine)((Object)ChatWidget.this.method_25396().get(index + 1))).getOrigin().equals((Object)this.origin)) {
                    class_332.method_25294((class_4587)graphics, (int)-24, (int)(y + entryHeight - 1), (int)(x + entryWidth + 20), (int)(y + entryHeight + 2), (int)0x33FFFFFF);
                }
                if (index < ChatWidget.this.method_25396().size() - 1 && !((ChatLine)((Object)ChatWidget.this.method_25396().get(index + 1))).getOrigin().equals((Object)this.origin) || index == ChatWidget.this.method_25396().size() - 1) {
                    class_332.method_25294((class_4587)graphics, (int)-24, (int)(y + entryHeight - 1), (int)(x + entryWidth + 20), (int)(y + entryHeight), (int)0x33FFFFFF);
                }
            }
            this.renderExtras(graphics, x, y, mouseX, mouseY);
            this.client.field_1772.method_27528(graphics, this.content, (float)x, (float)y, -1);
        }

        @Generated
        public class_5481 getContent() {
            return this.content;
        }

        @Generated
        public ChatMessage getOrigin() {
            return this.origin;
        }
    }
}

