/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.multiplayer;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.multiplayer.FriendsMultiplayerScreen;
import io.github.axolotlclient.api.multiplayer.ServerInfoUtil;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FriendsMultiplayerSelectionList
extends class_4280<Entry> {
    private static final class_2960 UNKNOWN_SERVER_TEXTURE = new class_2960("textures/misc/unknown_server.png");
    static final class_2960 SERVER_SELECTION_TEXTURE = new class_2960("textures/gui/server_selection.png");
    static final class_2960 ICONS = new class_2960("textures/gui/icons.png");
    static final Logger LOGGER = LogManager.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Friends Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    static final class_2561 CANT_RESOLVE_TEXT = new class_2588("multiplayer.status.cannot_resolve").method_27694(style -> style.method_27703(class_5251.method_27717((int)-65536)));
    static final class_2561 CANT_CONNECT_TEXT = new class_2588("multiplayer.status.cannot_connect").method_27694(style -> style.method_27703(class_5251.method_27717((int)-65536)));
    static final class_2561 INCOMPATIBLE_STATUS = new class_2588("multiplayer.status.incompatible");
    static final class_2561 NO_CONNECTION_STATUS = new class_2588("multiplayer.status.no_connection");
    static final class_2561 PINGING_STATUS = new class_2588("multiplayer.status.pinging");
    static final class_2561 NOT_PUBLISHED_STATUS = new class_2588("api.worldhost.joinability.not_published").method_27692(class_124.field_1061);
    private final FriendsMultiplayerScreen screen;
    private final List<Entry> friendEntries = new ArrayList<Entry>();
    private final LoadingHeader loadingHeader = new LoadingHeader();
    private static final int STATUS_ICON_HEIGHT = 8;
    private static final int STATUS_ICON_WIDTH = 10;

    public FriendsMultiplayerSelectionList(FriendsMultiplayerScreen screen, class_310 minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, screen.field_22789, screen.field_22790, y, y + height, itemHeight);
        this.screen = screen;
        this.method_25321((class_350.class_351)this.loadingHeader);
    }

    private void refreshEntries() {
        this.method_25339();
        this.friendEntries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public void setSelected(@Nullable Entry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.onSelectedChange();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Entry entry = (Entry)this.method_25334();
        return entry != null && entry.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public void updateList(List<User> friends) {
        this.friendEntries.clear();
        for (User friend : friends) {
            if (!friend.getStatus().isOnline()) continue;
            this.friendEntries.add(this.createEntry(friend));
        }
        this.refreshEntries();
    }

    private Entry createEntry(User friend) {
        if (friend.getStatus().getActivity() != null && friend.getStatus().getActivity().hasMetadata()) {
            if (friend.getStatus().getActivity().hasMetadata("external_server")) {
                return this.externalServerEntry(this.screen, friend);
            }
            return this.e4mcServerFriendEntry(this.screen, friend);
        }
        return new StatusFriendEntry(this.screen, friend);
    }

    public void updateEntry(User user) {
        this.friendEntries.stream().filter(e1 -> {
            if (e1 instanceof StatusFriendEntry) {
                StatusFriendEntry statusFriendEntry = (StatusFriendEntry)e1;
                return statusFriendEntry.getUser().equals((Object)user);
            }
            if (e1 instanceof ServerEntry) {
                ServerEntry serverEntry = (ServerEntry)e1;
                return serverEntry.getUser().equals((Object)user);
            }
            return false;
        }).findFirst().ifPresent(e -> {
            this.friendEntries.set(this.friendEntries.indexOf(e), this.createEntry(user));
            this.refreshEntries();
        });
    }

    public int method_25322() {
        return 305;
    }

    private ExternalServerFriendEntry externalServerEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity.ExternalServerMetadata metadata = (Status.Activity.ExternalServerMetadata)friend.getStatus().getActivity().metadata().attributes();
        return new ExternalServerFriendEntry(screen, metadata, new class_642(metadata.serverName(), metadata.address(), false), friend);
    }

    private E4mcServerFriendEntry e4mcServerFriendEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity activity = friend.getStatus().getActivity();
        Status.Activity.E4mcMetadata metadata = activity.hasMetadata("world_host") ? ((Status.Activity.WorldHostMetadata)activity.metadata().attributes()).asE4mcMetadata() : (Status.Activity.E4mcMetadata)activity.metadata().attributes();
        return new E4mcServerFriendEntry(screen, metadata, ServerInfoUtil.getServerData(friend.getName(), metadata), friend);
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private final class_310 minecraft = class_310.method_1551();

        public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = top + height / 2 - 4;
            String string = switch ((int)(class_156.method_658() / 300L % 4L)) {
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
                default -> "O o o";
            };
            this.minecraft.field_1772.method_1720(guiGraphics, string, (float)this.minecraft.field_1755.field_22789 / 2.0f - (float)this.minecraft.field_1772.method_1727(string) / 2.0f, (float)i, -8355712);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }

        public boolean canJoin() {
            return false;
        }

        public class_642 getServerData() {
            return null;
        }
    }

    public class ExternalServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.ExternalServerMetadata statusDescription;

        private ExternalServerFriendEntry(FriendsMultiplayerScreen screen, Status.Activity.ExternalServerMetadata statusDescription, class_642 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        public boolean canJoin() {
            return this.statusDescription.address() != null;
        }
    }

    public class E4mcServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.E4mcMetadata statusDescription;

        protected E4mcServerFriendEntry(FriendsMultiplayerScreen screen, Status.Activity.E4mcMetadata statusDescription, class_642 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        protected boolean isPublished() {
            return this.statusDescription.domain() != null;
        }

        @Override
        protected void refreshStatus() {
            super.refreshStatus();
            this.serverData.serverInfo.field_3757 = class_2561.method_30163((String)this.statusDescription.serverInfo().levelName());
        }
    }

    public class StatusFriendEntry
    extends Entry {
        private final User user;

        protected StatusFriendEntry(FriendsMultiplayerScreen screen, User friend) {
            this.user = friend;
        }

        public void method_25343(class_4587 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.user.isSystem()) {
                class_2585 fronters = new class_2585(this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/")));
                class_5250 tag = new class_2585("(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772.method_30883(graphics, (class_2561)fronters.method_10852((class_2561)tag), (float)(left + 3), (float)(top + 1), -1);
            } else {
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772.method_1729(graphics, this.user.getName(), (float)(left + 3 + 32), (float)(top + 1), -1);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772.method_1729(graphics, this.user.getStatus().getTitle(), (float)(left + 3 + 32), (float)(top + 12), 0x808080);
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772.method_1729(graphics, this.user.getStatus().getDescription(), (float)(left + 3 + 40), (float)(top + 23), 0x808080);
            } else if (this.user.getStatus().getLastOnline() != null) {
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772.method_1729(graphics, this.user.getStatus().getLastOnline(), (float)(left + 3 + 32), (float)(top + 12), 0x808080);
            }
            FriendsMultiplayerSelectionList.this.field_22740.method_1531().method_22813(Auth.getInstance().getSkinTexture(this.user));
            RenderSystem.enableBlend();
            class_332.method_25293((class_4587)graphics, (int)(left - 1), (int)(top - 1), (int)32, (int)32, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)graphics, (int)(left - 1), (int)(top - 1), (int)32, (int)32, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    protected class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int SPACING = 5;
        private static final int STATUS_ICON_WIDTH = 10;
        private static final int STATUS_ICON_HEIGHT = 8;
        private final FriendsMultiplayerScreen screen;
        private final class_310 minecraft;
        protected final ServerInfoEx serverData;
        private final class_2960 iconId;
        private class_1043 icon;
        private String lastIconBytes;
        private long lastClickTime;
        @Nullable
        private List<class_2561> onlinePlayersTooltip;
        private Sprite statusIcon;
        @Nullable
        private class_2561 statusIconTooltip;
        protected final User user;

        protected ServerEntry(FriendsMultiplayerScreen screen, class_642 serverData, User user) {
            this.screen = screen;
            this.minecraft = class_310.method_1551();
            this.serverData = new ServerInfoEx(serverData);
            this.iconId = new class_2960("servers/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)(serverData.field_3761 != null ? serverData.field_3761 : user.getUuid() + "_" + serverData.field_3752))) + "/icon");
            this.user = user;
        }

        @Override
        public class_642 getServerData() {
            return this.serverData.serverInfo();
        }

        protected void refreshStatus() {
            this.onlinePlayersTooltip = null;
            if (!this.isPublished()) {
                this.serverData.setPingResult(PingResult.UNREACHABLE);
            }
            switch (this.serverData.pingResult().ordinal()) {
                case 0: 
                case 1: {
                    this.statusIcon = Sprite.PING_1_SPRITE;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case 3: {
                    this.statusIcon = Sprite.INCOMPATIBLE_SPRITE;
                    this.onlinePlayersTooltip = this.serverData.serverInfo.field_3762;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    break;
                }
                case 2: {
                    this.statusIcon = Sprite.UNREACHABLE_SPRITE;
                    if (!this.isPublished()) break;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case 4: {
                    this.statusIcon = this.serverData.serverInfo.field_3758 < 150L ? Sprite.PING_5_SPRITE : (this.serverData.serverInfo.field_3758 < 300L ? Sprite.PING_4_SPRITE : (this.serverData.serverInfo.field_3758 < 600L ? Sprite.PING_3_SPRITE : (this.serverData.serverInfo.field_3758 < 1000L ? Sprite.PING_2_SPRITE : Sprite.PING_1_SPRITE)));
                    this.statusIconTooltip = new class_2588("multiplayer.status.ping", new Object[]{this.serverData.serverInfo.field_3758});
                    this.onlinePlayersTooltip = this.serverData.serverInfo.field_3762;
                }
            }
        }

        public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            String bs;
            int i;
            if (this.serverData.pingResult() == PingResult.INITIAL) {
                this.serverData.setPingResult(PingResult.PINGING);
                this.serverData.serverInfo.field_3757 = class_2585.field_24366;
                this.serverData.serverInfo.field_3753 = class_2585.field_24366;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().method_3003(this.serverData.serverInfo, () -> {});
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.setPingResult(PingResult.UNREACHABLE);
                        this.serverData.serverInfo.field_3757 = CANT_RESOLVE_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                    catch (Exception var3) {
                        this.serverData.setPingResult(PingResult.UNREACHABLE);
                        this.serverData.serverInfo.field_3757 = CANT_CONNECT_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                });
            }
            if (this.serverData.pingResult == PingResult.PINGING && this.serverData.serverInfo.field_3758 != -2L) {
                this.serverData.setPingResult(this.serverData.serverInfo.field_3756 == class_155.method_16673().getProtocolVersion() ? PingResult.SUCCESSFUL : PingResult.INCOMPATIBLE);
            }
            this.refreshStatus();
            class_332.method_25303((class_4587)guiGraphics, (class_327)this.minecraft.field_1772, (String)this.serverData.serverInfo.field_3752, (int)(left + 32 + 3), (int)(top + 1), (int)-1);
            List list = this.minecraft.field_1772.method_1728((class_5348)this.serverData.serverInfo.field_3757, width - 32 - 2);
            for (i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.field_1772.method_27517(guiGraphics, (class_5481)list.get(i), (float)(left + 32 + 3), (float)(top + 12 + 9 * i), -8355712);
            }
            FriendsMultiplayerSelectionList.this.field_22740.method_1531().method_22813(this.icon != null ? this.iconId : UNKNOWN_SERVER_TEXTURE);
            class_332.method_25290((class_4587)guiGraphics, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            FriendsMultiplayerSelectionList.this.field_22740.method_1531().method_22813(Auth.getInstance().getSkinTexture(this.user));
            RenderSystem.enableBlend();
            class_332.method_25293((class_4587)guiGraphics, (int)(left + 32 - 10), (int)(top + 32 - 10), (int)10, (int)10, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)guiGraphics, (int)(left + 32 - 10), (int)(top + 32 - 10), (int)10, (int)10, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
            if (this.serverData.pingResult() == PingResult.PINGING) {
                i = (int)(class_156.method_658() / 100L + (long)(index * 2) & 7L);
                if (i > 4) {
                    i = 8 - i;
                }
                this.statusIcon = switch (i) {
                    case 1 -> Sprite.PINGING_2_SPRITE;
                    case 2 -> Sprite.PINGING_3_SPRITE;
                    case 3 -> Sprite.PINGING_4_SPRITE;
                    case 4 -> Sprite.PINGING_5_SPRITE;
                    default -> Sprite.PINGING_1_SPRITE;
                };
            }
            i = left + width - 10 - 5;
            if (this.statusIcon != null) {
                this.statusIcon.draw(guiGraphics, i, top);
            }
            if (!Objects.equals(bs = this.serverData.serverInfo.method_2991(), this.lastIconBytes)) {
                if (this.uploadIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.serverData.serverInfo.method_2989(null);
                }
            }
            Object component = !this.isPublished() ? NOT_PUBLISHED_STATUS : (this.serverData.pingResult() == PingResult.INCOMPATIBLE ? this.serverData.serverInfo.field_3760.method_27662().method_27692(class_124.field_1061) : this.serverData.serverInfo.field_3753);
            int j = this.minecraft.field_1772.method_27525((class_5348)component);
            int k = i - j - 5;
            this.minecraft.field_1772.method_30881(guiGraphics, component, (float)k, (float)(top + 1), -8355712);
            if (this.statusIconTooltip != null && mouseX >= i && mouseX <= i + 10 && mouseY >= top && mouseY <= top + 8) {
                this.screen.setDeferredTooltip(this.statusIconTooltip);
            } else if (this.onlinePlayersTooltip != null && mouseX >= k && mouseX <= k + j && mouseY >= top && mouseY <= top - 1 + 9) {
                this.screen.setDeferredTooltip(this.onlinePlayersTooltip);
            }
            if (this.minecraft.field_1690.field_1854 || hovering) {
                int l = mouseX - left;
                int m = mouseY - top;
                if (this.canJoin()) {
                    class_332.method_25294((class_4587)guiGraphics, (int)left, (int)top, (int)(left + 32), (int)(top + 32), (int)-1601138544);
                    if (l < 32 && l > 16) {
                        Sprite.JOIN_HIGHLIGHTED_SPRITE.draw(guiGraphics, left, top);
                    } else {
                        Sprite.JOIN_SPRITE.draw(guiGraphics, left, top);
                    }
                }
            }
        }

        protected boolean isPublished() {
            return true;
        }

        @Override
        public boolean canJoin() {
            return this.serverData.pingResult() == PingResult.SUCCESSFUL && this.isPublished();
        }

        private boolean uploadIcon(String iconBytes) {
            if (iconBytes == null) {
                this.minecraft.method_1531().method_4615(this.iconId);
                if (this.icon != null && this.icon.method_4525() != null) {
                    this.icon.method_4525().close();
                }
                this.icon = null;
            } else {
                try {
                    class_1011 nativeImage = class_1011.method_15990((String)iconBytes);
                    if (nativeImage.method_4307() != 64 || nativeImage.method_4323() != 64) {
                        throw new IllegalArgumentException("Icon must be 64x64, but was " + nativeImage.method_4307() + "x" + nativeImage.method_4323());
                    }
                    if (this.icon == null) {
                        this.icon = new class_1043(nativeImage);
                    } else {
                        this.icon.method_4526(nativeImage);
                        this.icon.method_4524();
                    }
                    this.minecraft.method_1531().method_4616(this.iconId, (class_1044)this.icon);
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", (Object)this.serverData.serverInfo.field_3752, (Object)this.serverData.serverInfo().field_3761, (Object)var3);
                    return false;
                }
            }
            return true;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)FriendsMultiplayerSelectionList.this.method_25342();
            double e = mouseY - (double)FriendsMultiplayerSelectionList.this.method_25337(FriendsMultiplayerSelectionList.this.method_25396().indexOf(this));
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (class_156.method_658() - this.lastClickTime < 250L && this.canJoin()) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = class_156.method_658();
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public void close() {
            this.icon.close();
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    private static enum Sprite {
        UNREACHABLE_SPRITE(0, 5),
        INCOMPATIBLE_SPRITE(0, 5),
        PING_1_SPRITE(0, 4),
        PING_2_SPRITE(0, 3),
        PING_3_SPRITE(0, 2),
        PING_4_SPRITE(0, 3),
        PING_5_SPRITE(0, 0),
        PINGING_1_SPRITE(10, 0),
        PINGING_2_SPRITE(10, 1),
        PINGING_3_SPRITE(10, 2),
        PINGING_4_SPRITE(10, 3),
        PINGING_5_SPRITE(10, 4),
        JOIN_HIGHLIGHTED_SPRITE(0, 32, 32, 32, SERVER_SELECTION_TEXTURE),
        JOIN_SPRITE(0, 0, 32, 32, SERVER_SELECTION_TEXTURE);

        private final int u;
        private final int v;
        private final int texWidth;
        private final int texHeight;
        private final class_2960 atlas;

        private Sprite(int u, int v, int texWidth, int texHeight, class_2960 texture) {
            this.u = u;
            this.v = v;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.atlas = texture;
        }

        private Sprite(int u, int v) {
            this(u, 176 + v * 8, 10, 8, ICONS);
        }

        public void draw(class_4587 graphics, int x, int y) {
            class_310.method_1551().method_1531().method_22813(this.atlas);
            class_332.method_25290((class_4587)graphics, (int)x, (int)y, (float)this.u, (float)this.v, (int)this.texWidth, (int)this.texHeight, (int)256, (int)256);
        }
    }

    protected static enum PingResult {
        INITIAL,
        PINGING,
        UNREACHABLE,
        INCOMPATIBLE,
        SUCCESSFUL;

    }

    protected static final class ServerInfoEx {
        private final class_642 serverInfo;
        private PingResult pingResult;

        private ServerInfoEx(class_642 serverInfo) {
            this.serverInfo = serverInfo;
            this.pingResult = PingResult.INITIAL;
        }

        public class_642 serverInfo() {
            return this.serverInfo;
        }

        public PingResult pingResult() {
            return this.pingResult;
        }

        @Generated
        public void setPingResult(PingResult pingResult) {
            this.pingResult = pingResult;
        }
    }
}

