/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.multiplayer;

import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.util.UUIDHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2926;
import net.minecraft.class_642;

public class ServerInfoUtil {
    public static Status.Activity.ServerInfo getServerInfo(String levelName, class_2926 status) {
        if (status == null) {
            return new Status.Activity.ServerInfo(levelName, null, null, null, null);
        }
        return new Status.Activity.ServerInfo(levelName, status.method_12680().getString(), (Status.Activity.ServerInfo.Favicon)Optional.ofNullable(status.method_12678()).map(Status.Activity.ServerInfo.Favicon::fromString).orElse(null), (Status.Activity.ServerInfo.Players)Optional.ofNullable(status.method_12682()).map(p -> new Status.Activity.ServerInfo.Players(p.method_12687(), p.method_12688(), Arrays.stream(p.method_12685()).map(prof -> new Status.Activity.ServerInfo.Players.Player(prof.getName(), UUIDHelper.toUndashed((UUID)prof.getId()))).toList())).orElse(null), (Status.Activity.ServerInfo.Version)Optional.ofNullable(status.method_12683()).map(v -> new Status.Activity.ServerInfo.Version(v.method_12693(), v.method_12694())).orElse(null));
    }

    public static class_2926 getServerStatus(Status.Activity.ServerInfo info) {
        class_2926 metadata = new class_2926();
        metadata.method_12684(class_2561.method_30163((String)info.levelName()));
        Optional.ofNullable(info.players()).map(p -> {
            class_2926.class_2927 players = new class_2926.class_2927(p.max(), p.online());
            players.method_12686((GameProfile[])p.sample().stream().map(prof -> new GameProfile(UUIDHelper.fromUndashed((String)prof.uuid()), prof.name())).toArray(GameProfile[]::new));
            return players;
        }).ifPresent(arg_0 -> ((class_2926)metadata).method_12681(arg_0));
        Optional.ofNullable(info.icon()).map(Status.Activity.ServerInfo.Favicon::toString).ifPresent(arg_0 -> ((class_2926)metadata).method_12677(arg_0));
        Optional.ofNullable(info.version()).map(v -> new class_2926.class_2930(v.name(), v.protocol())).ifPresent(arg_0 -> ((class_2926)metadata).method_12679(arg_0));
        return metadata;
    }

    public static class_642 getServerData(String username, Status.Activity.E4mcMetadata metadata) {
        class_2926 serverMetadata = metadata.serverInfo() != null ? ServerInfoUtil.getServerStatus(metadata.serverInfo()) : null;
        class_642 data = new class_642(username, metadata.domain(), false);
        if (serverMetadata != null) {
            if (serverMetadata.method_12678().startsWith("data:image/png;base64,")) {
                data.method_2989(serverMetadata.method_12678().substring("data:image/png;base64,".length()));
            } else {
                data.method_2989(null);
            }
            data.field_3757 = new class_2585(metadata.serverInfo().levelName());
            Optional.ofNullable(serverMetadata.method_12683()).ifPresentOrElse(ver -> {
                data.field_3760 = new class_2585(ver.method_12693());
                data.field_3756 = ver.method_12694();
            }, () -> {
                data.field_3760 = new class_2588("multiplayer.status.old");
                data.field_3756 = 0;
            });
            Optional.ofNullable(serverMetadata.method_12682()).ifPresentOrElse(player -> {
                data.field_3753 = new class_2585(Integer.toString(player.method_12688())).method_10852((class_2561)new class_2585("/").method_27692(class_124.field_1063)).method_27693(Integer.toString(player.method_12687())).method_27692(class_124.field_1080);
                if (player.method_12685().length > 0) {
                    ArrayList<Object> list = new ArrayList<Object>(player.method_12685().length);
                    for (GameProfile gameProfile : player.method_12685()) {
                        list.add(new class_2585(gameProfile.getName()));
                    }
                    if (player.method_12685().length < player.method_12688()) {
                        list.add(new class_2588("multiplayer.status.and_more", new Object[]{player.method_12688() - player.method_12685().length}));
                    }
                    data.field_3762 = list;
                } else {
                    data.field_3762 = List.of();
                }
            }, () -> {
                data.field_3757 = new class_2588("multiplayer.status.unknown").method_27692(class_124.field_1063);
            });
        }
        return data;
    }
}

