/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import io.github.axolotlclient.modules.Module;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Accounts;
import io.github.axolotlclient.modules.auth.AccountsScreen;
import io.github.axolotlclient.modules.auth.DeviceCodeDisplayScreen;
import io.github.axolotlclient.modules.auth.DeviceFlowData;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.SkinManager;
import io.github.axolotlclient.util.ThreadExecuter;
import io.github.axolotlclient.util.notifications.Notifications;
import io.github.axolotlclient.util.options.GenericOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_1068;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_410;
import net.minecraft.class_437;

public class Auth
extends Accounts
implements Module {
    private static final Auth Instance = new Auth();
    public final BooleanOption showButton = new BooleanOption("auth.showButton", Boolean.valueOf(false));
    public final BooleanOption skinManagerAnimations = new BooleanOption("skins.manage.animations", Boolean.valueOf(true));
    private final class_310 client = class_310.method_1551();
    private final GenericOption viewAccounts = new GenericOption("viewAccounts", "clickToOpen", () -> this.client.method_1507((class_437)new AccountsScreen(this.client.field_1755)));
    private final Map<String, class_2960> textures = new HashMap<String, class_2960>();
    private final Set<String> loadingTexture = new HashSet<String>();
    private final Map<String, GameProfile> profileCache = new WeakHashMap<String, GameProfile>();
    private final SkinManager skinManager = new SkinManager();

    public void init() {
        this.load();
        this.msApi = new MSApi((Accounts)this, () -> this.client.field_1690.field_1883);
        if (this.isContained(this.client.method_1548().method_1673())) {
            this.current = this.getAccounts().stream().filter(account -> account.getUuid().equals(this.client.method_1548().method_1673())).toList().get(0);
            this.current.setAuthToken(this.client.method_1548().method_1674());
            this.current.setName(this.client.method_1548().method_1676());
        } else {
            this.current = new Account(this.client.method_1548().method_1676(), this.client.method_1548().method_1673(), this.client.method_1548().method_1674());
        }
        this.category.add(new Option[]{this.showButton, this.viewAccounts});
        AxolotlClient.config().general.add(new OptionCategory[]{this.category});
    }

    protected void login(Account account) {
        if (this.client.field_1687 != null) {
            return;
        }
        if (account.needsRefresh() && !account.isOffline()) {
            if (account.isExpired()) {
                Notifications.getInstance().addStatus((class_2561)new class_2588("auth.notif.title"), (class_2561)new class_2588("auth.notif.refreshing", new Object[]{account.getName()}));
            }
            ((CompletableFuture)account.refresh(this.msApi).thenAccept(a -> {
                if (!a.isExpired()) {
                    this.login((Account)a);
                }
            })).thenRun(() -> ((Auth)this).save());
        } else {
            try {
                API.getInstance().shutdown();
                ((MinecraftClientAccessor)this.client).setSession(new class_320(account.getName(), account.getUuid(), account.getAuthToken(), class_320.class_321.field_1988.name()));
                this.save();
                this.current = account;
                Notifications.getInstance().addStatus((class_2561)new class_2588("auth.notif.title"), (class_2561)new class_2588("auth.notif.login.successful", new Object[]{this.current.getName()}));
                API.getInstance().startup(account);
            }
            catch (Exception e) {
                e.printStackTrace();
                Notifications.getInstance().addStatus((class_2561)new class_2588("auth.notif.title"), (class_2561)new class_2588("auth.notif.login.failed"));
            }
        }
    }

    public void loadTextures(String uuid, String name) {
        if (!this.textures.containsKey(uuid) && !this.loadingTexture.contains(uuid)) {
            ThreadExecuter.scheduleTask(() -> {
                GameProfile gameProfile;
                this.loadingTexture.add(uuid);
                if (this.profileCache.containsKey(uuid)) {
                    gameProfile = this.profileCache.get(uuid);
                } else {
                    try {
                        UUID uUID = UUIDHelper.fromUndashed((String)uuid);
                        gameProfile = new GameProfile(uUID, name);
                        gameProfile = this.client.method_1495().fillProfileProperties(gameProfile, false);
                    }
                    catch (IllegalArgumentException var2) {
                        gameProfile = new GameProfile(null, name);
                    }
                    this.profileCache.put(uuid, gameProfile);
                }
                this.client.method_1582().method_4652(gameProfile, (type, id, tex) -> {
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        this.textures.put(uuid, id);
                        this.loadingTexture.remove(uuid);
                    }
                }, false);
            });
        }
    }

    CompletableFuture<Account> showAccountsExpiredScreen(Account account) {
        class_437 screen = this.client.field_1755;
        CompletableFuture<Account> fut = new CompletableFuture<Account>();
        this.client.execute(() -> this.client.method_1507((class_437)new class_410(bl -> {
            if (bl) {
                this.msApi.startDeviceAuth().thenRun(() -> fut.complete(account));
            } else {
                fut.cancel(true);
            }
            this.client.method_1507(screen);
        }, (class_2561)new class_2588("auth"), (class_2561)new class_2588("auth.accountExpiredNotice", new Object[]{account.getName()}))));
        return fut;
    }

    void displayDeviceCode(DeviceFlowData data) {
        this.client.execute(() -> this.client.method_1507((class_437)new DeviceCodeDisplayScreen(this.client.field_1755, data)));
    }

    public class_2960 getSkinTexture(Account account) {
        return this.getSkinTexture(account.getUuid(), account.getName());
    }

    public class_2960 getSkinTexture(User user) {
        return this.getSkinTexture(user.getUuid(), user.getName());
    }

    public class_2960 getSkinTexture(String uuid, String name) {
        this.loadTextures(uuid, name);
        class_2960 id = this.textures.get(uuid);
        if (id != null) {
            return id;
        }
        try {
            UUID uUID = UUID.fromString(uuid);
            return class_1068.method_4648((UUID)uUID);
        }
        catch (IllegalArgumentException ignored) {
            return class_1068.method_4649();
        }
    }

    @Generated
    public static Auth getInstance() {
        return Instance;
    }

    @Generated
    public SkinManager getSkinManager() {
        return this.skinManager;
    }
}

