/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.api.SimpleTextInputScreen;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.Asset;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.LoadingScreen;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.modules.auth.skin.SkinImportUtil;
import io.github.axolotlclient.modules.auth.skin.SkinWidget;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ButtonWidgetTextures;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Watcher;
import io.github.axolotlclient.util.notifications.Notifications;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1159;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinManagementScreen
extends class_437 {
    private static final Path SKINS_DIR = FabricLoader.getInstance().getGameDir().resolve("skins");
    private static final int LIST_SKIN_WIDTH = 75;
    private static final int LIST_SKIN_HEIGHT = 110;
    private static final class_2561 TEXT_EQUIPPING = new class_2588("skins.manage.equipping");
    private final class_437 parent;
    private final Account account;
    private MSApi.MCProfile cachedProfile;
    private SkinListWidget skinList;
    private SkinListWidget capesList;
    private boolean capesTab;
    private SkinWidget current;
    private final Watcher skinDirWatcher;
    private final List<class_4068> drawables = new ArrayList<class_4068>();
    private final CompletableFuture<MSApi.MCProfile> loadingFuture;
    private class_2561 tooltip;

    public SkinManagementScreen(class_437 parent, Account account) {
        super((class_2561)new class_2588("skins.manage"));
        this.parent = parent;
        this.account = account;
        this.skinDirWatcher = Watcher.createSelfTicking((Path)SKINS_DIR, () -> {
            AxolotlClientCommon.getInstance().getLogger().info("Reloading screen as local files changed!", new Object[0]);
            this.loadSkinsList();
        });
        this.loadingFuture = (account.needsRefresh() ? account.refresh(Auth.getInstance().getMsApi()) : CompletableFuture.completedFuture(null)).thenComposeAsync(unused -> Auth.getInstance().getMsApi().getProfile(account));
    }

    public void method_25426() {
        int headerHeight = 33;
        int contentHeight = this.field_22790 - headerHeight * 2;
        class_4185 back = this.addDrawableChild(new class_4185(this.field_22789 / 2 - 75, this.field_22790 - headerHeight / 2 - 10, 150, 20, class_5244.field_24339, btn -> this.method_25419()));
        var loadingPlaceholder = new class_339(0, headerHeight, this.field_22789, contentHeight, (class_2561)new class_2588("skins.loading")){

            public void method_25359(class_4587 graphics, int mouseX, int mouseY, float delta) {
                int centerX = this.field_22760 + this.method_25368() / 2;
                int centerY = this.field_22761 + this.method_25364() / 2;
                class_2561 text = this.method_25369();
                SkinManagementScreen.this.field_22793.method_30883(graphics, text, (float)centerX - (float)SkinManagementScreen.this.field_22793.method_27525((class_5348)text) / 2.0f, (float)(centerY - 9), -1);
                String string = switch ((int)(class_156.method_658() / 300L % 4L)) {
                    case 1, 3 -> "o O o";
                    case 2 -> "o o O";
                    default -> "O o o";
                };
                SkinManagementScreen.this.field_22793.method_1729(graphics, string, (float)centerX - (float)SkinManagementScreen.this.field_22793.method_1727(string) / 2.0f, (float)(centerY + 9), -8355712);
            }

            protected class_5250 method_25360() {
                return class_2585.field_24366.method_27662();
            }
        };
        loadingPlaceholder.field_22763 = false;
        this.addDrawableChild(loadingPlaceholder);
        this.addDrawableChild(back);
        this.skinList = new SkinListWidget(this.field_22787, this.field_22789 / 2, contentHeight - 24, headerHeight + 24, 144);
        this.capesList = new SkinListWidget(this.field_22787, this.field_22789 / 2, contentHeight - 24, headerHeight + 24, this.skinList.getEntryContentsHeight() + 24);
        this.skinList.method_25333(this.field_22789 / 2);
        this.capesList.method_25333(this.field_22789 / 2);
        float currentHeight = Math.min((float)this.field_22789 / 2.0f * 120.0f / 85.0f, (float)contentHeight);
        float currentWidth = currentHeight * 85.0f / 120.0f;
        this.current = new SkinWidget((int)currentWidth, (int)currentHeight, null, this.account);
        this.current.setPosition((int)((float)this.field_22789 / 4.0f - currentWidth / 2.0f), (int)((float)this.field_22790 / 2.0f - currentHeight / 2.0f));
        if (!this.capesTab) {
            this.capesList.active = false;
            this.capesList.visible = false;
        } else {
            this.skinList.active = false;
            this.skinList.visible = false;
        }
        ArrayList<class_4185> navBar = new ArrayList<class_4185>();
        class_4185 skinsTab = new class_4185(Math.max(this.field_22789 * 3 / 4 - 102, this.field_22789 / 2 + 2), headerHeight, Math.min(100, this.field_22789 / 4 - 2), 20, (class_2561)new class_2588("skins.nav.skins"), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.field_22763 = true;
                }
            });
            btn.field_22763 = false;
            this.skinList.active = true;
            this.skinList.visible = true;
            this.capesList.active = false;
            this.capesList.visible = false;
            this.capesTab = false;
        });
        navBar.add(skinsTab);
        class_4185 capesTab = new class_4185(this.field_22789 * 3 / 4 + 2, headerHeight, Math.min(100, this.field_22789 / 4 - 2), 20, (class_2561)new class_2588("skins.nav.capes"), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.field_22763 = true;
                }
            });
            btn.field_22763 = false;
            this.skinList.active = false;
            this.skinList.visible = false;
            this.capesList.active = true;
            this.capesList.visible = true;
            this.capesTab = true;
        });
        navBar.add(capesTab);
        SpriteButton importButton = new SpriteButton((class_2561)new class_2588("skins.manage.import.local"), btn -> {
            btn.field_22763 = false;
            ((CompletableFuture)SkinImportUtil.openImportSkinDialog().thenAccept(this::method_29638)).thenRun(() -> {
                btn.field_22763 = true;
            });
        }, new class_2960("axolotlclient", "textures/gui/sprites/folder.png"));
        SpriteButton downloadButton = new SpriteButton((class_2561)new class_2588("skins.manage.import.online"), btn -> {
            btn.field_22763 = false;
            this.promptForSkinDownload();
        }, new class_2960("axolotlclient", "textures/gui/sprites/download.png"));
        downloadButton.field_22760 = importButton.field_22760 - 2 - 11;
        downloadButton.field_22761 = capesTab.field_22761 - 13;
        if (this.field_22789 - (capesTab.field_22760 + capesTab.method_25368()) > 28) {
            importButton.field_22760 = this.field_22789 - importButton.method_25368() - 2;
            downloadButton.field_22760 = importButton.field_22760 - downloadButton.method_25368() - 2;
            downloadButton.field_22761 = importButton.field_22761 = capesTab.field_22761 + capesTab.method_25364() - 11;
        } else {
            importButton.field_22760 = capesTab.field_22760 + capesTab.method_25368() - 11;
            importButton.field_22761 = capesTab.field_22761 - 13;
            downloadButton.field_22760 = importButton.field_22760 - 2 - 11;
            downloadButton.field_22761 = importButton.field_22761;
        }
        skinsTab.field_22763 = this.capesTab;
        capesTab.field_22763 = !this.capesTab;
        Runnable addWidgets = () -> {
            this.clear();
            this.addDrawableChild(this.current);
            this.addDrawableChild(skinsTab);
            this.addDrawableChild(capesTab);
            this.addDrawableChild(downloadButton);
            this.addDrawableChild(importButton);
            this.addDrawableChild(this.skinList);
            this.addDrawableChild(this.capesList);
            this.addDrawableChild(back);
        };
        if (this.cachedProfile != null) {
            this.initDisplay();
            addWidgets.run();
            return;
        }
        ((CompletableFuture)this.loadingFuture.thenAcceptAsync(profile -> {
            this.cachedProfile = profile;
            this.initDisplay();
            addWidgets.run();
        })).exceptionally(t -> {
            if (t.getCause() instanceof CancellationException) {
                this.field_22787.method_1507(this.parent);
                return null;
            }
            AxolotlClientCommon.getInstance().getLogger().error("Failed to load skins!", new Object[]{t});
            class_2588 error = new class_2588("skins.error.failed_to_load");
            class_2588 errorDesc = new class_2588("skins.error.failed_to_load_desc");
            this.clear();
            this.addDrawableChild(back);
            int n = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)error) / 2;
            int n2 = this.field_22790 / 2;
            Objects.requireNonNull(this.field_22793);
            int n3 = n2 - 9 - 2;
            int n4 = this.field_22793.method_27525((class_5348)error);
            Objects.requireNonNull(this.field_22793);
            class TextWidget
            extends class_339 {
                public TextWidget(int x, int y, int width, int height, class_2561 message, class_327 textRenderer) {
                    super(x, y, width, height, message);
                    this.field_22763 = false;
                }

                public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
                    class_327 class_3272 = SkinManagementScreen.this.field_22793;
                    class_2561 class_25612 = this.method_25369();
                    int n = this.field_22760 + this.method_25368() / 2;
                    int n2 = this.field_22761 + this.method_25364() / 2;
                    Objects.requireNonNull(SkinManagementScreen.this.field_22793);
                    TextWidget.method_27534((class_4587)matrices, (class_327)class_3272, (class_2561)class_25612, (int)n, (int)(n2 - 9 / 2), (int)-1);
                }
            }
            this.addDrawableChild(new TextWidget(n, n3, n4, 9, (class_2561)error, this.field_22793));
            int n5 = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)errorDesc) / 2;
            int n6 = this.field_22790 / 2 + 1;
            int n7 = this.field_22793.method_27525((class_5348)errorDesc);
            Objects.requireNonNull(this.field_22793);
            this.addDrawableChild(new TextWidget(n5, n6, n7, 9, (class_2561)errorDesc, this.field_22793));
            return null;
        });
    }

    private void promptForSkinDownload() {
        this.field_22787.method_1507((class_437)new SimpleTextInputScreen(this, (class_2561)new class_2588("skins.manage.import.online"), (class_2561)new class_2588("skins.manage.import.online.input"), s -> UUIDHelper.ensureUuidOpt((String)s).thenAccept(o -> {
            if (o.isPresent()) {
                AxolotlClientCommon.getInstance().getLogger().info("Downloading skin of {} ({})", new Object[]{s, o.get()});
                ((CompletableFuture)Auth.getInstance().getMsApi().getTextures((String)o.get()).exceptionally(th -> {
                    AxolotlClientCommon.getInstance().getLogger().info("Failed to download skin of {} ({})", new Object[]{s, o.get(), th});
                    return null;
                })).thenAccept(t -> {
                    if (t == null) {
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_download", s);
                        return;
                    }
                    try {
                        byte[] bytes = (byte[])t.skin().join();
                        Path out = this.ensureNonexistent(SKINS_DIR.resolve(t.skinKey()));
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", t.classicModel(), "name", t.name(), "uuid", t.id(), "download_time", Instant.now()));
                        Files.write(out, bytes, new OpenOption[0]);
                        this.field_22787.execute(this::loadSkinsList);
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.downloaded", t.name());
                        AxolotlClientCommon.getInstance().getLogger().info("Downloaded skin of {} ({})", new Object[]{t.name(), o.get()});
                    }
                    catch (IOException e) {
                        AxolotlClientCommon.getInstance().getLogger().warn("Failed to write skin file", new Object[]{e});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_save", t.name());
                    }
                });
            } else {
                Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.not_found", s);
            }
        })));
    }

    private <T extends class_4068 & class_364> T addDrawableChild(T child) {
        this.drawables.add(child);
        return (T)((class_4068)this.method_25429(child));
    }

    private void clear() {
        this.field_22786.clear();
        this.field_22791.clear();
        this.drawables.clear();
    }

    public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.method_25420(graphics);
        this.drawables.forEach(d -> d.method_25394(graphics, mouseX, mouseY, delta));
        class_2561 class_25612 = this.method_25440();
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        SkinManagementScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)class_25612, (int)n, (int)(16 - 9 / 2), (int)-1);
        if (this.tooltip != null) {
            this.method_25424(graphics, this.tooltip, mouseX, mouseY + 20);
        }
    }

    private void initDisplay() {
        this.loadSkinsList();
        this.loadCapesList();
    }

    private void refreshCurrentList() {
        if (this.capesTab) {
            double scroll = this.capesList.method_25341();
            this.loadCapesList();
            this.capesList.method_25307(scroll);
        } else {
            double scroll = this.skinList.method_25341();
            this.loadSkinsList();
            this.skinList.method_25307(scroll);
        }
    }

    private void loadCapesList() {
        ArrayList<Row> rows = new ArrayList<Row>();
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.field_22789 / 2 - 25) / 75);
        List capes = profile.capes();
        SkinWidget deselectCape = this.createWidgetForCape(this.current.getSkin(), null);
        Optional<MSApi.MCProfile.OnlineCape> activeCape = capes.stream().filter(Asset::active).findFirst();
        this.current.setCape(activeCape.orElse(null));
        deselectCape.noCape(activeCape.isEmpty());
        for (int i = 0; i < capes.size() + 1; i += columns) {
            Entry widget;
            if (i == 0) {
                widget = this.createEntry(this.capesList.getEntryContentsHeight(), deselectCape, (class_2561)new class_2588("skins.capes.no_cape"));
            } else {
                MSApi.MCProfile.OnlineCape cape = (MSApi.MCProfile.OnlineCape)capes.get(i - 1);
                widget = this.createEntryForCape(this.current.getSkin(), (Cape)cape, this.capesList.getEntryContentsHeight());
            }
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            widgets.add(widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= capes.size() + 1 - c) continue;
                MSApi.MCProfile.OnlineCape cape2 = (MSApi.MCProfile.OnlineCape)capes.get(i + c - 1);
                Entry widget2 = this.createEntryForCape(this.current.getSkin(), (Cape)cape2, this.capesList.getEntryContentsHeight());
                widgets.add(widget2);
            }
            rows.add(new Row(widgets));
        }
        this.field_22787.execute(() -> this.capesList.method_25314(rows));
    }

    private void loadSkinsList() {
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.field_22789 / 2 - 25) / 75);
        ArrayList<Skin> skins = new ArrayList<Skin>(profile.skins());
        Set hashes = skins.stream().map(Asset::sha256).collect(Collectors.toSet());
        Skin defaultSkin = Skin.getDefaultSkin((Account)this.account);
        ArrayList<Skin> local = new ArrayList<Skin>(this.loadLocalSkins());
        Map localHashes = local.stream().collect(Collectors.toMap(Asset::sha256, Function.identity(), (skin, skin2) -> skin));
        local.removeIf(s -> !localHashes.containsValue(s));
        skins.replaceAll(s -> {
            if (s instanceof MSApi.MCProfile.OnlineSkin) {
                Object patt0$temp;
                MSApi.MCProfile.OnlineSkin online = (MSApi.MCProfile.OnlineSkin)s;
                if (localHashes.containsKey(s.sha256()) && (patt0$temp = localHashes.get(s.sha256())) instanceof Skin.LocalSkin) {
                    Skin.LocalSkin file = (Skin.LocalSkin)patt0$temp;
                    local.remove(localHashes.remove(s.sha256()));
                    return new Skin.Shared((Skin.Local)file, online);
                }
            }
            return s;
        });
        skins.addAll(local);
        if (!hashes.contains(defaultSkin.sha256())) {
            skins.add(defaultSkin);
        }
        this.populateSkinList(skins, columns);
    }

    private List<Skin> loadLocalSkins() {
        List<Skin> list;
        block8: {
            Files.createDirectories(SKINS_DIR, new FileAttribute[0]);
            Stream<Path> skins = Files.list(SKINS_DIR);
            try {
                list = skins.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).map(Auth.getInstance().getSkinManager()::read).filter(Objects::nonNull).toList();
                if (skins == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (skins != null) {
                        try {
                            skins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to read skins dir!", new Object[]{e});
                    return Collections.emptyList();
                }
            }
            skins.close();
        }
        return list;
    }

    private void populateSkinList(List<? extends Skin> skins, int columns) {
        int entryHeight = this.skinList.getEntryContentsHeight();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < skins.size(); i += columns) {
            Skin s = skins.get(i);
            if (s != null && s.active()) {
                this.current.setSkin(s);
            }
            Entry widget = this.createEntryForSkin(s, entryHeight);
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            widgets.add(widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= skins.size() - c) continue;
                Skin s2 = skins.get(i + c);
                if (s2 != null && s2.active()) {
                    this.current.setSkin(s2);
                }
                Entry widget2 = this.createEntryForSkin(s2, entryHeight);
                widgets.add(widget2);
            }
            rows.add(new Row(widgets));
        }
        this.field_22787.execute(() -> this.skinList.method_25314(rows));
    }

    private Path ensureNonexistent(Path p) {
        if (Files.exists(p, new LinkOption[0])) {
            int counter = 0;
            while (Files.exists(p = p.resolveSibling(p.getFileName().toString() + "_" + ++counter), new LinkOption[0])) {
            }
        }
        return p;
    }

    public void method_29638(List<Path> packs) {
        if (packs.isEmpty()) {
            return;
        }
        CompletableFuture[] futs = new CompletableFuture[packs.size()];
        for (int i = 0; i < packs.size(); ++i) {
            Path p = packs.get(i);
            futs[i] = CompletableFuture.runAsync(() -> {
                try {
                    Path target = this.ensureNonexistent(SKINS_DIR.resolve(p.getFileName()));
                    Skin skin = Auth.getInstance().getSkinManager().read(p, false);
                    if (skin != null) {
                        Files.write(target, skin.image(), new OpenOption[0]);
                    } else {
                        AxolotlClientCommon.getInstance().getLogger().info("Skipping dragged file {} because it does not seem to be a valid skin!", new Object[]{p});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.not_copied", p.getFileName());
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to copy skin file: ", new Object[]{e});
                }
            }, (Executor)this.field_22787);
        }
        CompletableFuture.allOf(futs).thenRun(this::loadSkinsList);
    }

    @NotNull
    private Entry createEntryForSkin(Skin skin, int entryHeight) {
        return this.createEntry(entryHeight, new SkinWidget(75, 110, skin, this.account));
    }

    @NotNull
    private Entry createEntryForCape(Skin currentSkin, Cape cape, int entryHeight) {
        return this.createEntry(entryHeight, this.createWidgetForCape(currentSkin, cape), (class_2561)new class_2585(cape.alias()));
    }

    private SkinWidget createWidgetForCape(Skin currentSkin, Cape cape) {
        SkinWidget widget2 = new SkinWidget(75, 110, currentSkin, cape, this.account);
        widget2.setRotationY(210.0f);
        return widget2;
    }

    public void method_25410(class_310 client, int width, int height) {
        Auth.getInstance().getSkinManager().releaseAll();
        super.method_25410(client, width, height);
    }

    public void method_25432() {
        Auth.getInstance().getSkinManager().releaseAll();
        Watcher.close((Watcher)this.skinDirWatcher);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private SkinListWidget getCurrentList() {
        return this.capesTab ? this.capesList : this.skinList;
    }

    Entry createEntry(int height, SkinWidget widget) {
        return this.createEntry(height, widget, null);
    }

    Entry createEntry(int height, SkinWidget widget, class_2561 label) {
        return new Entry(height, widget, label);
    }

    private class SkinListWidget
    extends class_4265<Row> {
        public boolean active;
        public boolean visible;

        public SkinListWidget(class_310 minecraft, int width, int height, int y, int entryHeight) {
            super(minecraft, width, SkinManagementScreen.this.field_22790, y, y + height, entryHeight);
            this.active = true;
            this.visible = true;
            this.method_25315(false, 0);
        }

        protected int method_25329() {
            return this.field_19087 - 8;
        }

        public int method_25342() {
            return this.field_19088 + 3;
        }

        public int method_25322() {
            if (this.getMaxScroll() <= 0) {
                return this.field_22742 - 4;
            }
            return this.field_22742 - 14;
        }

        private int getMaxScroll() {
            return Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
        }

        public int getEntryContentsHeight() {
            return this.field_22741 - 4;
        }

        public void method_25314(Collection<Row> newEntries) {
            super.method_25314(newEntries);
        }

        public void centerScrollOn(Row entry) {
            super.method_25324((class_350.class_351)entry);
        }

        public boolean method_25401(double mouseX, double mouseY, double amountY) {
            if (!this.visible) {
                return false;
            }
            return super.method_25401(mouseX, mouseY, amountY);
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.active && this.visible && super.method_25405(mouseX, mouseY);
        }

        public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
            if (!this.visible) {
                return;
            }
            super.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    private class SpriteButton
    extends class_4185 {
        private class_2960 sprite;

        public SpriteButton(class_2561 message, class_4185.class_4241 onPress, class_2960 sprite) {
            super(0, 0, 11, 11, message, onPress);
            this.sprite = sprite;
        }

        public void method_25359(class_4587 graphics, int mouseX, int mouseY, float delta) {
            class_2960 tex = ButtonWidgetTextures.get(this.method_25356(this.field_22762));
            DrawUtil.blitSprite(tex, this.field_22760, this.field_22761, this.field_22758, this.field_22759, new DrawUtil.NineSlice(200, 20, 3));
            SkinManagementScreen.this.field_22787.method_1531().method_22813(this.sprite);
            SpriteButton.method_25290((class_4587)graphics, (int)(this.field_22760 + 2), (int)(this.field_22761 + 2), (float)0.0f, (float)0.0f, (int)7, (int)7, (int)7, (int)7);
            if (this.method_25367()) {
                SkinManagementScreen.this.tooltip = this.method_25369();
            }
        }
    }

    private class Entry
    extends class_339
    implements class_4069 {
        private final SkinWidget skinWidget;
        @Nullable
        private final class_339 label;
        private final List<class_339> actionButtons;
        private final class_339 equipButton;
        private boolean equipping;
        private long equippingStart;
        @Nullable
        private class_364 focused;
        private boolean dragging;

        public Entry(int height, @Nullable SkinWidget widget, class_2561 label) {
            super(0, 0, widget.method_25368(), height, class_2585.field_24366);
            this.actionButtons = new ArrayList<class_339>();
            widget.method_25358(this.method_25368() - 4);
            Asset asset = widget.getFocusedAsset();
            if (asset instanceof Skin) {
                Skin skin = (Skin)asset;
                class_2960 wideSprite = new class_2960("axolotlclient", "textures/gui/sprites/wide.png");
                class_2960 slimSprite = new class_2960("axolotlclient", "textures/gui/sprites/slim.png");
                class_2588 slimText = new class_2588("skins.manage.variant.classic");
                class_2588 wideText = new class_2588("skins.manage.variant.slim");
                this.actionButtons.add((class_339)new SpriteButton((class_2561)(skin.classicVariant() ? wideText : slimText), btn -> {
                    SpriteButton self = (SpriteButton)btn;
                    skin.classicVariant(!skin.classicVariant());
                    self.sprite = skin.classicVariant() ? slimSprite : wideSprite;
                    self.method_25355((class_2561)(skin.classicVariant() ? wideText : slimText));
                }, skin.classicVariant() ? slimSprite : wideSprite));
            }
            if (asset != null) {
                Asset.Online online;
                if (asset instanceof Asset.Local) {
                    Asset.Local local = (Asset.Local)asset;
                    this.actionButtons.add((class_339)new SpriteButton((class_2561)new class_2588("skins.manage.delete"), btn -> {
                        btn.field_22763 = false;
                        SkinManagementScreen.this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                            SkinManagementScreen.this.field_22787.method_1507((class_437)new LoadingScreen(SkinManagementScreen.this.method_25440(), (class_2561)new class_2588("menu.working")));
                            if (confirmed) {
                                try {
                                    Files.delete(local.file());
                                    Skin.LocalSkin.deleteMetadata((Path)local.file());
                                }
                                catch (IOException e) {
                                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to delete: ", new Object[]{e});
                                }
                            }
                            SkinManagementScreen.this.field_22787.method_1507((class_437)SkinManagementScreen.this);
                            btn.field_22763 = true;
                        }, (class_2561)new class_2588("skins.manage.delete.confirm"), (class_2561)(asset.active() ? new class_2588("skins.manage.delete.confirm.desc_active") : new class_2588("skins.manage.delete.confirm.desc")).br$color(Colors.RED.toInt())));
                    }, new class_2960("axolotlclient", "textures/gui/sprites/delete.png")));
                }
                if (asset instanceof Asset.Online && (online = (Asset.Online)asset).supportsDownload() && !(asset instanceof Asset.Local)) {
                    this.actionButtons.add((class_339)new SpriteButton((class_2561)new class_2588("skins.manage.download"), btn -> {
                        btn.field_22763 = false;
                        this.download(asset).thenRun(() -> {
                            SkinManagementScreen.this.refreshCurrentList();
                            btn.field_22763 = true;
                        });
                    }, new class_2960("axolotlclient", "textures/gui/sprites/download.png")));
                }
            }
            if (label != null) {
                this.label = new class_339(0, 0, widget.method_25368(), 16, label){

                    public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
                        DrawUtil.drawScrollableText(guiGraphics, SkinManagementScreen.this.field_22793, this.method_25369(), this.field_22760 + 2, this.field_22761, this.field_22760 + this.field_22758 - 2, this.field_22761 + this.field_22759, -1);
                    }
                };
                this.label.field_22763 = false;
            } else {
                this.label = null;
            }
            this.equipButton = new class_4185(0, 0, widget.method_25368(), 20, (class_2561)new class_2588(widget.isEquipped() ? "skins.manage.equipped" : "skins.manage.equip"), btn -> {
                this.equippingStart = class_156.method_658();
                this.equipping = true;
                btn.method_25355(TEXT_EQUIPPING);
                btn.field_22763 = false;
                Consumer<CompletableFuture> consumer = f -> ((CompletableFuture)f.thenAcceptAsync(p -> {
                    SkinManagementScreen.this.cachedProfile = p;
                    if (((SkinManagementScreen)SkinManagementScreen.this).field_22787.field_1755 == SkinManagementScreen.this) {
                        SkinManagementScreen.this.refreshCurrentList();
                    } else {
                        SkinManagementScreen.this.field_22787.execute(() -> SkinManagementScreen.this.field_22787.method_1507((class_437)SkinManagementScreen.this));
                    }
                })).exceptionally(t -> {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to equip asset!", new Object[]{t});
                    this.equipping = false;
                    return null;
                });
                if (asset instanceof Skin && !(SkinManagementScreen.this.current.getSkin() instanceof Skin.Local)) {
                    SkinManagementScreen.this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                        SkinManagementScreen.this.field_22787.method_1507((class_437)new LoadingScreen(SkinManagementScreen.this.method_25440(), TEXT_EQUIPPING));
                        if (confirmed) {
                            consumer.accept((CompletableFuture)this.download((Asset)SkinManagementScreen.this.current.getSkin()).thenCompose(a -> widget.equip()));
                        } else {
                            consumer.accept(widget.equip());
                        }
                    }, (class_2561)new class_2588("skins.manage.equip.confirm"), (class_2561)new class_2588("skins.manage.equip.download_current")));
                } else {
                    consumer.accept(widget.equip());
                }
            });
            this.equipButton.field_22763 = !widget.isEquipped();
            this.skinWidget = widget;
        }

        @NotNull
        private CompletableFuture<?> download(Asset asset) {
            return CompletableFuture.runAsync(() -> {
                try {
                    Path out = SKINS_DIR.resolve(asset.sha256());
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                    Files.write(out, asset.image(), new OpenOption[0]);
                    if (asset instanceof Skin) {
                        Skin skin = (Skin)asset;
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", skin.classicVariant()));
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to download: ", new Object[]{e});
                }
            });
        }

        public final boolean method_25397() {
            return this.dragging;
        }

        public final void method_25398(boolean dragging) {
            this.dragging = dragging;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }

        public void method_25395(@Nullable class_364 child) {
            this.focused = child;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return super.method_25406(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean method_25370() {
            return this.method_25399() != null;
        }

        public void method_25365(boolean focused) {
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Stream.concat(this.actionButtons.stream(), Stream.of(new class_339[]{this.skinWidget, this.label, this.equipButton})).filter(Objects::nonNull).toList();
        }

        private float applyEasing(float x) {
            return x * x * x;
        }

        public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int y = this.field_22761 + 4;
            int x = this.field_22760 + 2;
            this.skinWidget.setPosition(x, y);
            this.skinWidget.method_25358(this.method_25368() - 4);
            if (this.skinWidget.isEquipped() || this.equipping) {
                long prog = ((Boolean)Auth.getInstance().skinManagerAnimations.get()).booleanValue() ? (this.equipping ? (class_156.method_658() - this.equippingStart) / 20L % 100L : Math.abs(class_156.method_658() / 30L % 200L - 100L)) : 100L;
                float percent = (float)prog / 100.0f;
                float gradientWidth = this.equipping ? percent * Math.min((float)this.method_25368() / 3.0f, (float)this.method_25364() / 3.0f) : Math.min((float)this.method_25368() / 15.0f, (float)this.method_25364() / 6.0f) + this.applyEasing(percent) * Math.min((float)(this.method_25368() * 2) / 15.0f, (float)this.method_25364() / 6.0f);
                GradientHoleRectangleRenderState.render(guiGraphics, this.field_22760 + 2, this.field_22761 + 2, this.field_22760 + this.method_25368() - 2, this.skinWidget.getY() + this.skinWidget.method_25364() + 2, gradientWidth, this.equipping ? -65400 : ClientColors.SELECTOR_GREEN.toInt(), 0);
            }
            this.skinWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            int actionButtonY = this.field_22761 + 2;
            for (class_339 button : this.actionButtons) {
                button.field_22760 = this.skinWidget.getX() + this.skinWidget.method_25368() - button.method_25368();
                button.field_22761 = actionButtonY;
                if (this.method_25367() || button.method_25367()) {
                    button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
                actionButtonY += button.method_25364() + 2;
            }
            if (this.label != null) {
                this.label.field_22760 = x;
                this.label.field_22761 = this.skinWidget.getY() + this.skinWidget.method_25364() + 6;
                this.label.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                this.label.method_25358(this.method_25368() - 4);
                this.equipButton.field_22760 = x;
                this.equipButton.field_22761 = this.label.field_22761 + this.label.method_25364() + 2;
            } else {
                this.equipButton.field_22760 = x;
                this.equipButton.field_22761 = this.skinWidget.getY() + this.skinWidget.method_25364() + 4;
            }
            this.equipButton.method_25358(this.method_25368() - 4);
            this.equipButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (this.method_25367()) {
                guiGraphics.br$outlineRect(this.field_22760, this.field_22761, this.method_25368(), this.method_25364(), -1);
            }
        }

        private static class GradientHoleRectangleRenderState {
            private GradientHoleRectangleRenderState() {
            }

            public static void render(class_4587 graphics, int x0, int y0, int x1, int y1, float gradientWidth, int col1, int col2) {
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.disableAlphaTest();
                RenderSystem.defaultBlendFunc();
                RenderSystem.shadeModel((int)7425);
                class_289 tessellator = class_289.method_1348();
                class_287 vertexConsumer = tessellator.method_1349();
                float z = 0.0f;
                class_1159 pose = graphics.method_23760().method_23761();
                vertexConsumer.method_1328(7, class_290.field_1576);
                vertexConsumer.method_22918(pose, (float)x0, (float)y0, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y0 + gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y0 + gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y0, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0, (float)y1, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y1 - gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y0 + gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0, (float)y0, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y1, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y1 - gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y1 - gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x0, (float)y1, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y0, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y0 + gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y1 - gradientWidth, z).method_1336(col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF, col2 >> 24 & 0xFF).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y1, z).method_1336(col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col1 >> 24 & 0xFF).method_1344();
                tessellator.method_1350();
                RenderSystem.shadeModel((int)7424);
                RenderSystem.disableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
            }
        }
    }

    private class Row
    extends class_4265.class_4266<Row> {
        private final List<class_339> widgets;

        public Row(List<class_339> entries) {
            this.widgets = entries;
        }

        public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int x = left;
            if (this.widgets.isEmpty()) {
                return;
            }
            int count = this.widgets.size();
            int padding = (width - 5 * (count - 1)) / count;
            for (class_339 w : this.widgets) {
                w.field_22760 = x;
                w.field_22761 = top;
                w.method_25358(padding);
                w.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                x += w.method_25368() + 5;
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public void method_25395(@Nullable class_364 focused) {
            super.method_25395(focused);
            if (focused != null) {
                SkinManagementScreen.this.getCurrentList().centerScrollOn(this);
            }
        }
    }
}

