/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import com.google.common.hash.Hashing;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.mixin.skins.PlayerSkinTextureAccessor;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.util.ClientColors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SkinManager {
    private final Set<AxoIdentifier> loadedTextures = new ConcurrentSkipListSet<AxoIdentifier>(Comparator.comparing(Object::toString));

    public Skin read(Path p) {
        return this.read(p, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Skin read(Path p, boolean fix) {
        try {
            boolean bl;
            boolean slim;
            byte[] in = Files.readAllBytes(p);
            String sha256 = Hashing.sha256().hashBytes(in).toString();
            try (ByteArrayInputStream stream = new ByteArrayInputStream(in);
                 class_1011 img = class_1011.method_4309((InputStream)stream);){
                int width = img.method_4307();
                int height = img.method_4323();
                if (width != 64) {
                    Skin skin = null;
                    return skin;
                }
                if (height == 32) {
                    if (fix) {
                        try (class_1011 img2 = PlayerSkinTextureAccessor.invokeRemapTexture(img);){
                            img2.method_4314(p);
                        }
                    }
                    slim = false;
                } else {
                    if (height != 64) {
                        Skin img2 = null;
                        return img2;
                    }
                    slim = ClientColors.ARGB.alpha((int)img.method_4315(50, 16)) == 0;
                }
                Map metadata = Skin.LocalSkin.readMetadata((Path)p);
                if (metadata != null && metadata.containsKey("variant_classic")) {
                    slim = (Boolean)metadata.get("variant_classic") == false;
                }
            }
            if (!slim) {
                bl = true;
                return new Skin.LocalSkin(bl, p, in, sha256);
            }
            bl = false;
            return new Skin.LocalSkin(bl, p, in, sha256);
        }
        catch (Exception e) {
            AxolotlClientCommon.getInstance().getLogger().warn("Failed to probe skin: ", new Object[]{e});
            return null;
        }
    }

    public AxoIdentifier loadSkin(Skin skin) {
        AxoIdentifier rl = AxoIdentifier.of((String)"axolotlclient", (String)("skins/" + skin.sha256()));
        if (this.loadedTextures.contains(rl)) {
            return rl;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(skin.image());){
            class_1043 tex = new class_1043(class_1011.method_4309((InputStream)stream));
            tex.method_4524();
            class_310.method_1551().method_1531().method_4616((class_2960)rl, (class_1044)tex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.loadedTextures.add(rl);
        return rl;
    }

    public AxoIdentifier loadCape(Cape cape) {
        AxoIdentifier rl = AxoIdentifier.of((String)"axolotlclient", (String)("capes/" + cape.id()));
        if (this.loadedTextures.contains(rl)) {
            return rl;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(cape.image());){
            class_1043 tex = new class_1043(class_1011.method_4309((InputStream)stream));
            class_310.method_1551().method_1531().method_4616((class_2960)rl, (class_1044)tex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.loadedTextures.add(rl);
        return rl;
    }

    public void releaseAll() {
        this.loadedTextures.forEach(id -> class_310.method_1551().method_1531().method_4615((class_2960)id));
        this.loadedTextures.clear();
    }
}

