/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.Asset;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.modules.auth.skin.SkinManager;
import io.github.axolotlclient.modules.auth.skin.SkinRenderer;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_1144;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SkinWidget
extends class_339 {
    private static final float MODEL_HEIGHT = 2.125f;
    private static final float FIT_SCALE = 0.97f;
    private static final float ROTATION_SENSITIVITY = 2.5f;
    private static final float DEFAULT_ROTATION_X = -5.0f;
    private static final float DEFAULT_ROTATION_Y = 30.0f;
    private static final float ROTATION_X_LIMIT = 50.0f;
    private float rotationX = -5.0f;
    private float rotationY = 30.0f;
    private Skin skin;
    private Cape cape;
    private final Account owner;
    private boolean noCape;
    private boolean noCapeActive;

    public SkinWidget(int width, int height, Skin skin, @Nullable Cape cape, Account owner) {
        super(0, 0, width, height, class_2585.field_24366);
        this.skin = skin;
        this.cape = cape;
        this.owner = owner;
    }

    public SkinWidget(int width, int height, Skin skin, Account owner) {
        this(width, height, skin, null, owner);
    }

    public void noCape(boolean noCapeActive) {
        this.noCape = true;
        this.noCapeActive = noCapeActive;
    }

    public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scale = 0.97f * (float)this.method_25364() / 2.125f;
        float pivotY = -1.0625f;
        SkinManager skinManager = Auth.getInstance().getSkinManager();
        AxoIdentifier skinRl = skinManager.loadSkin(this.skin);
        boolean classic = this.skin.classicVariant();
        AxoIdentifier capeRl = this.cape == null ? null : skinManager.loadCape(this.cape);
        SkinRenderer.render(guiGraphics, classic, (class_2960)skinRl, (class_2960)capeRl, this.rotationX, this.rotationY, pivotY, this.getX(), this.getY(), this.getX() + this.method_25368(), this.getY() + this.method_25364(), scale);
    }

    public int getY() {
        return this.field_22761;
    }

    public int getX() {
        return this.field_22760;
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.rotationX = class_3532.method_15363((float)(this.rotationX - (float)dragY * 2.5f), (float)-50.0f, (float)50.0f);
        this.rotationY += (float)dragX * 2.5f;
    }

    public void method_25354(class_1144 handler) {
    }

    protected class_5250 method_25360() {
        return class_2585.field_24366.method_27662();
    }

    public boolean method_25407(boolean lookForwards) {
        return false;
    }

    public boolean isEquipped() {
        return this.noCape ? this.noCapeActive : (this.cape != null ? this.cape.active() : this.skin != null && this.skin.active());
    }

    public CompletableFuture<MSApi.MCProfile> equip() {
        MSApi msApi = Auth.getInstance().getMsApi();
        if (this.noCape) {
            return msApi.hideCape(this.owner);
        }
        if (this.cape != null) {
            return this.cape.equip(msApi, this.owner);
        }
        if (this.skin != null) {
            return this.skin.equip(msApi, this.owner);
        }
        return msApi.resetSkin(this.owner);
    }

    public Asset getFocusedAsset() {
        return this.noCape ? null : (this.cape != null ? this.cape : this.skin);
    }

    public void setPosition(int x, int y) {
        this.field_22760 = x;
        this.field_22761 = y;
    }

    @Generated
    public void setRotationY(float rotationY) {
        this.rotationY = rotationY;
    }

    @Generated
    public Skin getSkin() {
        return this.skin;
    }

    @Generated
    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    @Generated
    public Cape getCape() {
        return this.cape;
    }

    @Generated
    public void setCape(Cape cape) {
        this.cape = cape;
    }
}

