/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.blur;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.ClientColors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import net.minecraft.class_279;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class MenuBlur
extends AbstractModule {
    private static final MenuBlur Instance = new MenuBlur();
    public final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    private final class_2960 shaderLocation = new class_2960("minecraft:shaders/post/menu_blur.json");
    private final IntegerOption strength = new IntegerOption("strength", Integer.valueOf(8), Integer.valueOf(0), Integer.valueOf(100));
    private final IntegerOption fadeTime = new IntegerOption("fadeTime", Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(10));
    private final ColorOption bgColor = new ColorOption("bgcolor", new Color(0x64000000));
    private final OptionCategory category = OptionCategory.create((String)"menublur");
    private final Color black = new Color(0);
    private long openTime;
    private class_279 shader;
    private int lastWidth;
    private int lastHeight;

    public void init() {
        this.category.add(new Option[]{this.enabled, this.strength, this.fadeTime, this.bgColor});
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.category});
        AxolotlClient.runtimeResources.put(this.shaderLocation, new MenuBlurShader());
    }

    public boolean renderScreen(class_4587 matrices) {
        if (((Boolean)this.enabled.get()).booleanValue() && !(class_310.method_1551().field_1755 instanceof class_408) && this.shader != null) {
            class_332.method_25294((class_4587)matrices, (int)0, (int)0, (int)class_310.method_1551().method_1522().field_1482, (int)class_310.method_1551().method_1522().field_1481, (int)ClientColors.blend((Color)this.black, (Color)this.bgColor.get(), (float)this.getProgress()).toInt());
            return true;
        }
        return false;
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.openTime) / ((float)((Integer)this.fadeTime.get()).intValue() * 1000.0f), 1.0f);
    }

    public void updateBlur() {
        if (((Boolean)this.enabled.get()).booleanValue() && class_310.method_1551().field_1755 != null && !(class_310.method_1551().field_1755 instanceof class_408)) {
            if ((this.shader == null || class_310.method_1551().method_1522().field_1482 != this.lastWidth || class_310.method_1551().method_1522().field_1481 != this.lastHeight) && class_310.method_1551().method_1522().field_1482 > 0 && class_310.method_1551().method_1522().field_1481 > 0) {
                try {
                    this.shader = new class_279(this.client.method_1531(), this.client.method_1478(), this.client.method_1522(), this.shaderLocation);
                    this.shader.method_1259(this.client.method_1522().field_1482, this.client.method_1522().field_1481);
                }
                catch (IOException e) {
                    AxolotlClient.LOGGER.error("Failed to load Menu Blur: ", new Object[]{e});
                    return;
                }
            }
            if (this.shader != null) {
                ((ShaderEffectAccessor)this.shader).getPasses().forEach(shader -> {
                    class_284 radius = shader.method_1295().method_1271("Radius");
                    class_284 progress = shader.method_1295().method_1271("Progress");
                    if (radius != null) {
                        radius.method_1251((float)((Integer)this.strength.get()).intValue());
                    }
                    if (progress != null) {
                        if ((Integer)this.fadeTime.get() > 0) {
                            progress.method_1251(this.getProgress());
                        } else {
                            progress.method_1251(1.0f);
                        }
                    }
                });
            }
            this.lastWidth = this.client.method_1522().field_1482;
            this.lastHeight = this.client.method_1522().field_1481;
            this.renderBlur();
        }
    }

    public void renderBlur() {
        this.shader.method_1258(class_310.method_1551().method_1488());
        RenderSystem.enableTexture();
    }

    public void onScreenOpen() {
        this.openTime = System.currentTimeMillis();
    }

    @Generated
    public static MenuBlur getInstance() {
        return Instance;
    }

    private static class MenuBlurShader
    implements class_3298 {
        private MenuBlurShader() {
        }

        public class_2960 method_14483() {
            return null;
        }

        public InputStream method_14482() {
            return IOUtils.toInputStream((String)"{\n    \"targets\": [\n        \"swap\"\n    ],\n    \"passes\": [\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"minecraft:main\",\n            \"outtarget\": \"swap\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 1.0, 0.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        },\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"swap\",\n            \"outtarget\": \"minecraft:main\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 0.0, 1.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        },\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"minecraft:main\",\n            \"outtarget\": \"swap\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 1.0, 0.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        },\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"swap\",\n            \"outtarget\": \"minecraft:main\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 0.0, 1.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        }\n    ]\n}", (Charset)StandardCharsets.UTF_8);
        }

        @Nullable
        public <T> T method_14481(class_3270<T> metaReader) {
            return null;
        }

        public String method_14480() {
            return null;
        }

        public void close() throws IOException {
        }
    }
}

