/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.component.HudEntry;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class HudEditScreen
extends class_437 {
    private static final BooleanOption snapping = new BooleanOption("snapping", Boolean.valueOf(true));
    private static final OptionCategory hudEditScreenCategory = OptionCategory.create((String)"hudEditScreen");
    private final class_437 parent;
    private HudEntry current;
    private DrawPosition offset = null;
    private boolean mouseDown;
    private SnappingHelper snap;

    public static boolean isSnappingEnabled() {
        return (Boolean)snapping.get();
    }

    public static void toggleSnapping() {
        snapping.toggle();
    }

    public HudEditScreen() {
        this(null);
    }

    public HudEditScreen(class_437 parent) {
        super(class_2585.field_24366);
        this.updateSnapState();
        this.mouseDown = false;
        this.parent = parent;
    }

    private void updateSnapState() {
        if (((Boolean)snapping.get()).booleanValue() && this.current != null) {
            List bounds = HudManager.getInstance().getAllBounds();
            bounds.remove(this.current.getTrueBounds());
            this.snap = new SnappingHelper(bounds, this.current.getTrueBounds());
        } else if (this.snap != null) {
            this.snap = null;
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (class_310.method_1551().field_1687 != null) {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1341125106, 1176576032);
        } else {
            this.method_25434(0);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        Optional entry = HudManager.getInstance().getEntryXY(mouseX, mouseY);
        entry.ifPresent(abstractHudEntry -> abstractHudEntry.setHovered(true));
        HudManager.getInstance().renderPlaceholder((AxoRenderContext)matrices, delta);
        if (this.mouseDown && this.snap != null) {
            this.snap.renderSnaps(matrices);
        }
    }

    public void method_25426() {
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 50, this.field_22790 / 2 + 12, 100, 20, (class_2561)new class_2588("hud.snapping").method_27693(": ").method_10852((class_2561)new class_2588((Boolean)snapping.get() != false ? "options.on" : "options.off")), buttonWidget -> {
            snapping.toggle();
            buttonWidget.method_25355((class_2561)new class_2588("hud.snapping").method_27693(": ").method_10852((class_2561)new class_2588((Boolean)snapping.get() != false ? "options.on" : "options.off")));
            AxolotlClient.getInstance().saveConfig();
        }));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 75, this.field_22790 / 2 - 10, 150, 20, (class_2561)new class_2588("hud.clientOptions"), buttonWidget -> {
            class_437 screen = ConfigStyles.createScreen((class_437)this, (OptionCategory)AxolotlClient.getInstance().getConfig().config);
            class_310.method_1551().method_1507(screen);
        }));
        if (this.parent != null) {
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 75, this.field_22790 - 50 + 22, 150, 20, class_5244.field_24339, buttonWidget -> class_310.method_1551().method_1507(this.parent)));
        } else {
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 75, this.field_22790 - 50 + 22, 150, 20, (class_2561)new class_2588("close"), buttonWidget -> class_310.method_1551().method_1507(null)));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        Optional entry = HudManager.getInstance().getEntryXY((int)Math.round(mouseX), (int)Math.round(mouseY));
        if (button == 0) {
            this.mouseDown = true;
            if (entry.isPresent()) {
                this.current = (HudEntry)entry.get();
                this.offset = new DrawPosition((int)Math.round(mouseX - (double)this.current.getTruePos().x()), (int)Math.round(mouseY - (double)this.current.getTruePos().y()));
                this.updateSnapState();
                return true;
            }
            this.current = null;
        } else if (button == 1) {
            entry.ifPresent(abstractHudEntry -> {
                class_437 screen = ConfigStyles.createScreen((class_437)this, (OptionCategory)abstractHudEntry.getCategory());
                class_310.method_1551().method_1507(screen);
            });
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.current != null) {
            AxolotlClientConfig.getInstance().getConfigManager(this.current.getCategory()).save();
        }
        this.current = null;
        this.snap = null;
        this.mouseDown = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.current != null) {
            this.current.setX((int)mouseX - this.offset.x() + this.current.offsetTrueWidth());
            this.current.setY((int)mouseY - this.offset.y() + this.current.offsetTrueHeight());
            if (this.snap != null) {
                Integer snapY;
                this.snap.setCurrent(this.current.getTrueBounds());
                Integer snapX = this.snap.getCurrentXSnap();
                if (snapX != null) {
                    this.current.setX(snapX + this.current.offsetTrueWidth());
                }
                if ((snapY = this.snap.getCurrentYSnap()) != null) {
                    this.current.setY(snapY + this.current.offsetTrueHeight());
                }
            }
            if (this.current.tickable()) {
                this.current.tick();
            }
            return true;
        }
        return false;
    }

    static {
        hudEditScreenCategory.add(new Option[]{snapping});
        AxolotlClient.config().hidden.add(new OptionCategory[]{hudEditScreenCategory});
    }
}

