/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PackDisplayHud
extends TextHudEntry {
    public static final class_2960 ID = new class_2960("axolotlclient", "packdisplayhud");
    private final List<PackWidget> widgets = new ArrayList<PackWidget>();
    private final BooleanOption iconsOnly = new BooleanOption("iconsonly", Boolean.valueOf(false));
    private PackWidget placeholder;
    private final class_310 client;

    public PackDisplayHud() {
        super(200, 50, true);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext matrices, float f) {
        DrawPosition pos = this.getPos();
        if (this.widgets.isEmpty()) {
            this.init();
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            DrawUtil.fillRect((class_4587)matrices, this.getBounds(), this.backgroundColor.get());
        }
        if (((Boolean)this.outline.get()).booleanValue()) {
            DrawUtil.outlineRect((class_4587)matrices, this.getBounds(), this.outlineColor.get());
        }
        int y = pos.y + 1;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            this.widgets.get(i).render((class_4587)matrices, pos.x + 1, y);
            y += 18;
        }
        if (y - pos.y + 1 != this.getHeight()) {
            this.setHeight(y - pos.y - 1);
            this.onBoundsUpdate();
        }
    }

    public void init() {
        int listSize = this.client.method_1520().method_14441().size();
        class_310.method_1551().method_1520().method_14444().forEach(profile -> {
            try (class_3262 pack = profile.method_14458();){
                if (listSize == 1) {
                    this.widgets.add(this.createWidget(profile.method_14457(), pack));
                } else if (!pack.method_14409().equalsIgnoreCase("vanilla")) {
                    this.widgets.add(this.createWidget(profile.method_14457(), pack));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AtomicInteger w = new AtomicInteger(20);
        this.widgets.forEach(packWidget -> {
            int textW = class_310.method_1551().field_1772.method_1727(packWidget.getName()) + 20;
            if (textW > w.get()) {
                w.set(textW);
            }
        });
        this.setWidth(w.get());
        this.setHeight(this.widgets.size() * 18);
        this.onBoundsUpdate();
    }

    private PackWidget createWidget(class_2561 displayName, class_3262 pack) throws IOException, AssertionError {
        InputStream supplier = pack.method_14410("pack.png");
        assert (supplier != null);
        int texture = new class_1043(class_1011.method_4309((InputStream)supplier)).method_4624();
        supplier.close();
        return new PackWidget(displayName, texture);
    }

    public void renderPlaceholderComponent(AxoRenderContext matrices, float f) {
        boolean updateBounds = false;
        if (this.getHeight() < 18) {
            this.setHeight(18);
            updateBounds = true;
        }
        if (this.getWidth() < 56) {
            this.setWidth(56);
            updateBounds = true;
        }
        if (updateBounds) {
            this.onBoundsUpdate();
        }
        if (this.placeholder == null) {
            try (class_3268 defaultPack = class_310.method_1551().method_1516().method_4633();){
                this.placeholder = this.createWidget(class_2561.method_30163((String)defaultPack.method_14409()), (class_3262)defaultPack);
            }
            catch (Exception exception) {}
        } else {
            this.placeholder.render((class_4587)matrices, this.getPos().x + 1, this.getPos().y + 1);
        }
    }

    public boolean movable() {
        return true;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.iconsOnly);
        return options;
    }

    public class_2960 getId() {
        return ID;
    }

    public void update() {
        this.widgets.clear();
        this.init();
    }

    private class PackWidget {
        public final String name;
        private final int texture;

        public PackWidget(class_2561 name, int textureId) {
            this.name = name.getString();
            this.texture = textureId;
        }

        public void render(class_4587 matrices, int x, int y) {
            if (!((Boolean)PackDisplayHud.this.iconsOnly.get()).booleanValue()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.bindTexture((int)this.texture);
                class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            DrawUtil.drawString(matrices, this.name, (float)(x + 18), (float)(y + 6), PackDisplayHud.this.textColor.get().toInt(), (boolean)((Boolean)PackDisplayHud.this.shadow.get()));
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

