/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.hud.PlayerHudCommon;
import lombok.Generated;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;

public class PlayerHud
extends PlayerHudCommon {
    public static final class_2960 ID = new class_2960("kronhud", "playerhud");
    private static boolean currentlyRendering;

    public PlayerHud() {
        Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
    }

    public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
        this.yawOffset += (event.yaw() - event.prevYaw()) / 2.0f;
    }

    public void tick() {
        super.tick();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_20232()) {
            float rawPitch = client.field_1724.method_5799() ? -90.0f - client.field_1724.method_5695(0.0f) : -90.0f;
            float pitch = class_3532.method_16439((float)client.field_1724.method_6024(1.0f), (float)0.0f, (float)rawPitch);
            float height = client.field_1724.method_17682();
            float offset = (float)(Math.sin(Math.toRadians(pitch)) * (double)height);
            this.yOffset = Math.abs(offset) + 35.0f;
        } else if (client.field_1724 != null && client.field_1724.method_6128()) {
            float j = (float)client.field_1724.method_6003() + 1.0f;
            float k = class_3532.method_15363((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
            float pitch = k * (-90.0f - client.field_1724.method_5695(0.0f)) + 90.0f;
            float height = client.field_1724.method_17682();
            float offset = (float)(Math.sin(Math.toRadians(pitch)) * (double)height) * 50.0f;
            this.yOffset = 35.0f - offset;
            if (pitch < 0.0f) {
                this.yOffset -= (float)((1.0 / (1.0 + Math.exp(-pitch / 4.0f)) - 0.5) * 20.0);
            }
        } else {
            this.yOffset *= 0.8f;
        }
    }

    protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (!placeholder && ((Boolean)this.autoHide.get()).booleanValue()) {
            if (this.isPerformingAction()) {
                this.hide = -1L;
            } else if (this.hide == -1L) {
                this.hide = System.currentTimeMillis();
            }
            if (this.hide != -1L && System.currentTimeMillis() - this.hide > 500L) {
                return;
            }
        }
        float lerpY = this.lastYOffset + (this.yOffset - this.lastYOffset) * delta;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)(y - (double)lerpY), (double)1050.0);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        class_4587 nextStack = new class_4587();
        nextStack.method_22904(0.0, 0.0, 1000.0);
        float scale = this.getScale() * 40.0f;
        nextStack.method_22905(scale, scale, scale);
        class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
        nextStack.method_22907(quaternion);
        float deltaYaw = client.field_1724.method_5705(delta);
        if (((Boolean)this.dynamicRotation.get()).booleanValue()) {
            deltaYaw -= this.lastYawOffset + (this.yawOffset - this.lastYawOffset) * delta;
        }
        nextStack.method_22907(new class_1158(new class_1160(0.0f, 1.0f, 0.0f), deltaYaw - 180.0f + ((Double)this.rotation.get()).floatValue(), true));
        float pastYaw = client.field_1724.method_5705(0.0f);
        float pastPrevYaw = client.field_1724.field_5982;
        class_308.method_1450();
        class_898 renderer = client.method_1561();
        renderer.method_24196(quaternion);
        renderer.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        currentlyRendering = true;
        renderer.method_3954((class_1297)client.field_1724, 0.0, 0.0, 0.0, 0.0f, delta, nextStack, (class_4597)immediate, 0xF000F0);
        immediate.method_22993();
        currentlyRendering = false;
        renderer.method_3948(true);
        RenderSystem.popMatrix();
        client.field_1724.method_5636(pastYaw);
        client.field_1724.field_5982 = pastPrevYaw;
        class_308.method_24211();
    }

    private boolean isPerformingAction() {
        class_746 player = class_310.method_1551().field_1724;
        return player.method_5715() || player.method_5624() || player.method_6128() || player.field_7503.field_7479 || player.method_5869() || player.method_20232() || player.method_5765() || player.method_6115() || player.field_6252 || player.field_6235 > 0 || player.method_5809();
    }

    @Generated
    public static boolean isCurrentlyRendering() {
        return currentlyRendering;
    }
}

