/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class DebugCountersHud
extends TextHudEntry
implements DynamicallyPositionable {
    public static final class_2960 ID = new class_2960("axolotlclient", "debugcountershud");
    private final EnumOption<AnchorPoint> anchor = new EnumOption("anchorpoint", AnchorPoint.class, (Object)AnchorPoint.TOP_LEFT);
    private final BooleanOption showCCount = new BooleanOption("debugcounters.ccount", Boolean.valueOf(true));
    private final BooleanOption showECount = new BooleanOption("debugcounters.ecount", Boolean.valueOf(false));
    private final BooleanOption showPCount = new BooleanOption("debugcounters.pcount", Boolean.valueOf(false));
    private final class_310 client;

    public DebugCountersHud() {
        super(115, 32, true);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext context, float delta) {
        class_4587 graphics = (class_4587)context;
        if (this.client.field_1687 == null) {
            this.renderPlaceholderComponent((AxoRenderContext)graphics, delta);
        }
        DrawPosition pos = this.getPos();
        int lineY = pos.y() + 2;
        int lineX = pos.x() + 1;
        int xEnd = lineX + 50;
        if (((Boolean)this.showCCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, this.client.field_1769.method_3289(), (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showECount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, this.client.field_1769.method_3272(), (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showPCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "P: " + this.client.field_1713.method_3052(), (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        boolean boundsChanged = false;
        if (lineY != this.getHeight() + pos.y()) {
            boundsChanged = true;
            this.setHeight(lineY - pos.y());
        }
        if (xEnd != pos.x() + this.getWidth()) {
            boundsChanged = true;
            this.setWidth(xEnd - pos.x());
        }
        if (boundsChanged) {
            this.onBoundsUpdate();
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
        class_4587 graphics = (class_4587)context;
        DrawPosition pos = this.getPos();
        int lineY = pos.y() + 2;
        int lineX = pos.x() + 1;
        int xEnd = lineX + 50;
        if (((Boolean)this.showCCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "C: 186/15000 (s) D: 10, pC: 000, pU: 00, aB: 20", (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showECount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "E: 695/3001, SD: 12", (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showPCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "P: 200", (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        boolean boundsChanged = false;
        if (lineY != this.getHeight() + pos.y()) {
            boundsChanged = true;
            this.setHeight(lineY - pos.y());
        }
        if (xEnd != pos.x() + this.getWidth()) {
            boundsChanged = true;
            this.setWidth(xEnd - pos.x());
        }
        if (boundsChanged) {
            this.onBoundsUpdate();
        }
    }

    public class_2960 getId() {
        return ID;
    }

    public AnchorPoint getAnchor() {
        return (AnchorPoint)this.anchor.get();
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.hide);
        options.add(this.anchor);
        options.add(this.showCCount);
        options.add(this.showECount);
        options.add(this.showPCount);
        return options;
    }
}

