/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.keystrokes;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class KeystrokePositioningScreen
extends Screen {
    private final class_437 parent;
    private final KeystrokeHud hud;
    private KeystrokeHud.Keystroke focused;
    private final KeystrokeHud.Keystroke editing;
    private DrawPosition offset = null;
    private boolean mouseDown;
    private SnappingHelper snap;

    public KeystrokePositioningScreen(class_437 parent, KeystrokeHud hud, KeystrokeHud.Keystroke focused) {
        super("keystrokes.stroke.move");
        this.parent = parent;
        this.hud = hud;
        if (hud.keystrokes == null) {
            hud.setKeystrokes();
        }
        this.editing = focused;
        this.mouseDown = false;
    }

    public KeystrokePositioningScreen(class_437 parent, KeystrokeHud hud) {
        this(parent, hud, null);
    }

    public void method_25426() {
        super.method_25426();
        this.addDrawableChild((class_364)new class_4185(this.field_22789 / 2 - 75, this.field_22790 - 50 + 22, 150, 20, class_5244.field_24339, b -> this.method_25419()));
        this.addDrawableChild((class_364)new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 50, 100, 20, (class_2561)new class_2588("hud.snapping").method_27693(": ").method_10852((class_2561)new class_2588(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off")), buttonWidget -> {
            HudEditScreen.toggleSnapping();
            buttonWidget.method_25355((class_2561)new class_2588("hud.snapping").method_27693(": ").method_10852((class_2561)new class_2588(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off")));
            AxolotlClient.getInstance().saveConfig();
        }));
    }

    public void method_25394(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_22903();
        guiGraphics.method_22904(0.0, 0.0, -300.0);
        super.method_25420(guiGraphics);
        HudManager.getInstance().renderPlaceholder((AxoRenderContext)guiGraphics, partialTick);
        guiGraphics.method_22909();
        this.method_25296(guiGraphics, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.editing != null) {
            this.drawStroke(guiGraphics, mouseX, mouseY, this.editing);
        } else {
            this.hud.keystrokes.forEach(s -> this.drawStroke(guiGraphics, mouseX, mouseY, (KeystrokeHud.Keystroke)s));
        }
        if (this.mouseDown && this.snap != null) {
            this.snap.renderSnaps(guiGraphics);
        }
    }

    private void drawStroke(class_4587 guiGraphics, int mouseX, int mouseY, KeystrokeHud.Keystroke s) {
        Rectangle rect = this.getScaledRenderPos(s);
        if (rect.isMouseOver((double)mouseX, (double)mouseY)) {
            DrawUtil.fillRect(guiGraphics, rect, ClientColors.SELECTOR_BLUE.withAlpha(100));
        } else {
            DrawUtil.fillRect(guiGraphics, rect, ClientColors.WHITE.withAlpha(50));
        }
        guiGraphics.method_22903();
        guiGraphics.method_22905(this.hud.getScale(), this.hud.getScale(), 1.0f);
        s.render(guiGraphics);
        guiGraphics.method_22909();
        DrawUtil.outlineRect(guiGraphics, rect, Colors.BLACK);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean value = super.method_25402(mouseX, mouseY, button);
        if (button == 0) {
            Optional<Object> entry = Optional.empty();
            Optional<Object> pos = Optional.empty();
            if (this.editing == null) {
                for (KeystrokeHud.Keystroke k : this.hud.keystrokes) {
                    pos = Optional.of(this.getScaledRenderPos(k));
                    if (!((Rectangle)pos.get()).isMouseOver(mouseX, mouseY)) continue;
                    entry = Optional.of(k);
                    break;
                }
            } else {
                pos = Optional.of(this.getScaledRenderPos(this.editing));
                if (((Rectangle)pos.get()).isMouseOver(mouseX, mouseY)) {
                    entry = Optional.of(this.editing);
                }
            }
            if (entry.isPresent()) {
                this.focused = (KeystrokeHud.Keystroke)entry.get();
                this.mouseDown = true;
                Rectangle rect = (Rectangle)pos.get();
                this.offset = new DrawPosition((int)Math.round(mouseX - (double)rect.x()), (int)Math.round(mouseY - (double)rect.y()));
                this.updateSnapState();
                return true;
            }
            this.focused = null;
        }
        return value;
    }

    public void method_25419() {
        this.client.method_1507(this.parent);
        this.hud.saveKeystrokes();
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.focused != null) {
            this.hud.saveKeystrokes();
        }
        this.snap = null;
        this.mouseDown = false;
        this.focused = null;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.focused != null && this.mouseDown) {
            this.focused.setX((int)Math.round((mouseX - (double)this.offset.x()) / (double)this.hud.getScale()));
            this.focused.setY((int)Math.round((mouseY - (double)this.offset.y()) / (double)this.hud.getScale()));
            if (this.snap != null) {
                Integer snapY;
                Rectangle rect = this.getScaledRenderPos(this.focused);
                this.snap.setCurrent(rect);
                Integer snapX = this.snap.getCurrentXSnap();
                if (snapX != null) {
                    this.focused.setX((int)((float)snapX.intValue() / this.hud.getScale()));
                }
                if ((snapY = this.snap.getCurrentYSnap()) != null) {
                    this.focused.setY(Math.round((float)snapY.intValue() / this.hud.getScale()));
                }
            }
            return true;
        }
        return false;
    }

    private Rectangle getScaledRenderPos(KeystrokeHud.Keystroke stroke) {
        return stroke.getRenderPosition().scale((double)this.hud.getScale());
    }

    private List<Rectangle> getAllBounds() {
        return Stream.concat(HudManager.getInstance().getAllBounds().stream(), this.hud.keystrokes.stream().map(this::getScaledRenderPos)).toList();
    }

    private void updateSnapState() {
        if (HudEditScreen.isSnappingEnabled() && this.focused != null) {
            this.snap = new SnappingHelper(this.getAllBounds(), this.getScaledRenderPos(this.focused));
        } else if (this.snap != null) {
            this.snap = null;
        }
    }
}

