/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.util;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class DrawUtil
extends class_332 {
    public static void fillRect(class_4587 matrices, Rectangle rectangle, Color color) {
        DrawUtil.fillRect(matrices, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
    }

    public static void fillRect(class_4587 matrices, int x, int y, int width, int height, int color) {
        class_332.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public static void outlineRect(class_4587 matrices, Rectangle rectangle, Color color) {
        DrawUtil.outlineRect(matrices, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
    }

    public static void outlineRect(class_4587 matrices, int x, int y, int width, int height, int color) {
        DrawUtil.fillRect(matrices, x, y, 1, height - 1, color);
        DrawUtil.fillRect(matrices, x + width - 1, y + 1, 1, height - 1, color);
        DrawUtil.fillRect(matrices, x + 1, y, width - 1, 1, color);
        DrawUtil.fillRect(matrices, x, y + height - 1, width - 1, 1, color);
    }

    public static void drawCenteredString(class_4587 matrices, class_327 renderer, String text, int x, int y, Color color, boolean shadow) {
        DrawUtil.drawCenteredString(matrices, renderer, text, x, y, color.toInt(), shadow);
    }

    public static void drawCenteredString(class_4587 matrices, class_327 renderer, String text, int x, int y, int color, boolean shadow) {
        DrawUtil.drawString(matrices, text, (float)(x - renderer.method_1727(text) / 2), (float)y, color, shadow);
    }

    public static int drawString(class_4587 matrices, String text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            return class_310.method_1551().field_1772.method_1720(matrices, text, x, y, color);
        }
        return class_310.method_1551().field_1772.method_1729(matrices, text, x, y, color);
    }

    public static int drawText(class_4587 matrices, class_2561 text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            return class_310.method_1551().field_1772.method_30881(matrices, text, x, y, color);
        }
        return class_310.method_1551().field_1772.method_30883(matrices, text, x, y, color);
    }

    public static void drawString(class_4587 matrices, String text, float x, float y, Color color, boolean shadow) {
        DrawUtil.drawString(matrices, text, x, y, color.toInt(), shadow);
    }

    public static void drawScrollableText(class_4587 matrices, class_327 textRenderer, class_2561 text, int left, int top, int right, int bottom, int color) {
        int i = textRenderer.method_27525((class_5348)text);
        int j = (top + bottom - 9) / 2 + 1;
        int k = right - left;
        if (i > k) {
            int l = i - k;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
            DrawUtil.enableScissor(left, top, right, bottom);
            DrawUtil.method_27535((class_4587)matrices, (class_327)textRenderer, (class_2561)text, (int)(left - (int)g), (int)j, (int)color);
            DrawUtil.disableScissor();
        } else {
            DrawUtil.method_27534((class_4587)matrices, (class_327)textRenderer, (class_2561)text, (int)((left + right) / 2), (int)j, (int)color);
        }
    }

    public static void enableScissor(int x1, int y1, int x2, int y2) {
        io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.pushScissor((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public static void disableScissor() {
        io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.popScissor();
    }

    public static void blitSprite(class_2960 texture, int i, int j, int k, int l, GuiSpriteScaling guiSpriteScaling) {
        DrawUtil.blitSprite(texture, i, j, k, l, -1, guiSpriteScaling);
    }

    public static void blitSprite(class_2960 resourceLocation, int i, int j, int k, int l, int m, GuiSpriteScaling guiSpriteScaling) {
        if (guiSpriteScaling instanceof Stretch) {
            DrawUtil.blitSprite(resourceLocation, i, j, k, l, m);
        } else if (guiSpriteScaling instanceof Tile) {
            Tile tile = (Tile)guiSpriteScaling;
            DrawUtil.blitTiledSprite(resourceLocation, i, j, k, l, 0, 0, tile.width(), tile.height(), tile.width(), tile.height(), m);
        } else if (guiSpriteScaling instanceof NineSlice) {
            NineSlice nineSlice = (NineSlice)guiSpriteScaling;
            DrawUtil.blitNineSlicedSprite(resourceLocation, nineSlice, i, j, k, l, m);
        }
    }

    public static void blitSprite(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, GuiSpriteScaling guiSpriteScaling) {
        if (guiSpriteScaling instanceof Stretch) {
            DrawUtil.blitSprite(resourceLocation, i, j, k, l, m, n, o, p, -1);
        } else {
            DrawUtil.enableScissor(m, n, m + o, n + p);
            DrawUtil.blitSprite(resourceLocation, m - k, n - l, i, j, -1);
            DrawUtil.disableScissor();
        }
    }

    public static void blitSprite(class_2960 texture, int i, int j, int k, int l) {
        DrawUtil.blitSprite(texture, i, j, k, l, -1);
    }

    public static void blitSprite(class_2960 texture, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            DrawUtil.innerBlit(texture, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, color);
        }
    }

    private static void blitSprite(class_2960 texture, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        if (o != 0 && p != 0) {
            DrawUtil.innerBlit(texture, m, m + o, n, n + p, (float)k / (float)i, (float)(k + o) / (float)i, (float)l / (float)j, (float)(l + p) / (float)j, q);
        }
    }

    private static void blitNineSlicedSprite(class_2960 texture, NineSlice nineSlice, int i, int j, int k, int l, int m) {
        Border border = nineSlice.border();
        int n = Math.min(border.left(), k / 2);
        int o = Math.min(border.right(), k / 2);
        int p = Math.min(border.top(), l / 2);
        int q = Math.min(border.bottom(), l / 2);
        if (k == nineSlice.width() && l == nineSlice.height()) {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, l, m);
        } else if (l == nineSlice.height()) {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, n, l, m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i + n, j, k - o - n, l, n, 0, nineSlice.width() - o - n, nineSlice.height(), nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, i + k - o, j, o, l, m);
        } else if (k == nineSlice.width()) {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, p, m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i, j + p, k, l - q - p, 0, p, nineSlice.width(), nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, i, j + l - q, k, q, m);
        } else {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, n, p, m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i + n, j, k - o - n, p, n, 0, nineSlice.width() - o - n, p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, i + k - o, j, o, p, m);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, i, j + l - q, n, q, m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i + n, j + l - q, k - o - n, q, n, nineSlice.height() - q, nineSlice.width() - o - n, q, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, nineSlice.height() - q, i + k - o, j + l - q, o, q, m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i, j + p, n, l - q - p, 0, p, n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i + n, j + p, k - o - n, l - q - p, n, p, nineSlice.width() - o - n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, i + k - o, j + p, o, l - q - p, nineSlice.width() - o, p, o, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
        }
    }

    private static void blitNineSliceInnerSegment(class_2960 texture, NineSlice nineSlice, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s) {
        if (k > 0 && l > 0) {
            if (nineSlice.stretchInner()) {
                DrawUtil.innerBlit(texture, i, i + k, j, j + l, (float)m / (float)q, (float)(m + o) / (float)q, (float)n / (float)r, (float)(n + p) / (float)r, s);
            } else {
                DrawUtil.blitTiledSprite(texture, i, j, k, l, m, n, o, p, q, r, s);
            }
        }
    }

    private static void blitTiledSprite(class_2960 texture, int i, int j, int k, int l, int m, int n, int width, int height, int q, int r, int s) {
        if (k > 0 && l > 0) {
            if (width > 0 && height > 0) {
                for (int t = 0; t < k; t += width) {
                    int u = Math.min(width, k - t);
                    for (int v = 0; v < l; v += height) {
                        int w = Math.min(height, l - v);
                        DrawUtil.blitSprite(texture, q, r, m, n, i + t, j + v, u, w, s);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + width + "x" + height);
            }
        }
    }

    private static void innerBlit(class_2960 resourceLocation, int x, int x2, int y, int y2, float u, float u2, float v, float v2, int color) {
        class_310.method_1551().method_1531().method_22813(resourceLocation);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        class_4493.method_22000((float)r, (float)g, (float)b, (float)a);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, class_290.field_1585);
        bufferBuilder.method_22912((double)x, (double)y2, 0.0).method_22913(u, v2).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y2, 0.0).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y, 0.0).method_22913(u2, v).method_1344();
        bufferBuilder.method_22912((double)x, (double)y, 0.0).method_22913(u, v).method_1344();
        tessellator.method_1350();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface GuiSpriteScaling {
    }

    public record Stretch() implements GuiSpriteScaling
    {
    }

    public record Tile(int width, int height) implements GuiSpriteScaling
    {
    }

    public record NineSlice(int width, int height, Border border, boolean stretchInner) implements GuiSpriteScaling
    {
        public NineSlice(int width, int height, Border border) {
            this(width, height, border, false);
        }

        public NineSlice(int width, int height, int borderSize) {
            this(width, height, new Border(borderSize));
        }
    }

    public record Border(int left, int right, int top, int bottom) {
        public Border(int size) {
            this(size, size, size, size);
        }
    }
}

