/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import lombok.Generated;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4587;

public final class RenderUtil {
    public static void drawOutline(class_4587 matrices, int x, int y, int width, int height, int color) {
        RenderUtil.fillOutline(matrices, x, y, x + width, y + height, color);
    }

    public static void fillOutline(class_4587 matrices, int x, int y, int x2, int y2, int color) {
        RenderUtil.fill(matrices, x, y, x2, y + 1, color);
        RenderUtil.fill(matrices, x, y + 1, x + 1, y2 - 1, color);
        RenderUtil.fill(matrices, x2 - 1, y + 1, x2, y2 - 1, color);
        RenderUtil.fill(matrices, x, y2 - 1, x2, y2, color);
    }

    public static void fill(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        RenderUtil.fill(matrices.method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    public static void fill(class_1159 matrix, int x1, int y1, int x2, int y2, int color) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.method_1328(7, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        class_289.method_1348().method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawOutline(class_4587 matrices, int x, int y, int width, int height, Color color) {
        RenderUtil.fillOutline(matrices, x, y, x + width, y + height, color);
    }

    public static void fillOutline(class_4587 matrices, int x, int y, int x2, int y2, Color color) {
        RenderUtil.fill(matrices, x, y, x2, y + 1, color);
        RenderUtil.fill(matrices, x, y + 1, x + 1, y2 - 1, color);
        RenderUtil.fill(matrices, x2 - 1, y + 1, x2, y2 - 1, color);
        RenderUtil.fill(matrices, x, y2 - 1, x2, y2, color);
    }

    public static void fill(class_4587 matrix, int x1, int y1, int x2, int y2, Color color) {
        RenderUtil.fill(matrix.method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    public static void fill(class_1159 matrix, int x1, int y1, int x2, int y2, Color color) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        int colorInt = RenderUtil.colorPreRender(color);
        float a = (float)(colorInt >> 24 & 0xFF) / 255.0f;
        float r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorInt & 0xFF) / 255.0f;
        bufferBuilder.method_1328(7, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        class_289.method_1348().method_1350();
        RenderUtil.colorPostRender(color);
    }

    public static int colorPreRender(Color color) {
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        return color.toInt();
    }

    public static void colorPostRender(Color color) {
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawVerticalLine(class_4587 matrices, int x, int y, int height, int color) {
        RenderUtil.drawRectangle(matrices, x, y, 1, height, color);
    }

    public static void drawRectangle(class_4587 matrices, int x, int y, int width, int height, int color) {
        RenderUtil.fill(matrices, x, y, x + width, y + height, color);
    }

    public static void drawHorizontalLine(class_4587 matrices, int x, int y, int width, int color) {
        RenderUtil.drawRectangle(matrices, x, y, width, 1, color);
    }

    public static void drawRectangle(class_4587 matrices, int x, int y, int width, int height, Color color) {
        RenderUtil.fill(matrices, x, y, x + width, y + height, color);
    }

    public static void fillBlend(class_4587 matrices, Rectangle rect, Color color) {
        RenderUtil.fillBlend(matrices, rect.x, rect.y, rect.width, rect.height, color);
    }

    public static void fillBlend(class_4587 matrices, int x, int y, int width, int height, Color color) {
        RenderUtil.fillBlend(matrices.method_23760().method_23761(), x, y, x + width, y + height, color.toInt());
    }

    public static void fillBlend(class_1159 matrix, int x1, int y1, int x2, int y2, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.disableTexture();
        bufferBuilder.method_1328(7, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(red, green, blue, alpha).method_1344();
        class_289.method_1348().method_1350();
        RenderSystem.enableTexture();
    }

    @Generated
    private RenderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

