/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.particles;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.mixin.ParticleAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.ClientColors;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_703;
import org.apache.commons.lang3.StringUtils;

public class Particles
extends AbstractModule {
    private static final Particles Instance = new Particles();
    public final HashMap<class_2396<?>, HashMap<String, Option<?>>> particleOptions = new HashMap();
    public final WeakHashMap<class_703, class_2396<?>> particleMap = new WeakHashMap();
    private final OptionCategory cat = OptionCategory.create((String)"particles");
    private final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));

    public void init() {
        this.cat.add(new Option[]{this.enabled});
        this.addParticleOptions();
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.cat});
    }

    private void addParticleOptions() {
        for (class_2396 type : class_2378.field_11141.method_10220().sorted(new AlphabeticalComparator()).toList()) {
            if (class_2378.field_11141.method_10221((Object)type) == null) continue;
            OptionCategory category = OptionCategory.create((String)Arrays.stream(class_2378.field_11141.method_10221((Object)type).method_12832().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" ")));
            LinkedHashMap optionsByKey = new LinkedHashMap();
            this.populateMap(optionsByKey, new Option[]{new BooleanOption("showParticle", Boolean.valueOf(true)), new IntegerOption("count", Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(20)), new BooleanOption("customColor", Boolean.valueOf(false)), new ColorOption("color", "particles.color.tooltip", ClientColors.WHITE)});
            if (type == class_2398.field_11205 || type == class_2398.field_11208) {
                this.populateMap(optionsByKey, new Option[]{new BooleanOption("alwaysCrit", Boolean.valueOf(false))});
            }
            ((HashMap)optionsByKey).values().forEach(xva$0 -> category.add(new Option[]{xva$0}));
            this.particleOptions.put(type, optionsByKey);
            this.cat.add(new OptionCategory[]{category});
        }
    }

    private void populateMap(HashMap<String, Option<?>> map, Option<?> ... options) {
        for (Option<?> option : options) {
            map.put(option.getName(), option);
        }
    }

    public void applyOptions(class_703 particle) {
        HashMap<String, Option<?>> options;
        class_2396<?> type;
        if (((Boolean)this.enabled.get()).booleanValue() && this.particleMap.containsKey(particle) && this.particleOptions.containsKey(type = this.particleMap.get(particle)) && ((Boolean)((BooleanOption)(options = this.particleOptions.get(type)).get("customColor")).get()).booleanValue()) {
            Color color = ((ColorOption)options.get("color")).get();
            particle.method_3084((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            ((ParticleAccessor)particle).setColorAlpha((float)color.getAlpha() / 255.0f);
        }
    }

    public int getMultiplier(class_2396<?> type) {
        if (((Boolean)this.enabled.get()).booleanValue() && this.particleOptions.containsKey(type)) {
            HashMap<String, Option<?>> options = this.particleOptions.get(type);
            return (Integer)((IntegerOption)options.get("count")).get();
        }
        return 1;
    }

    public boolean getAlwaysOn(class_2396<?> type) {
        return (Boolean)this.enabled.get() != false && this.particleOptions.containsKey(type) && (Boolean)((BooleanOption)Particles.getInstance().particleOptions.get(type).get("alwaysCrit")).get() != false;
    }

    public boolean getShowParticle(class_2396<?> type) {
        return (Boolean)this.enabled.get() != false && this.particleOptions.containsKey(type) ? (Boolean)((BooleanOption)Particles.getInstance().particleOptions.get(type).get("showParticle")).get() : true;
    }

    @Generated
    public static Particles getInstance() {
        return Instance;
    }

    protected static class AlphabeticalComparator
    implements Comparator<class_2396<?>> {
        protected AlphabeticalComparator() {
        }

        @Override
        public int compare(class_2396<?> s1, class_2396<?> s2) {
            if (this.getName(s1).equals(this.getName(s2))) {
                return 0;
            }
            String[] strings = new String[]{this.getName(s1), this.getName(s2)};
            Arrays.sort(strings, Collections.reverseOrder());
            if (strings[0].equals(this.getName(s1))) {
                return 1;
            }
            return -1;
        }

        private String getName(class_2396<?> type) {
            if (class_2378.field_11141.method_10221(type) != null) {
                return class_2378.field_11141.method_10221(type).method_12832();
            }
            return "";
        }
    }
}

