/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.screenshotUtils.DownloadImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.util.Watcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1159;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class GalleryScreen
extends class_437 {
    public static final Path SCREENSHOTS_DIR = FabricLoader.getInstance().getGameDir().resolve("screenshots");
    private Tab<?> current;
    private final class_437 parent;
    private final Watcher watcher;
    private static final int entrySpacing = 4;
    private static final int entryWidth = 100;
    private static final int entryHeight = 75;
    private static final int marginLeftRight = 10;
    private boolean isError;
    private boolean online;
    private ImageList area;

    public GalleryScreen(class_437 parent) {
        super((class_2561)new class_2588("gallery.title"));
        this.parent = parent;
        this.current = Tab.LOCAL;
        this.watcher = Watcher.createSelfTicking((Path)SCREENSHOTS_DIR, () -> {
            if (this.current == Tab.LOCAL) {
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }
        });
    }

    public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        this.area.method_25394(graphics, mouseX, mouseY, delta);
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.online) {
            class_2561 class_25612 = this.method_25440();
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            GalleryScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)class_25612, (int)n, (int)(18 - 9), (int)-1);
            GalleryScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)this.current.title(), (int)(this.field_22789 / 2), (int)22, (int)-1);
        } else {
            class_2561 class_25613 = this.method_25440();
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            GalleryScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)class_25613, (int)n, (int)(20 - 9 / 2), (int)-1);
        }
        if (this.isError) {
            GalleryScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)new class_2588("gallery.error.loading"), (int)(this.field_22789 / 2), (int)36, (int)-1);
        }
    }

    protected void method_25426() {
        this.online = API.getInstance().isAuthenticated();
        int columnCount = (this.field_22789 - 20 + 4 - 13) / 104;
        this.area = new ImageList(this.field_22787, this.field_22789, this.field_22790, 33, this.field_22790 - 40, 79, columnCount);
        this.method_25429((class_364)this.area);
        this.method_20085((class_364)this.area);
        CompletableFuture.runAsync(() -> {
            try {
                this.loadTab(this.current, columnCount, this.area);
            }
            catch (Exception e) {
                this.isError = true;
                int n = this.field_22789 / 2 - 75;
                Objects.requireNonNull(this.field_22793);
                this.method_20085((class_364)this.method_25411((class_339)new class_4185(n, 36 + 9 + 8, 150, 20, (class_2561)new class_2588("gallery.reload"), b -> this.method_25423(this.field_22787, this.field_22789, this.field_22790))));
            }
        });
        int buttonWidth = columnCount <= 5 && this.online ? 100 : 150;
        int footerButtonX = this.online ? this.field_22789 / 2 - buttonWidth - buttonWidth / 2 - 4 : this.field_22789 / 2 - buttonWidth - 2;
        int footerButtonY = this.field_22790 - 16 - 10;
        if (this.online) {
            class_4185 switchTab = this.current == Tab.SHARED ? new class_4185(footerButtonX, footerButtonY, buttonWidth, 20, (class_2561)new class_2588("gallery.tab.local"), b -> this.setTab(Tab.LOCAL)) : new class_4185(footerButtonX, footerButtonY, buttonWidth, 20, (class_2561)new class_2588("gallery.tab.shared"), b -> this.setTab(Tab.SHARED));
            this.method_25411((class_339)switchTab);
            footerButtonX += buttonWidth + 4;
        }
        this.method_25411((class_339)new class_4185(footerButtonX, footerButtonY, buttonWidth, 20, (class_2561)new class_2588("gallery.download_external"), b -> this.field_22787.method_1507((class_437)new DownloadImageScreen(this))));
        this.method_25411((class_339)new class_4185(footerButtonX += buttonWidth + 4, footerButtonY, buttonWidth, 20, class_5244.field_24339, b -> this.method_25419()));
    }

    public void method_25419() {
        Tab.LOCAL.loadingCache().forEach((path, instance) -> {
            if (instance != null) {
                this.field_22787.method_1531().method_4615(instance.id());
            }
        });
        Tab.LOCAL.loadingCache().clear();
        Tab.SHARED.loadingCache().forEach((s, instance) -> {
            if (instance != null) {
                this.field_22787.method_1531().method_4615(instance.id());
            }
        });
        Tab.SHARED.loadingCache().clear();
        Watcher.close((Watcher)this.watcher);
        this.field_22787.method_1507(this.parent);
    }

    private void setTab(Tab<?> tab) {
        this.current = tab;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private <T> void loadTab(Tab<T> tab, int columnCount, ImageList area) throws Exception {
        List images = tab.list.call();
        int size = images.size();
        for (int i = 0; i < size; i += columnCount) {
            ImageListEntry row = new ImageListEntry(columnCount, area);
            area.addEntry(row);
            for (int x = 0; x < columnCount && i + x < size; ++x) {
                Object p = images.get(i + x);
                ImageEntry entry = new ImageEntry(100, 75, () -> tab.loader.load(p), row);
                row.add(entry);
            }
        }
    }

    private record Tab<T>(class_2561 title, Callable<List<T>> list, Map<T, ImageInstance> loadingCache, Loader<T> loader) {
        private static final Tab<Path> LOCAL = Tab.of((class_2561)new class_2588("gallery.title.local"), () -> {
            try (Stream<Path> screenshots = Files.list(SCREENSHOTS_DIR);){
                List<Path> list = screenshots.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).toList();
                return list;
            }
        }, ImageInstance.LocalImpl::new);
        private static final Tab<String> SHARED = Tab.of((class_2561)new class_2588("gallery.title.shared"), () -> (List)((CompletableFuture)FriendRequest.getInstance().getFriendUuids().thenApply(res -> res.stream().map(UserRequest::getUploadedImages).map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).reduce(new ArrayList(), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }))).join(), url -> ImageShare.getInstance().downloadImage((String)url).join());

        private static <T> Tab<T> of(class_2561 title, Callable<List<T>> list, Loader<T> loader) {
            HashMap cache = new HashMap();
            return new Tab<Object>(title, list, cache, o -> {
                if (cache.containsKey(o)) {
                    return (ImageInstance)cache.get(o);
                }
                ImageInstance val = loader.load(o);
                cache.put(o, val);
                return val;
            });
        }

        static interface Loader<T> {
            public ImageInstance load(T var1) throws Exception;
        }
    }

    private static class ImageList
    extends class_4265<ImageListEntry> {
        private final int rowWidth;

        public ImageList(class_310 minecraft, int screenWidth, int screenHeight, int top, int bottom, int entryHeight, int columns) {
            super(minecraft, screenWidth, screenHeight, top, bottom, entryHeight);
            this.rowWidth = columns * 104 - 4;
        }

        public int addEntry(ImageListEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25322() {
            return this.rowWidth;
        }

        public int method_25342() {
            return this.field_19088 + this.field_22742 / 2 - this.method_25322() / 2;
        }

        public boolean removeEntry(ImageListEntry entry) {
            return super.method_25330((class_350.class_351)entry);
        }

        public void shiftEntries(ImageListEntry origin) {
            int lastIndex;
            int originIndex = this.method_25396().indexOf((Object)origin);
            if (originIndex == (lastIndex = this.method_25396().size() - 1)) {
                return;
            }
            ImageListEntry next = (ImageListEntry)this.method_25326(originIndex + 1);
            origin.add(next.pop());
        }

        protected int method_25329() {
            return this.method_25342() + this.method_25322() + 6 + 2;
        }

        public boolean isInListContent(int x, int y) {
            return x >= this.field_19088 && x < this.field_19087 && y >= this.field_19085 && y < this.field_19086;
        }

        public int getY() {
            return this.field_19085;
        }

        public int getWidth() {
            return this.field_22742;
        }

        public int getHeight() {
            return this.field_19086 - this.field_19085;
        }
    }

    private static class ImageListEntry
    extends class_4265.class_4266<ImageListEntry> {
        private final List<ImageEntry> buttons;
        private final int size;
        private final ImageList list;

        public ImageListEntry(int size, ImageList list) {
            this.size = size;
            this.buttons = new ArrayList<ImageEntry>(size);
            this.list = list;
        }

        public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (Math.max(left, this.list.method_25342()) <= Math.min(left + width, this.list.method_25342() + this.list.getWidth()) - 1 && Math.max(top - height, this.list.getY()) <= Math.min(top + height * 2, this.list.getY() + this.list.getHeight()) - 1) {
                this.buttons.forEach(e -> {
                    e.field_22761 = top;
                    e.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                });
            } else {
                this.buttons.forEach(e -> {
                    e.field_22761 = top;
                });
            }
        }

        public void add(ImageEntry e) {
            this.buttons.add(e);
            this.repositionButtons();
        }

        public void remove(ImageEntry e) {
            this.buttons.remove((Object)e);
            if (this.buttons.isEmpty()) {
                this.list.removeEntry(this);
            } else if (this.buttons.size() < this.size) {
                this.list.shiftEntries(this);
            }
            this.repositionButtons();
        }

        private void repositionButtons() {
            int x = this.list.method_25342();
            for (ImageEntry e : this.buttons) {
                e.field_22760 = x;
                x += e.method_25368() + 4;
            }
        }

        public ImageEntry pop() {
            ImageEntry entry = this.buttons.remove(0);
            if (this.buttons.isEmpty()) {
                this.list.removeEntry(this);
                this.list.method_25307(this.list.method_25341());
            } else if (this.buttons.size() < this.size) {
                this.list.shiftEntries(this);
            }
            this.repositionButtons();
            return entry;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.buttons;
        }
    }

    private class ImageEntry
    extends class_4185 {
        private static final int bgColor = Colors.DARK_GRAY.toInt();
        private static final int accent = Colors.GRAY.withBrightness(0.5f).withAlpha(128).toInt();
        private final class_327 font;
        private final Callable<ImageInstance> instanceSupplier;
        private final ImageListEntry row;
        private long loadStart;
        private CompletableFuture<ImageInstance> future;

        protected ImageEntry(int width, int height, Callable<ImageInstance> instanceSupplier, ImageListEntry row) {
            super(0, 0, width, height, class_2585.field_24366, b -> {});
            this.instanceSupplier = instanceSupplier;
            this.row = row;
            this.font = class_310.method_1551().field_1772;
        }

        private CompletableFuture<ImageInstance> load() {
            if (this.future == null) {
                this.loadStart = class_156.method_658();
                this.future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ImageInstance instance = this.instanceSupplier.call();
                        this.method_25355((class_2561)new class_2585(instance.filename()));
                        return instance;
                    }
                    catch (Exception e) {
                        GalleryScreen.this.field_22787.method_20493(() -> this.row.remove(this));
                        return null;
                    }
                });
            }
            return this.future;
        }

        public void method_25306() {
            GalleryScreen.this.field_22787.method_1507(ImageScreen.create(GalleryScreen.this, this.load(), false));
        }

        public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.load().isDone() && this.load().join() != null) {
                GalleryScreen.this.field_22787.method_1531().method_22813(this.load().join().id());
                int n = this.method_25368();
                int n2 = this.method_25364();
                Objects.requireNonNull(this.font);
                int n3 = n2 - 9 - 2;
                int n4 = this.method_25368();
                int n5 = this.method_25364();
                Objects.requireNonNull(this.font);
                ImageEntry.method_25290((class_4587)guiGraphics, (int)this.field_22760, (int)this.field_22761, (float)0.0f, (float)0.0f, (int)n, (int)n3, (int)n4, (int)(n5 - 9 - 2));
                this.drawScrollingText(guiGraphics, this.font, 2, -1);
            } else {
                float delta = (float)this.easeInOutCubic((float)(class_156.method_658() - this.loadStart) % 1000.0f / 1000.0f);
                int n = this.getX() + 2;
                int n6 = this.getY() + 2;
                int n7 = this.getXEnd() - 2;
                int n8 = this.getYEnd();
                Objects.requireNonNull(this.font);
                ImageEntry.method_25294((class_4587)guiGraphics, (int)n, (int)n6, (int)n7, (int)(n8 - 9 - 2), (int)bgColor);
                int n9 = this.getX() + 2;
                int n10 = this.getY() + 2;
                int n11 = this.getYEnd();
                Objects.requireNonNull(this.font);
                this.drawHorizontalGradient(guiGraphics, n9, n10, n11 - 9 - 2, this.lerp(delta, this.getX() + 2, this.getXEnd() - 2));
                int n12 = this.getX() + 2;
                int n13 = this.getYEnd();
                Objects.requireNonNull(this.font);
                ImageEntry.method_25294((class_4587)guiGraphics, (int)n12, (int)(n13 - 9 - 1), (int)(this.getXEnd() - 2), (int)(this.getYEnd() - 2), (int)bgColor);
                int n14 = this.getX() + 2;
                int n15 = this.getYEnd();
                Objects.requireNonNull(this.font);
                this.drawHorizontalGradient(guiGraphics, n14, n15 - 9 - 1, this.getYEnd() - 2, this.lerp(delta, this.getX() + 2, this.getXEnd() - 2));
            }
            DrawUtil.outlineRect(guiGraphics, this.getX(), this.getY(), this.method_25368(), this.method_25364(), this.row.list.isInListContent(mouseX, mouseY) && this.method_25367() ? -1 : bgColor);
        }

        private int getX() {
            return this.field_22760;
        }

        private int getY() {
            return this.field_22761;
        }

        protected int getYEnd() {
            return this.field_22761 + this.method_25364();
        }

        protected int getXEnd() {
            return this.field_22760 + this.method_25368();
        }

        private void drawHorizontalGradient(class_4587 guiGraphics, int x1, int y1, int y2, int x2) {
            class_287 consumer = class_289.method_1348().method_1349();
            class_1159 matrix4f = guiGraphics.method_23760().method_23761();
            consumer.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_1336(bgColor >> 16 & 0xFF, bgColor >> 8 & 0xFF, bgColor & 0xFF, bgColor >> 24 & 0xFF);
            consumer.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_1336(bgColor >> 16 & 0xFF, bgColor >> 8 & 0xFF, bgColor & 0xFF, bgColor >> 24 & 0xFF);
            consumer.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_1336(accent >> 16 & 0xFF, accent >> 8 & 0xFF, accent & 0xFF, accent >> 24 & 0xFF);
            consumer.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_1336(accent >> 16 & 0xFF, accent >> 8 & 0xFF, accent & 0xFF, accent >> 24 & 0xFF);
            class_289.method_1348().method_1350();
        }

        private double easeInOutCubic(double x) {
            return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
        }

        private int lerp(float delta, int start, int end) {
            return (int)class_3532.method_15363((float)class_3532.method_16439((float)delta, (float)start, (float)end), (float)start, (float)end);
        }

        @NotNull
        protected class_5250 method_25360() {
            return new class_2588("gui.narrate.button", new Object[]{new class_2588("gallery.image.view")});
        }

        protected void drawScrollingText(class_4587 guiGraphics, class_327 font, int offset, int color) {
            int i = this.field_22760 + offset;
            int j = this.field_22760 + this.method_25368() - offset;
            class_2561 class_25612 = this.method_25369();
            int n = this.field_22761 + this.method_25364();
            Objects.requireNonNull(font);
            DrawUtil.drawScrollableText(guiGraphics, font, class_25612, i, n - 9 - 1, j, this.field_22761 + this.method_25364(), color);
        }
    }
}

