/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.modules.screenshotUtils.LoadingImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ScreenshotCopying;
import io.github.axolotlclient.util.GsonHelper;
import io.github.axolotlclient.util.notifications.Notifications;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class ImageScreen
extends class_437 {
    private final class_437 parent;
    private final ImageInstance image;
    private final boolean freeOnClose;
    private final boolean isRemote;
    private final CompletableFuture<String> uploader;

    static class_437 create(class_437 parent, CompletableFuture<ImageInstance> future, boolean freeOnClose) {
        if (future.isDone()) {
            if (future.join() != null) {
                return new ImageScreen(parent, future.join(), freeOnClose);
            }
            return parent;
        }
        return new LoadingImageScreen(parent, (CompletableFuture<Void>)future.thenAccept(i -> {
            if (i != null) {
                class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new ImageScreen(parent, (ImageInstance)i, freeOnClose)));
            } else {
                class_310.method_1551().execute(() -> class_310.method_1551().method_1507(parent));
            }
        }), freeOnClose);
    }

    private ImageScreen(class_437 parent, ImageInstance instance, boolean freeOnClose) {
        super((class_2561)new class_2585(instance.filename()));
        this.parent = parent;
        this.image = instance;
        this.freeOnClose = freeOnClose;
        this.isRemote = this.image instanceof ImageInstance.Remote;
        this.uploader = this.isRemote ? UUIDHelper.tryGetUsernameAsync((String)((ImageInstance.Remote)this.image).uploader()) : null;
    }

    public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.isRemote && this.uploader.isDone()) {
            ImageInstance.Remote r = (ImageInstance.Remote)this.image;
            class_2561 class_25612 = this.method_25440();
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            ImageScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)class_25612, (int)n, (int)(19 - 9 - 2), (int)-1);
            ImageScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)new class_2588("gallery.image.upload_details", new Object[]{this.uploader.join(), r.sharedAt().atZone(ZoneId.systemDefault()).format(AxolotlClientCommon.getInstance().getConfig().getDateTimeFormatter())}), (int)(this.field_22789 / 2), (int)21, (int)-1);
        } else {
            class_2561 class_25613 = this.method_25440();
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            ImageScreen.method_27534((class_4587)graphics, (class_327)this.field_22793, (class_2561)class_25613, (int)n, (int)(16 - 9 / 2), (int)-1);
        }
    }

    protected void method_25426() {
        int contentsHeight = this.field_22790 - ((this.isRemote ? 38 : 33) + 33);
        int buttonWidth = 75;
        double imgAspectRatio = (double)this.image.image().method_4307() / (double)this.image.image().method_4323();
        int imageWidth = Math.min((int)((double)contentsHeight * imgAspectRatio), this.field_22789 - buttonWidth - 4 - 20);
        int imageHeight = (int)((double)imageWidth / imgAspectRatio);
        ImageElement element = (ImageElement)this.method_25411(new ImageElement(imageWidth, imageHeight));
        if (this.field_22789 / 2 > imageWidth / 2 + buttonWidth + 4) {
            element.setPosition(this.field_22789 / 2 - imageWidth / 2, 36);
        } else {
            element.setPosition(this.field_22789 / 2 - imageWidth / 2 - buttonWidth / 2 - 2, 36);
        }
        int actionX = element.field_22760 + imageWidth + 4;
        ArrayList<class_4185> actions = new ArrayList<class_4185>();
        Object object = this.image;
        if (object instanceof ImageInstance.Local) {
            ImageInstance.Local local = (ImageInstance.Local)object;
            if (API.getInstance().isAuthenticated() && !(this.image instanceof ImageInstance.Remote)) {
                actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.upload"), b -> {
                    b.field_22763 = false;
                    ImageShare.getInstance().upload(local.location()).thenAccept(s -> {
                        if (s.isEmpty()) {
                            Notifications.getInstance().addStatus("gallery.image.upload.failure", "gallery.image.upload.failure.description", new Object[0]);
                        } else {
                            this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new ImageScreen(this.parent, local.toShared((String)s, API.getInstance().getSelf().getUuid(), Instant.now()), this.freeOnClose)));
                            this.field_22787.field_1774.method_1455(s);
                            Notifications.getInstance().addStatus("gallery.image.upload.success", "gallery.image.upload.success.description", s);
                        }
                    });
                }));
            }
            actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.copy"), b -> ScreenshotCopying.copy((Path)local.location())));
            actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.open.external"), b -> class_156.method_668().method_673(local.location().toUri())));
        }
        if ((object = this.image) instanceof ImageInstance.Remote) {
            ImageInstance.Remote remote = (ImageInstance.Remote)object;
            if (!(this.image instanceof ImageInstance.Local)) {
                actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.save"), b -> {
                    b.field_22763 = false;
                    try {
                        Path out = this.saveSharedImage(remote);
                        this.field_22787.method_1507((class_437)new ImageScreen(this.parent, remote.toShared(out), this.freeOnClose));
                    }
                    catch (IOException e) {
                        Notifications.getInstance().addStatus("gallery.image.save.failure", "gallery.image.save.failure.description", e.getMessage());
                        AxolotlClient.LOGGER.warn("Failed to save shared image!", new Object[]{e});
                    }
                }));
                actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.copy"), b -> {
                    try {
                        ScreenshotCopying.copy((byte[])this.image.image().method_24036());
                    }
                    catch (IOException e) {
                        Notifications.getInstance().addStatus("gallery.image.copy.failure", "gallery.image.copy.failure.description", e.getMessage());
                        AxolotlClient.LOGGER.warn("Failed to copy shared image!", new Object[]{e});
                    }
                }));
            }
            actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.open.external.browser"), b -> class_156.method_668().method_670(remote.url())));
            actions.add(new class_4185(0, 0, buttonWidth, 20, (class_2561)new class_2588("gallery.image.copy_url"), b -> this.field_22787.field_1774.method_1455(remote.url())));
        }
        int actionY = element.field_22761;
        for (class_4185 w : actions) {
            w.field_22760 = actionX;
            w.field_22761 = actionY;
            this.method_25411((class_339)w);
            actionY += 4 + w.method_25364();
        }
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 75, this.field_22790 - 33 + 16 - 10, 150, 20, class_5244.field_24339, b -> this.method_25419()));
    }

    public void method_25419() {
        if (this.freeOnClose) {
            this.field_22787.method_1531().method_4615(this.image.id());
        }
        this.field_22787.method_1507(this.parent);
    }

    private Path saveSharedImage(ImageInstance.Remote remote) throws IOException {
        Path out = GalleryScreen.SCREENSHOTS_DIR.resolve("shared").resolve(remote.uploader()).resolve(remote.filename());
        Path infoJson = out.resolveSibling(remote.filename() + ".json");
        Files.createDirectories(out.getParent(), new FileAttribute[0]);
        remote.image().method_4314(out);
        Map<String, Instant> json = Map.of("uploader", remote.uploader(), "shared_at", remote.sharedAt());
        Files.writeString(infoJson, (CharSequence)GsonHelper.GSON.toJson(json), new OpenOption[0]);
        return out;
    }

    private class ImageElement
    extends class_339 {
        public ImageElement(int width, int height) {
            super(0, 0, width, height, class_2585.field_24366);
            this.field_22763 = false;
        }

        public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
            ImageScreen.this.field_22787.method_1531().method_22813(ImageScreen.this.image.id());
            ImageElement.method_25290((class_4587)guiGraphics, (int)this.field_22760, (int)this.field_22761, (float)0.0f, (float)0.0f, (int)this.method_25368(), (int)this.method_25364(), (int)this.method_25368(), (int)this.method_25364());
        }

        protected class_5250 method_25360() {
            return class_2585.field_24366.method_27662();
        }

        public void setPosition(int x, int y) {
            this.field_22760 = x;
            this.field_22761 = y;
        }
    }
}

