/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.sky.SkyboxInstance;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class FSBSkyboxInstance
extends SkyboxInstance {
    public FSBSkyboxInstance(JsonObject json) {
        super(json);
        JsonObject props = json.get("properties").getAsJsonObject();
        JsonObject textures = json.get("textures").getAsJsonObject();
        this.textures[0] = new class_2960(textures.get("bottom").getAsString());
        this.textures[1] = new class_2960(textures.get("north").getAsString());
        this.textures[2] = new class_2960(textures.get("south").getAsString());
        this.textures[3] = new class_2960(textures.get("top").getAsString());
        this.textures[4] = new class_2960(textures.get("east").getAsString());
        this.textures[5] = new class_2960(textures.get("west").getAsString());
        try {
            this.fade[0] = props.get("fade").getAsJsonObject().get("startFadeIn").getAsInt();
            this.fade[1] = props.get("fade").getAsJsonObject().get("endFadeIn").getAsInt();
            this.fade[2] = props.get("fade").getAsJsonObject().get("startFadeOut").getAsInt();
            this.fade[3] = props.get("fade").getAsJsonObject().get("endFadeOut").getAsInt();
        }
        catch (Exception e) {
            this.alwaysOn = true;
        }
        try {
            JsonObject rotation = props.get("rotation").getAsJsonObject();
            this.rotate = props.get("shouldRotate").getAsBoolean();
            this.rotationSpeed = rotation.get("rotationSpeed").getAsFloat();
            JsonArray axis = rotation.get("axis").getAsJsonArray();
            for (int i = 0; i < axis.size(); ++i) {
                this.rotationAxis[i] = axis.get(i).getAsFloat();
            }
            JsonArray staticRotation = rotation.get("static").getAsJsonArray();
            for (int i = 0; i < staticRotation.size(); ++i) {
                this.rotationStatic[i] = staticRotation.get(i).getAsFloat();
            }
        }
        catch (Exception rotation) {
            // empty catch block
        }
        try {
            JsonObject jsonBlend = json.get("blend").getAsJsonObject();
            this.blendMode = this.parseBlend(jsonBlend.get("type").getAsString());
        }
        catch (Exception ignored) {
            try {
                AxolotlClient.LOGGER.debug(String.valueOf(textures) + ": Using manual blend!", new Object[0]);
                JsonObject blend = json.get("blend").getAsJsonObject();
                this.blendEquation = blend.get("equation").getAsInt();
                this.blendDstFactor = blend.get("dfactor").getAsInt();
                this.blendSrcFactor = blend.get("sfactor").getAsInt();
                this.manualBlend = true;
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.debug(String.valueOf(textures) + ": Manual Blend failed, using fallback blend!", new Object[0]);
                this.manualBlend = false;
                this.blendMode = 8;
            }
        }
        try {
            JsonObject decorations = json.get("decorations").getAsJsonObject();
            this.showMoon = decorations.get("showMoon").getAsBoolean();
            this.showSun = decorations.get("showSun").getAsBoolean();
            this.showStars = decorations.get("showStars").getAsBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void renderSkybox(class_4587 matrices) {
        this.alpha = this.getAlpha();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        for (int i = 0; i < 6; ++i) {
            if (this.textures[i] == null) continue;
            class_310.method_1551().method_1531().method_22813(this.textures[i]);
            matrices.method_22903();
            if (i == 1) {
                matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
            } else if (i == 2) {
                matrices.method_22907(class_1160.field_20703.method_23214(-90.0f));
                matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
            } else if (i == 3) {
                matrices.method_22907(class_1160.field_20703.method_23214(180.0f));
            } else if (i == 4) {
                matrices.method_22907(class_1160.field_20707.method_23214(90.0f));
                matrices.method_22907(class_1160.field_20705.method_23214(-90.0f));
            } else if (i == 5) {
                matrices.method_22907(class_1160.field_20707.method_23214(-90.0f));
                matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
            }
            class_1159 matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(7, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_1344();
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_1344();
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(1.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_1344();
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, this.alpha).method_1344();
            class_286.method_1309((class_287)bufferBuilder);
            matrices.method_22909();
        }
    }
}

