/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.modules.sky.FSBSkyboxInstance;
import io.github.axolotlclient.modules.sky.MCPSkyboxInstance;
import io.github.axolotlclient.modules.sky.SkyboxManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class SkyResourceManager
extends AbstractModule
implements SimpleSynchronousResourceReloadListener {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final SkyResourceManager Instance = new SkyResourceManager();

    public void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public void method_14491(class_3300 manager) {
        try {
            AxolotlClient.LOGGER.debug("Loading Custom Skies!", new Object[0]);
            SkyboxManager.getInstance().clearSkyboxes();
            for (class_2960 entry : manager.method_14488("sky", identifier -> identifier.endsWith(".json"))) {
                if (entry.method_12836().equals("celestial")) continue;
                AxolotlClient.LOGGER.debug("Loading FSB sky from " + String.valueOf(entry), new Object[0]);
                JsonObject json = (JsonObject)gson.fromJson(new BufferedReader(new InputStreamReader(manager.method_14486(entry).method_14482(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), JsonObject.class);
                if (!json.has("type") || !json.get("type").getAsString().equals("square-textured")) {
                    AxolotlClient.LOGGER.debug("Skipping " + String.valueOf(entry) + " as we currently cannot load it!", new Object[0]);
                    continue;
                }
                SkyboxManager.getInstance().addSkybox(new FSBSkyboxInstance(json));
                AxolotlClient.LOGGER.debug("Loaded FSB sky from " + String.valueOf(entry), new Object[0]);
            }
            for (class_2960 entry : manager.method_14488("mcpatcher/sky", this::isMCPSky)) {
                AxolotlClient.LOGGER.debug("Loading MCP sky from " + String.valueOf(entry), new Object[0]);
                this.loadMCPSky("mcpatcher", entry, manager.method_14486(entry));
                AxolotlClient.LOGGER.debug("Loaded MCP sky from " + String.valueOf(entry), new Object[0]);
            }
            for (class_2960 entry : manager.method_14488("optifine/sky", this::isMCPSky)) {
                AxolotlClient.LOGGER.debug("Loading OF sky from " + String.valueOf(entry), new Object[0]);
                this.loadMCPSky("optifine", entry, manager.method_14486(entry));
                AxolotlClient.LOGGER.debug("Loaded OF sky from " + String.valueOf(entry), new Object[0]);
            }
            AxolotlClient.LOGGER.debug("Finished Loading Custom Skies!", new Object[0]);
        }
        catch (Exception e) {
            AxolotlClient.LOGGER.warn("Failed to load skies!", new Object[]{e});
        }
    }

    private boolean isMCPSky(String path) {
        return path.endsWith(".properties") && path.startsWith("sky");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMCPSky(String loader, class_2960 id, class_3298 resource) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));
        JsonObject object = new JsonObject();
        try {
            while (true) {
                String string;
                if ((string = reader.readLine()) == null) {
                    SkyboxManager.getInstance().addSkybox(new MCPSkyboxInstance(object));
                    return;
                }
                try {
                    if (string.startsWith("#")) continue;
                    String[] option = string.split("=");
                    if (option[0].equals("source")) {
                        if (!option[1].contains(":")) {
                            if (option[1].startsWith("assets")) {
                                option[1] = option[1].replace("./", "").replace("assets/minecraft/", "");
                            }
                            if (id.method_12832().contains("world")) {
                                option[1] = loader + "/sky/world" + id.method_12832().split("world")[1].split("/")[0] + "/" + option[1].replace("./", "");
                            }
                        }
                        try {
                            class_310.method_1551().method_1478().method_14486(new class_2960(option[1]));
                        }
                        catch (FileNotFoundException e) {
                            AxolotlClient.LOGGER.warn("Sky " + String.valueOf(id) + " does not have a valid texture attached to it: ", new Object[]{option[1]});
                            AxolotlClient.LOGGER.warn("Please fix your packs.", new Object[0]);
                            return;
                        }
                    }
                    if (option[0].equals("startFadeIn") || option[0].equals("endFadeIn") || option[0].equals("startFadeOut") || option[0].equals("endFadeOut")) {
                        option[1] = option[1].replace(":", "").replace("\\", "");
                    }
                    object.addProperty(option[0], option[1]);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class_2960 getFabricId() {
        return new class_2960("axolotlclient", "custom_skies");
    }

    @Generated
    public static SkyResourceManager getInstance() {
        return Instance;
    }
}

