/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.mixin.WorldRendererAccessor;
import io.github.axolotlclient.util.Util;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_758;
import org.lwjgl.opengl.GL14;

public abstract class SkyboxInstance {
    protected final class_2960 MOON_PHASES = new class_2960("textures/environment/moon_phases.png");
    protected final class_2960 SUN = new class_2960("textures/environment/sun.png");
    protected int blendMode = 1;
    protected boolean alwaysOn;
    protected float maxAlpha = 1.0f;
    protected boolean manualBlend = false;
    protected int blendSrcFactor = 1;
    protected int blendDstFactor = 1;
    protected int blendEquation;
    protected boolean rotate = false;
    protected float rotationSpeed = 1.0f;
    protected float[] rotationStatic = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] rotationAxis = new float[]{0.0f, 0.0f, 0.0f};
    protected boolean showSun = true;
    protected boolean showMoon = true;
    protected boolean showStars = true;
    JsonObject object;
    float alpha = 1.0f;
    class_2960[] textures = new class_2960[6];
    int[] fade = new int[4];

    public SkyboxInstance(JsonObject json) {
        this.object = json;
    }

    public float getAlpha() {
        int tempOutTime;
        int tempFullTime;
        int tempInTime;
        if (this.alwaysOn) {
            return 1.0f;
        }
        int currentTime = (int)Objects.requireNonNull(class_310.method_1551().field_1687).method_8532() % 24000;
        int durationIn = Util.getTicksBetween(this.fade[0], this.fade[1]);
        int durationOut = Util.getTicksBetween(this.fade[2], this.fade[3]);
        int endFadeIn = this.fade[1] % 24000;
        int startFadeIn = this.fade[0] % 24000;
        if (endFadeIn < startFadeIn) {
            endFadeIn += 24000;
        }
        int startFadeOut = this.fade[2] % 24000;
        int endFadeOut = this.fade[3] % 24000;
        if (startFadeOut < endFadeIn) {
            startFadeOut += 24000;
        }
        if (endFadeOut < startFadeOut) {
            endFadeOut += 24000;
        }
        if ((tempInTime = currentTime) < startFadeIn) {
            tempInTime += 24000;
        }
        if ((tempFullTime = currentTime) < endFadeIn) {
            tempFullTime += 24000;
        }
        if ((tempOutTime = currentTime) < startFadeOut) {
            tempOutTime += 24000;
        }
        float maxPossibleAlpha = startFadeIn < tempInTime && endFadeIn >= tempInTime ? 1.0f - (float)(endFadeIn - tempInTime) / (float)durationIn : (endFadeIn < tempFullTime && startFadeOut >= tempFullTime ? 1.0f : (startFadeOut < tempOutTime && endFadeOut >= tempOutTime ? (float)(endFadeOut - tempOutTime) / (float)durationOut : 0.0f));
        this.alpha = class_3532.method_15363((float)(maxPossibleAlpha * this.maxAlpha), (float)0.0f, (float)1.0f);
        return this.alpha;
    }

    protected int parseBlend(String str) {
        if (str == null) {
            return 1;
        }
        return switch (str.toLowerCase(Locale.ENGLISH).trim()) {
            case "alpha" -> 0;
            case "add" -> 1;
            case "subtract" -> 2;
            case "multiply" -> 3;
            case "dodge" -> 4;
            case "burn" -> 5;
            case "screen" -> 6;
            case "overlay" -> 7;
            case "replace" -> 8;
            default -> {
                AxolotlClient.LOGGER.warn("Unknown blend: " + str, new Object[0]);
                yield 1;
            }
        };
    }

    public void render(class_4587 matrices, float tickDelta) {
        float brightness = class_310.method_1551().field_1687.method_8430(tickDelta);
        matrices.method_22903();
        this.setupBlend(brightness);
        this.setupRotate(matrices, tickDelta, brightness);
        this.renderSkybox(matrices);
        this.clearBlend(brightness);
        this.clearRotate(matrices);
        matrices.method_22909();
        this.renderDecorations(matrices, tickDelta);
        RenderSystem.enableTexture();
    }

    protected void setupBlend(float brightness) {
        if (this.manualBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)this.blendSrcFactor, (int)this.blendDstFactor);
            GL14.glBlendEquation((int)this.blendEquation);
            RenderSystem.enableTexture();
            return;
        }
        switch (this.blendMode) {
            case 0: {
                class_4493.method_22056();
                class_4493.method_21984((int)770, (int)771);
                break;
            }
            case 1: {
                class_4493.method_22056();
                class_4493.method_21984((int)770, (int)1);
                break;
            }
            case 2: {
                class_4493.method_22056();
                class_4493.method_21984((int)775, (int)0);
                break;
            }
            case 3: {
                class_4493.method_22056();
                class_4493.method_21984((int)774, (int)771);
                break;
            }
            case 4: {
                class_4493.method_22056();
                class_4493.method_21984((int)1, (int)1);
                break;
            }
            case 5: {
                class_4493.method_22056();
                class_4493.method_21984((int)0, (int)769);
                break;
            }
            case 6: {
                class_4493.method_22056();
                class_4493.method_21984((int)1, (int)769);
                break;
            }
            case 7: {
                class_4493.method_22056();
                class_4493.method_21984((int)774, (int)768);
                break;
            }
            case 8: {
                class_4493.method_22053();
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
        RenderSystem.enableTexture();
    }

    protected void setupRotate(class_4587 matrices, float delta, float brightness) {
        matrices.method_22907(class_1160.field_20703.method_23214(this.rotationStatic[0]));
        matrices.method_22907(class_1160.field_20705.method_23214(this.rotationStatic[1]));
        matrices.method_22907(class_1160.field_20707.method_23214(this.rotationStatic[2]));
        if (this.rotate) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            matrices.method_22907(class_1160.field_20703.method_23214(this.rotationAxis[0]));
            matrices.method_22907(class_1160.field_20705.method_23214(this.rotationAxis[1]));
            matrices.method_22907(class_1160.field_20707.method_23214(this.rotationAxis[2]));
            matrices.method_22907(class_1160.field_20705.method_23214(-90.0f));
            matrices.method_22907(class_1160.field_20702.method_23214(class_310.method_1551().field_1687.method_30274(delta) * 360.0f * this.rotationSpeed));
            matrices.method_22907(class_1160.field_20706.method_23214(this.rotationAxis[0]));
            matrices.method_22907(class_1160.field_20704.method_23214(this.rotationAxis[1]));
            matrices.method_22907(class_1160.field_20702.method_23214(this.rotationAxis[2]));
        }
    }

    public abstract void renderSkybox(class_4587 var1);

    protected void clearBlend(float brightness) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
    }

    protected void clearRotate(class_4587 matrices) {
        matrices.method_22907(class_1160.field_20702.method_23214(this.rotationStatic[0]));
        matrices.method_22907(class_1160.field_20704.method_23214(this.rotationStatic[1]));
        matrices.method_22907(class_1160.field_20706.method_23214(this.rotationStatic[2]));
    }

    protected void renderDecorations(class_4587 matrices, float delta) {
        WorldRendererAccessor worldRendererAccessor = (WorldRendererAccessor)class_310.method_1551().field_1769;
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22518, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22527);
        matrices.method_22903();
        float i = 1.0f - class_310.method_1551().field_1687.method_8430(delta);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)i);
        matrices.method_22907(class_1160.field_20705.method_23214(-90.0f));
        matrices.method_22907(class_1160.field_20703.method_23214(class_310.method_1551().field_1687.method_30274(delta) * 360.0f));
        class_1159 matrix4f2 = matrices.method_23760().method_23761();
        float k = 30.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        if (this.showSun) {
            class_310.method_1551().method_1531().method_22813(this.SUN);
            bufferBuilder.method_1328(7, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -k, 100.0f, -k).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, 100.0f, -k).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, 100.0f, k).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, -k, 100.0f, k).method_22913(0.0f, 1.0f).method_1344();
            class_289.method_1348().method_1350();
        }
        if (this.showMoon) {
            k = 20.0f;
            class_310.method_1551().method_1531().method_22813(this.MOON_PHASES);
            int r = class_310.method_1551().field_1687.method_30273();
            int s = r % 4;
            int m = r / 4 % 2;
            float t = (float)s / 4.0f;
            float o = (float)m / 2.0f;
            float p = (float)(s + 1) / 4.0f;
            float q = (float)(m + 1) / 2.0f;
            bufferBuilder.method_1328(7, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -k, -100.0f, k).method_22913(p, q).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, -100.0f, k).method_22913(t, q).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, -100.0f, -k).method_22913(t, o).method_1344();
            bufferBuilder.method_22918(matrix4f2, -k, -100.0f, -k).method_22913(p, o).method_1344();
            class_289.method_1348().method_1350();
        }
        if (this.showStars) {
            RenderSystem.disableTexture();
            float u = class_310.method_1551().field_1687.method_8442(delta) * i;
            if (u > 0.0f) {
                RenderSystem.color4f((float)u, (float)u, (float)u, (float)u);
                class_758.method_23792();
                worldRendererAccessor.getStarsBuffer().method_1353();
                worldRendererAccessor.getStarsBuffer().method_1351(matrices.method_23760().method_23761(), 7);
                class_291.method_1354();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            matrices.method_22909();
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
    }
}

