/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class ButtonWidgetTextures {
    private static class_2960 disabledTexture;
    private static class_2960 activeTexture;
    private static class_2960 hoveredTexture;

    private static void load() {
        if (hoveredTexture != null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_3300 resMan = mc.method_1478();
        try (InputStream in = resMan.method_14486(new class_2960("textures/gui/widgets.png")).method_14482();){
            BufferedImage img = ImageIO.read(in);
            disabledTexture = ButtonWidgetTextures.register(img, "disabled", 46);
            activeTexture = ButtonWidgetTextures.register(img, "active", 66);
            hoveredTexture = ButtonWidgetTextures.register(img, "hovered", 86);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class_2960 register(BufferedImage atlas, String name, int imageY) throws IOException {
        class_1011 img;
        class_2960 id = new class_2960("axolotlclient", "minecraft/buttonwidget/" + name);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int scale = atlas.getHeight() / 256;
            ImageIO.write((RenderedImage)atlas.getSubimage(0, imageY * scale, 200 * scale, 20 * scale), "png", out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            img = class_1011.method_4309((InputStream)in);
            in.close();
        }
        class_1043 texture = new class_1043(img);
        class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
        return id;
    }

    public static class_2960 get(int state) {
        ButtonWidgetTextures.load();
        return switch (state) {
            case 2 -> hoveredTexture;
            case 1 -> activeTexture;
            default -> disabledTexture;
        };
    }

    static {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("axolotlclient", "buttonwidget/nineslicing");
            }

            public void method_14491(class_3300 manager) {
                class_310.method_1551().method_1531().method_4615(disabledTexture);
                class_310.method_1551().method_1531().method_4615(activeTexture);
                class_310.method_1551().method_1531().method_4615(hoveredTexture);
                hoveredTexture = null;
                activeTexture = null;
                disabledTexture = null;
            }
        });
    }
}

