/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.freelook.Freelook;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.simple.ToggleSprintHud;
import io.github.axolotlclient.util.options.ForceableBooleanOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2960;

public class FeatureDisabler {
    private static final HashMap<ForceableBooleanOption, String[]> disabledServers = new HashMap();
    private static final HashMap<ForceableBooleanOption, Supplier<Boolean>> conditions = new HashMap();
    private static final Supplier<Boolean> NONE = () -> true;
    private static final class_2960 channelName = new class_2960("axolotlclient", "block_mods");
    private static final HashMap<String, ForceableBooleanOption> features = (HashMap)class_156.method_656(() -> {
        HashMap<String, ForceableBooleanOption> features = new HashMap<String, ForceableBooleanOption>();
        features.put("freelook", Freelook.getInstance().enabled);
        features.put("timechanger", AxolotlClient.config().timeChangerEnabled);
        features.put("lowfire", AxolotlClient.config().lowFire);
        features.put("fullbright", AxolotlClient.config().fullBright);
        return features;
    });
    private static String currentAddress = "";

    public static void init() {
        FeatureDisabler.setServers(AxolotlClient.config().fullBright, NONE, "gommehd");
        FeatureDisabler.setServers(AxolotlClient.config().lowFire, NONE, "gommehd");
        FeatureDisabler.setServers(Freelook.getInstance().enabled, () -> Freelook.getInstance().needsDisabling(), "hypixel", "mineplex", "gommehd", "nucleoid");
        FeatureDisabler.setServers(((ToggleSprintHud)HudManager.getInstance().get((AxoIdentifier)ToggleSprintHud.ID)).toggleSneak, NONE, "hypixel");
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (handler.method_2872() != null) {
                FeatureDisabler.onServerJoin(Objects.requireNonNull(handler.method_2872()).method_10755().toString());
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> FeatureDisabler.clear());
        ClientPlayConnectionEvents.INIT.register((handler0, client0) -> ClientPlayNetworking.registerGlobalReceiver((class_2960)channelName, (client, handler, buf, responseSender) -> {
            JsonArray array = new JsonParser().parse(buf.method_19772()).getAsJsonArray();
            for (JsonElement element : array) {
                try {
                    features.get(element.getAsString()).setForceOff(true, "ban_reason");
                }
                catch (Exception e) {
                    AxolotlClient.LOGGER.error("Failed to disable " + element.getAsString() + "!", new Object[0]);
                }
            }
        }));
    }

    private static void setServers(ForceableBooleanOption option, Supplier<Boolean> condition, String ... servers) {
        disabledServers.put(option, servers);
        conditions.put(option, condition);
    }

    public static void onServerJoin(String address) {
        currentAddress = address;
        FeatureDisabler.update();
    }

    public static void clear() {
        disabledServers.keySet().forEach(option -> option.setForceOff(false, ""));
        features.values().forEach(option -> option.setForceOff(false, ""));
    }

    public static void update() {
        disabledServers.forEach((option, strings) -> FeatureDisabler.disableOption(option, strings, currentAddress));
    }

    private static void disableOption(ForceableBooleanOption option, String[] servers, String currentServer) {
        boolean ban = false;
        for (String s : servers) {
            if (!currentServer.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
            ban = conditions.get(option).get();
            break;
        }
        if (option.isForceOff() != ban) {
            option.setForceOff(ban, "ban_reason");
        }
    }
}

