/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.ArrayList;
import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.client.gui.*;
import org.jetbrains.annotations.Nullable;

public class ContextMenu implements class_4069, class_4068, class_6379 {

	private final List<class_339> children;
	private boolean dragging;
	private class_364 focused;

	private int x;
	private int y;
	private final int width, height;
	private boolean rendering;

	protected ContextMenu(List<class_339> items) {
		children = items;
		int width = 0;
		int height = 0;
		for (class_339 d : children) {
			d.method_46419(height);
			height += d.method_25364();
			width = Math.max(width, d.method_25368());
		}
		this.width = width;
		this.height = height;
	}

	public static Builder builder() {
		return new Builder();
	}

	public void addEntry(class_339 entry) {
		children.add(entry);
	}

	@Override
	public List<? extends class_364> method_25396() {
		return children;
	}

	public List<class_339> entries() {
		return children;
	}

	@Override
	public boolean method_25397() {
		return dragging;
	}

	@Override
	public void method_25398(boolean dragging) {
		this.dragging = dragging;
	}

	@Nullable
	@Override
	public class_364 method_25399() {
		return focused;
	}

	@Override
	public void method_25395(@Nullable class_364 child) {
		if (focused != null) {
			focused.method_25365(false);
		}
		this.focused = child;
		if (focused != null) {
			focused.method_25365(true);
		}
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		if (!rendering) {
			y = mouseY;
			x = mouseX;
			rendering = true;
		}
		final int yStart = Math.min(y + 2, graphics.method_51443() - height - 2);
		final int xStart = Math.min(x + 2, graphics.method_51421() - width - 2);
		int y = yStart + 1;
		int width = 0;
		for (class_339 d : children) {
			d.method_46421(xStart + 1);
			d.method_46419(y);
			y += d.method_25364();
			width = Math.max(width, d.method_25368());
		}
		graphics.method_51448().method_22903();
		graphics.method_51448().method_46416(0, 0, 200);
		graphics.method_25294(xStart, yStart, xStart + width + 1, y, 0xDD1E1F22);
		graphics.method_49601(xStart, yStart, width + 1, y - yStart + 1, -1);
		for (class_339 c : children) {
			c.method_25358(width);
			c.method_25394(graphics, mouseX, mouseY, delta);
		}
		graphics.method_51448().method_22909();
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return method_19355(mouseX, mouseY).isPresent();
	}

	@Override
	public void method_37020(class_6382 builder) {

	}

	@Override
	public class_6380 method_37018() {
		return class_6380.field_33784;
	}

	public static class Builder {

		private final class_310 client = class_310.method_1551();

		private final List<class_339> elements = new ArrayList<>();

		public Builder() {

		}

		public Builder entry(class_2561 name, class_4185.class_4241 action) {
			elements.add(new ContextMenuEntryWithAction(name, action));
			return this;
		}

		public Builder entry(class_339 widget) {
			elements.add(widget);
			return this;
		}

		public Builder spacer() {
			elements.add(new ContextMenuEntry(class_2561.method_43470("-----")) {
				@Override
				protected void method_47399(class_6382 builder) {
				}
			});
			return this;
		}

		public Builder title(class_2561 title) {
			elements.add(new ContextMenuEntry(title));
			return this;
		}

		public ContextMenu build() {
			return new ContextMenu(elements);
		}

	}

	public static class ContextMenuEntry extends class_339 {

		private final class_310 client = class_310.method_1551();

		public ContextMenuEntry(class_2561 content) {
			super(0, 0, class_310.method_1551().field_1772.method_27525(content), 11, content);
		}

		@Override
		public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
			graphics.method_27534(client.field_1772, method_25369(), method_46426() + method_25368() / 2, method_46427(), 0xDDDDDD);
		}

		@Override
		protected void method_47399(class_6382 builder) {
			builder.method_37034(class_6381.field_33788, method_25369());
		}

		@Override
		protected boolean method_25361(double mouseX, double mouseY) {
			return false;
		}
	}

	public static class ContextMenuEntryWithAction extends class_4185 {

		public ContextMenuEntryWithAction(class_2561 message, class_4241 onPress) {
			super(0, 0, class_310.method_1551().field_1772.method_27525(message) + 4, 11, message, onPress, field_40754);
		}

		@Override
		public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {

			if (method_25367()) {
				graphics.method_25294(method_46426(), method_46427(), method_46426() + method_25368(), method_46427() + method_25364(), 0x55ffffff);
			}

			RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
			int i = this.field_22763 ? 16777215 : 10526880;
			this.method_48589(graphics, class_310.method_1551().field_1772, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
		}
	}
}
