/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class FriendsScreen extends class_437 {

	private final class_437 parent;

	private UserListWidget widget;

	private class_4185 chatButton, removeButton, onlineTab, allTab, pendingTab, blockedTab;
	private class_4185 denyButton, acceptButton, unblockButton, cancelButton;

	private Tab current = Tab.ONLINE;

	protected FriendsScreen(class_437 parent, Tab tab) {
		this(parent);
		current = tab;
	}

	public FriendsScreen(class_437 parent) {
		super(class_2561.method_43471("api.screen.friends"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		super.method_25394(graphics, mouseX, mouseY, delta);
		graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 16777215);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (super.method_25404(keyCode, scanCode, modifiers)) {
			return true;
		} else if (keyCode == 294) {
			this.refresh();
			return true;
		} else if (this.widget.method_25334() != null) {
			if (keyCode != 257 && keyCode != 335) {
				return this.widget.method_25404(keyCode, scanCode, modifiers);
			} else {
				this.openChat();
				return true;
			}
		} else {
			return false;
		}
	}

	@Override
	protected void method_25426() {
		method_37063(widget = new UserListWidget(this, field_22787, field_22789, field_22790, 32, field_22790 - 64, 35));

		widget.method_25396().clear();

		if (current == Tab.ALL || current == Tab.ONLINE) {
			FriendRequest.getInstance().getFriends().whenCompleteAsync((list, t) -> widget.setUsers(list.stream().sorted((u1, u2) ->
				new AlphabeticalComparator().compare(u1.getName(), u2.getName())).filter(user -> {
				if (current == Tab.ONLINE) {
					return user.getStatus().isOnline();
				}
				return true;
			}).toList()));
		} else if (current == Tab.PENDING) {
			FriendRequest.getInstance().getFriendRequests().whenCompleteAsync((con, th) -> {

				con.getLeft().stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
					.forEach(user -> widget.addEntry(new UserListWidget.UserListEntry(user, class_2561.method_43471("api.friends.pending.incoming"))));
				con.getRight().stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
					.forEach(user -> widget.addEntry(new UserListWidget.UserListEntry(user, class_2561.method_43471("api.friends.pending.outgoing")).outgoing()));
			});
		} else if (current == Tab.BLOCKED) {
			FriendRequest.getInstance().getBlocked().whenCompleteAsync((list, th) -> widget.setUsers(list.stream().sorted((u1, u2) ->
				new AlphabeticalComparator().compare(u1.getName(), u2.getName())).toList()));
		}

		this.method_37063(blockedTab = class_4185.method_46430(class_2561.method_43471("api.friends.tab.blocked"), button ->
				field_22787.method_1507(new FriendsScreen(parent, Tab.BLOCKED)))
			.method_46434(this.field_22789 / 2 + 24, this.field_22790 - 52, 57, 20).method_46431());

		this.method_37063(pendingTab = class_4185.method_46430(class_2561.method_43471("api.friends.tab.pending"), button ->
				field_22787.method_1507(new FriendsScreen(parent, Tab.PENDING)))
			.method_46434(this.field_22789 / 2 - 34, this.field_22790 - 52, 57, 20).method_46431());

		this.method_37063(allTab = class_4185.method_46430(class_2561.method_43471("api.friends.tab.all"), button ->
				field_22787.method_1507(new FriendsScreen(parent, Tab.ALL)))
			.method_46434(this.field_22789 / 2 - 94, this.field_22790 - 52, 57, 20).method_46431());

		this.method_37063(onlineTab = class_4185.method_46430(class_2561.method_43471("api.friends.tab.online"), button ->
				field_22787.method_1507(new FriendsScreen(parent, Tab.ONLINE)))
			.method_46434(this.field_22789 / 2 - 154, this.field_22790 - 52, 57, 20).method_46431());

		this.method_37063(class_4185.method_46430(class_2561.method_43471("api.friends.add"),
				button -> field_22787.method_1507(new AddFriendScreen(this)))
			.method_46434(this.field_22789 / 2 + 88, this.field_22790 - 52, 66, 20).method_46431());

		this.removeButton = this.method_37063(class_4185.method_46430(class_2561.method_43471("api.friends.remove"), button -> {
			UserListWidget.UserListEntry entry = this.widget.method_25334();
			if (entry != null) {
				removeButton.field_22763 = false;
				FriendRequest.getInstance().removeFriend(entry.getUser()).thenRun(() -> client.submit(this::refresh));
			}
		}).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20).method_46431());

		method_37063(denyButton = new class_4185.class_7840(class_2561.method_43471("api.friends.request.deny"),
			button -> denyRequest()).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 48, 20).method_46431());

		method_37063(acceptButton = new class_4185.class_7840(class_2561.method_43471("api.friends.request.accept"),
			button -> acceptRequest()).method_46434(this.field_22789 / 2 + 2, this.field_22790 - 28, 48, 20).method_46431());

		unblockButton = method_37063(class_4185.method_46430(class_2561.method_43471("api.users.unblock"),
			b -> {
				b.field_22763 = false;
				FriendRequest.getInstance().unblockUser(widget.method_25334().getUser()).thenRun(() -> client.execute(this::refresh));
			}).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20).method_46431());
		cancelButton = method_37063(class_4185.method_46430(class_5244.field_24335, b -> {
			b.field_22763 = false;
			FriendRequest.getInstance().cancelFriendRequest(widget.method_25334().getUser()).thenRun(() -> client.execute(this::refresh));
		}).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20).method_46431());

		this.method_37063(chatButton = class_4185.method_46430(class_2561.method_43471("api.friends.chat"), button -> openChat())
			.method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 100, 20)
			.method_46431()
		);

		this.method_37063(
			class_4185.method_46430(class_5244.field_24339, button -> this.field_22787.method_1507(this.parent))
				.method_46434(this.field_22789 / 2 + 4 + 50, this.field_22790 - 28, 100, 20)
				.method_46431()
		);
		updateButtonActivationStates();
	}

	private void refresh() {
		field_22787.method_1507(new FriendsScreen(parent));
	}

	private void denyRequest() {
		UserListWidget.UserListEntry entry = widget.method_25334();
		if (entry != null) {
			denyButton.field_22763 = false;
			FriendRequest.getInstance().denyFriendRequest(entry.getUser()).thenRun(() -> client.submit(this::refresh));
		}
	}

	private void acceptRequest() {
		UserListWidget.UserListEntry entry = widget.method_25334();
		if (entry != null) {
			acceptButton.field_22763 = false;
			FriendRequest.getInstance().acceptFriendRequest(entry.getUser()).thenRun(() -> client.submit(this::refresh));
		}
	}

	private void updateButtonActivationStates() {
		UserListWidget.UserListEntry entry = widget.method_25334();
		chatButton.field_22763 = entry != null && (current == Tab.ALL || current == Tab.ONLINE);

		removeButton.field_22764 = true;
		unblockButton.field_22763 = removeButton.field_22763 = entry != null;
		denyButton.field_22764 = false;
		acceptButton.field_22764 = unblockButton.field_22764 = cancelButton.field_22764 = false;
		if (current == Tab.ONLINE) {
			onlineTab.field_22763 = false;
			allTab.field_22763 = pendingTab.field_22763 = blockedTab.field_22763 = true;
		} else if (current == Tab.ALL) {
			allTab.field_22763 = false;
			onlineTab.field_22763 = pendingTab.field_22763 = blockedTab.field_22763 = true;
		} else if (current == Tab.PENDING) {
			pendingTab.field_22763 = false;
			onlineTab.field_22763 = allTab.field_22763 = blockedTab.field_22763 = true;
			removeButton.field_22764 = false;

			if (entry != null && entry.isOutgoingRequest()) {
				cancelButton.field_22764 = true;
			} else {
				denyButton.field_22764 = true;
				acceptButton.field_22764 = true;
			}
			denyButton.field_22763 = acceptButton.field_22763 = entry != null;
		} else if (current == Tab.BLOCKED) {
			blockedTab.field_22763 = false;
			onlineTab.field_22763 = allTab.field_22763 = pendingTab.field_22763 = true;
			removeButton.field_22764 = false;
			unblockButton.field_22764 = true;
		}
	}

	public void openChat() {
		if (!chatButton.field_22763) {
			return;
		}
		UserListWidget.UserListEntry entry = widget.method_25334();
		if (entry != null) {
			chatButton.field_22763 = false;
			ChannelRequest.getOrCreateDM(entry.getUser())
				.thenAccept(c -> client.execute(() -> client.setScreen(new ChatScreen(this, c))));
		}
	}

	public void select(UserListWidget.UserListEntry entry) {
		this.widget.method_25313(entry);
		this.updateButtonActivationStates();
	}

	public enum Tab {
		ONLINE,
		ALL,
		PENDING,
		BLOCKED
	}
}
