/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.ChannelInvite;
import io.github.axolotlclient.api.util.UUIDHelper;
import org.jetbrains.annotations.NotNull;

public class ChannelInvitesScreen extends class_437 {
	private final class_437 parent;
	private class_4185 acceptButton;
	private class_4185 denyButton;
	private InvitesListWidget invites;

	public ChannelInvitesScreen(class_437 parent) {
		super(class_2561.method_43471("api.channels.invites"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {

		class_8132 hFL = new class_8132(this, 33, 55);

		hFL.method_57726(field_22785, field_22793);

		invites = hFL.method_48999(new InvitesListWidget(field_22787, hFL.method_48998(), field_22789, hFL.method_57727(), 25));


		var footer = hFL.method_48996(class_8667.method_52741().method_52735(4));
		var footerTop = footer.method_52736(class_8667.method_52742().method_52735(4));
		acceptButton = footerTop.method_52736(class_4185.method_46430(class_2561.method_43471("api.channels.invite.accept"), w -> {
			if (invites.method_25334() != null) {
				w.field_22763 = false;
				ChannelRequest.acceptChannelInvite(invites.method_25334().invite).thenRun(() -> field_22787.method_5385(this::clearAndInit));
			}
		}).method_46432(73).method_46431());
		denyButton = footerTop.method_52736(class_4185.method_46430(class_2561.method_43471("api.channels.invite.ignore"), w -> {
			if (invites.method_25334() != null) {
				w.field_22763 = false;
				ChannelRequest.ignoreChannelInvite(invites.method_25334().invite).thenRun(() -> field_22787.method_5385(this::clearAndInit));
			}
		}).method_46432(73).method_46431());
		footer.method_52736(class_4185.method_46430(class_5244.field_24339, w -> method_25419()).method_46431());

		hFL.method_48222();

		hFL.method_48206(this::method_37063);
		updateButtons();
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
	}

	private void updateButtons() {
		denyButton.field_22763 = acceptButton.field_22763 = invites.method_25334() != null;
	}

	private class InvitesListWidget extends class_4280<InvitesListWidget.InvitesListEntry> {

		public InvitesListWidget(class_310 client, int y, int width, int height, int entryHeight) {
			super(client, width, height, y, entryHeight);
			ChannelRequest.getChannelInvites().thenAccept(list ->
				list.stream().map(InvitesListEntry::new).forEach(this::method_25321));
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			boolean bl = super.method_25402(mouseX, mouseY, button);
			updateButtons();
			return bl;
		}

		private class InvitesListEntry extends Entry<InvitesListEntry> {

			private final ChannelInvite invite;
			private final CompletableFuture<String> fromName;

			public InvitesListEntry(ChannelInvite invite) {
				this.invite = invite;
				this.fromName = UUIDHelper.tryGetUsernameAsync(invite.fromUuid());
			}

			@Override
			public @NotNull class_2561 getNarration() {
				return class_2561.method_43469("api.channels.invite.desc", invite.fromUuid(), invite.channelName());
			}

			@Override
			public void render(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
				graphics.method_27535(field_22793, class_2561.method_43469("api.channels.invite.name", invite.channelName()), left + 2, top + 2, -1);
				if (fromName.isDone()) {
					graphics.method_27535(field_22793, class_2561.method_43469("api.channels.invite.from", fromName.join()).method_10862(class_2583.field_24360.method_10978(true)), left + 15, top + height - field_22793.field_2000 - 1, 0xFF808080);
				}

			}
		}
	}
}
