/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin;

import java.util.*;
import java.util.stream.Collectors;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.github.axolotlclient.bridge.AxoGameOptions;
import io.github.axolotlclient.bridge.AxoMinecraftClient;
import io.github.axolotlclient.bridge.AxoPlayerListEntry;
import io.github.axolotlclient.bridge.AxoSession;
import io.github.axolotlclient.bridge.entity.AxoEntity;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.render.AxoFont;
import io.github.axolotlclient.bridge.resource.AxoResourceManager;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.bridge.world.AxoWorld;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_320;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3300;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_8646;
import net.minecraft.class_9011;
import net.minecraft.scoreboard.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_310.class)
public abstract class MinecraftClientMixin implements AxoMinecraftClient {
	@Final
	@Shadow
	public class_327 textRenderer;

	@Shadow
	public class_746 player;

	@Shadow
	public class_638 world;

	@Final
	@Shadow
	public class_315 options;

	@Shadow
	@Final
	private class_320 session;

	@Shadow
	public abstract boolean isInSingleplayer();

	@Shadow
	@Nullable
	public abstract class_642 getCurrentServerEntry();

	@Shadow
	@Final
	public class_329 inGameHud;

	@Shadow
	@Nullable
	public class_437 currentScreen;

	@Shadow
	public abstract class_3300 getResourceManager();

	@Shadow
	@Final
	public class_761 worldRenderer;

	@Shadow
	@Nullable
	public class_1297 cameraEntity;

	@Override
	public @Nullable AxoPlayer br$getPlayer() {
		return player;
	}

	@Override

	public AxoWorld br$getWorld() {
		return world;
	}

	@Override
	public AxoFont br$getFont() {
		return textRenderer;
	}

	@Override
	public AxoGameOptions br$getGameOptions() {
		return options;
	}

	@Override
	public AxoSession br$getSession() {
		return new AxoSession(session.method_1676(), session.method_44717().toString(), session.method_1674());
	}

	@Override
	public boolean br$isLocalServer() {
		return isInSingleplayer();
	}

	@Override
	public String br$getServerAddress() {
		return Optional.ofNullable(getCurrentServerEntry()).map(x -> x.field_3761).orElse(null);
	}

	@Override
	public String br$getServerName() {
		return Optional.ofNullable(getCurrentServerEntry()).map(x -> x.field_3752).orElse(null);
	}

	@Override
	public Collection<? extends AxoPlayerListEntry> br$getOnlinePlayers() {
		return player.field_3944.method_2880();
	}

	@Override
	public void br$sendToClient(AxoText msg) {
		inGameHud.method_1743().method_1812((class_2561) msg);
	}

	@Override
	public void br$sendToServer(String msg) {
		if (msg.startsWith("/")) {
			player.field_3944.method_45731(msg.substring(1));
		} else {
			player.field_3944.method_45730(msg);
		}
	}

	@Override
	public void br$reinitScreen() {
		if (currentScreen != null) {
			currentScreen.method_25423((class_310) (Object) this, currentScreen.field_22789, currentScreen.field_22790);
		}
	}

	@Override
	public AxoResourceManager br$getResourceManager() {
		return getResourceManager();
	}

	@Override
	public Object br$getScreen() {
		return currentScreen;
	}

	@Override
	public void br$notifyLevelRenderer() {
		worldRenderer.method_3292();
	}

	@Override
	public AxoEntity br$getCameraEntity() {
		return cameraEntity;
	}

	@Override
	public List<String> br$getSidebar() {
		List<String> lines = new ArrayList<>();
		class_310 client = class_310.method_1551();
		if (client.field_1687 == null)
			return lines;

		class_269 scoreboard = client.field_1687.method_8428();
		if (scoreboard == null)
			return lines;
		class_266 sidebar = scoreboard.method_1189(class_8646.field_45157);
		if (sidebar == null)
			return lines;

		Collection<class_9011> scores = scoreboard.method_1184(sidebar);
		List<class_9011> list = scores.stream().filter(
				input -> input != null && input.comp_2127() != null && !input.method_55385())
			.collect(Collectors.toList());

		if (list.size() > 15) {
			scores = Lists.newArrayList(Iterables.skip(list, scores.size() - 15));
		} else {
			scores = list;
		}

		for (class_9011 score : scores) {
			class_268 team = scoreboard.method_1164(score.comp_2127());
			if (team == null)
				return lines;
			String text = team.method_1144().getString() + team.method_1136().getString();
			if (!text.trim().isEmpty())
				lines.add(text);
		}

		lines.add(sidebar.method_1114().getString());
		Collections.reverse(lines);

		return lines;
	}

}
