/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.entity;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import io.github.axolotlclient.bridge.entity.AxoEntity;
import io.github.axolotlclient.bridge.math.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1297.class)
public abstract class EntityMixin implements AxoEntity {
	@Shadow
	@Nullable
	private class_1297 vehicle;

	@Shadow
	private boolean onGround;

	@Shadow
	public abstract class_243 getRotationVec(float tickDelta);

	@Shadow
	private float yaw;

	@Shadow
	public abstract UUID getUuid();

	@Shadow
	public abstract class_243 getPos();

	@Shadow
	public abstract class_243 getVelocity();

	@Shadow
	private float pitch;

	@Shadow
	private int id;

	@Override
	public @Nullable AxoEntity br$getVehicle() {
		return vehicle;
	}

	@Override
	public Vec3 br$getPos() {
		return new Vec3(getPos().field_1352, getPos().field_1351, getPos().field_1350);
	}

	@Override
	public Vec3 br$getVelocity() {
		return new Vec3(getVelocity().field_1352, getVelocity().field_1351, getVelocity().field_1350);
	}

	@Override
	public boolean br$isOnGround() {
		return onGround;
	}

	@Override
	public float br$getYaw() {
		return yaw;
	}

	@Override
	public float br$getPitch() {
		return pitch;
	}

	@Override
	public Vec3 br$getRotation(float deltaTick) {
		final var vec = getRotationVec(deltaTick);
		return new Vec3(vec.field_1352, vec.field_1351, vec.field_1350);
	}

	@Override
	public UUID br$getUuid() {
		return getUuid();
	}

	@Override
	public int br$getNetId() {
		return id;
	}
}
