/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.key;

import io.github.axolotlclient.bridge.AxoGameOptions;
import io.github.axolotlclient.bridge.AxoPerspective;
import io.github.axolotlclient.bridge.key.AxoKeybinding;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_5498;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_315.class)
public abstract class GameOptionsMixin implements AxoGameOptions {
	@Shadow
	@Final
	public class_304 sprintKey;

	@Shadow
	@Final
	public class_304 sneakKey;

	@Shadow
	@Final
	public class_304 attackKey;

	@Shadow
	@Final
	public class_304 useKey;

	@Shadow
	public abstract class_5498 getPerspective();

	@Shadow
	public abstract void setPerspective(class_5498 perspective);

	@Override
	public AxoKeybinding br$getSprintKeybind() {
		return sprintKey;
	}

	@Override
	public AxoKeybinding br$getSneakKeybind() {
		return sneakKey;
	}

	@Override
	public AxoKeybinding br$getAttackKey() {
		return attackKey;
	}

	@Override
	public AxoKeybinding br$getUseKey() {
		return useKey;
	}

	@Override
	public AxoPerspective br$getCameraType() {
		return switch (getPerspective()) {
			case field_26664 -> AxoPerspective.FIRST_PERSON;
			case field_26665 -> AxoPerspective.THIRD_PERSON_BACK;
			case field_26666 -> AxoPerspective.THIRD_PERSON_FRONT;
		};
	}

	@Override
	public void br$setCameraType(AxoPerspective perspective) {
		setPerspective(switch (perspective) {
			case FIRST_PERSON -> class_5498.field_26664;
			case THIRD_PERSON_BACK -> class_5498.field_26665;
			case THIRD_PERSON_FRONT -> class_5498.field_26666;
		});
	}
}
