/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.config;

import java.util.ArrayList;
import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.ui.ConfigUI;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.StringArrayOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.RecreatableScreen;
import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.config.screen.CreditsScreen;
import io.github.axolotlclient.config.screen.ProfilesScreen;
import io.github.axolotlclient.mixin.OverlayTextureAccessor;
import io.github.axolotlclient.util.keybinds.KeyBinds;
import io.github.axolotlclient.util.options.GenericOption;
import lombok.Getter;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class AxolotlClientConfig extends AxolotlClientConfigCommon {
	public final BooleanOption customSky = new BooleanOption("customSky", false);

	public final BooleanOption lowShield = new BooleanOption("lowShield", false);
	public final ColorOption hitColor = new ColorOption("hitColor", new Color(255, 0, 0, 77),
		value -> {
			//noinspection resource
			class_1043 texture = ((OverlayTextureAccessor) class_310.method_1551().field_1773.method_22975()).axolotlclient$getTexture();
			class_1011 nativeImage = texture.method_4525();
			if (nativeImage != null) {
				int color = 255 - value.getAlpha();
				color = (color << 8) + value.getBlue();
				color = (color << 8) + value.getGreen();
				color = (color << 8) + value.getRed();

				for (int i = 0; i < 8; ++i) {
					for (int j = 0; j < 8; ++j) {
						nativeImage.method_4305(j, i, color);
					}
				}

				RenderSystem.activeTexture(33985);
				texture.method_23207();
				nativeImage.method_22619(0, 0, 0, 0, 0,
					nativeImage.method_4307(), nativeImage.method_4323(), false, true, false, false);
				RenderSystem.activeTexture(33984);
			}
		});

	public final BooleanOption flatItems = new BooleanOption("flatItems", false);

	public final BooleanOption customLoadingScreenColor = new BooleanOption("custom_loading_bg_color", false);
	public final ColorOption loadingScreenColor = new ColorOption("loadingBgColor", new Color(239, 50, 61, 255));
	public final BooleanOption nightMode = new BooleanOption("nightMode", false);

	public final GenericOption openCredits = new GenericOption("Credits", "Open Credits", () ->
		class_310.method_1551().method_1507(new CreditsScreen(class_310.method_1551().field_1755))
	);

	@Getter
	private final List<Option<?>> options = new ArrayList<>();

	public AxolotlClientConfig() {
		general.add(customLoadingScreenColor);
		general.add(loadingScreenColor);
		general.add(nightMode);
		general.add(openCredits);

		ConfigUI.getInstance().runWhenLoaded(() -> {
			general.getOptions().removeIf(o -> "configStyle".equals(o.getName()));
			String[] themes = ConfigUI.getInstance().getStyleNames().stream().map(s -> "configStyle." + s)
				.filter(s -> AxolotlClientCommon.SHADERS_SUPPORTED || !s.startsWith("rounded"))
				.toArray(String[]::new);
			if (themes.length > 1) {
				StringArrayOption configStyle;
				general.add(configStyle = new StringArrayOption("configStyle", themes,
					"configStyle." + ConfigUI.getInstance().getCurrentStyle().getName(), s -> {
					ConfigUI.getInstance().setStyle(s.split("\\.")[1]);

					class_437 newScreen = RecreatableScreen.tryRecreate(class_310.method_1551().field_1755);
					class_310.method_1551().method_1507(newScreen);
				}));
				AxolotlClient.getInstance().getConfigManager().load();
				ConfigUI.getInstance().setStyle(configStyle.get().split("\\.")[1]);
			} else {
				AxolotlClient.getInstance().getConfigManager().load();
			}
		});

		rendering.add(customSky,
			lowShield,
			hitColor,
			flatItems);

		general.add(new GenericOption("profiles.title", "profiles.configure", () ->
			class_310.method_1551().method_1507(new ProfilesScreen(class_310.method_1551().field_1755))), false);

		var toggleFullbright = new class_304("toggle_fullbright", -1, "category.axolotlclient");
		KeyBinds.getInstance().registerWithSimpleAction(toggleFullbright, fullBright::toggle);
	}
}
