/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Collection;
import java.util.Queue;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_4184;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_765;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.modules.particles.Particles;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_702.class)
public abstract class ParticleManagerMixin {

	@Unique
	private class_2396<?> cachedType;

	@Inject(method = "addParticle(Lnet/minecraft/particle/ParticleEffect;DDDDDD)Lnet/minecraft/client/particle/Particle;", at = @At(value = "HEAD"), cancellable = true)
	private void axolotlclient$afterCreation(class_2394 parameters, double x, double y, double z, double velocityX,
											 double velocityY, double velocityZ, CallbackInfoReturnable<class_703> cir) {
		cachedType = parameters.method_10295();

		if (!Particles.getInstance().getShowParticle(cachedType)) {
			cir.setReturnValue(null);
			cir.cancel();
		}
	}

	@Inject(method = "addParticle(Lnet/minecraft/client/particle/Particle;)V", at = @At(value = "HEAD"))
	private void axolotlclient$afterCreation(class_703 particle, CallbackInfo ci) {
		if (cachedType != null) {
			Particles.getInstance().particleMap.put(particle, cachedType);
			cachedType = null;
		}
	}

	@Redirect(method = "tickParticles", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/ParticleManager;tickParticle(Lnet/minecraft/client/particle/Particle;)V"))
	private void axolotlclient$removeParticlesWhenRemoved(class_702 instance, class_703 particle) {
		if (!particle.method_3086()) {
			Particles.getInstance().particleMap.remove(particle);
		}
		tickParticle(particle);
	}

	@Shadow
	protected abstract void tickParticle(class_703 particle);

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Ljava/util/Queue;removeAll(Ljava/util/Collection;)Z"))
	private boolean axolotlclient$removeEmitterParticlesWhenRemoved(Queue<class_703> instance, Collection<class_703> collection) {
		collection.forEach(particle -> Particles.getInstance().particleMap.remove(particle));

		return instance.removeAll(collection);
	}

	@Inject(method = "renderParticles", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/Particle;buildGeometry(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/render/Camera;F)V"), locals = LocalCapture.CAPTURE_FAILHARD)
	private void axolotlclient$applyOptions(class_765 lightmap,
											class_4184 camera,
											float tickDelta,
											CallbackInfo ci,
											@Local class_703 particle) {
		if (Particles.getInstance().particleMap.containsKey(particle)) {
			Particles.getInstance().applyOptions(particle);
		}
	}
}
