/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.hypixel.NickHider;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin {

	@WrapOperation(method = "renderLabelIfPresent(Lnet/minecraft/client/network/AbstractClientPlayerEntity;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/LivingEntityRenderer;renderLabelIfPresent(Lnet/minecraft/entity/Entity;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IF)V"))
	private void axolotlclient$modifiyName(class_1007 instance, class_1297 entity, class_2561 text, class_4587 stack, class_4597 vertexConsumerProvider, int i, float v, Operation<Void> original, @Local(argsOnly = true) class_742 player) {
		if (AxolotlClient.config() != null) {
			var mc = class_310.method_1551();
			if (mc.field_1724 != null) {
				if (player.method_5667() == mc.field_1724.method_5667()
					&& NickHider.getInstance().hideOwnName.get()) {
					text = (class_2561) NickHider.getInstance().editComponent(text, player.method_5477().getString(), NickHider.getInstance().hiddenNameSelf.get());
				} else if (player.method_5667() != mc.field_1724.method_5667()
					&& NickHider.getInstance().hideOtherNames.get()) {
					text = (class_2561) NickHider.getInstance().editComponent(text, player.method_5477().getString(), NickHider.getInstance().hiddenNameOthers.get());
				}
			}
		}
		original.call(instance, entity, text, stack, vertexConsumerProvider, i, v);
	}
}
