/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Getter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_7532;

public class AccountsListWidget extends class_4280<AccountsListWidget.Entry> {

	private final AccountsScreen screen;

	public AccountsListWidget(AccountsScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
		super(client, width, bottom - top, top, entryHeight);
		this.screen = screen;
	}

	public void setAccounts(List<Account> accounts) {
		accounts.forEach(account -> method_25321(new Entry(screen, account)));
	}

	@Override
	public int method_25322() {
		return super.method_25322() + 85;
	}

	@Override
	protected int method_25329() {
		return super.method_25329() + 30;
	}

	@Override
	public boolean method_25370() {
		return this.screen.method_25399() == this;
	}

	@Environment(EnvType.CLIENT)
	public static class Entry extends class_4280.class_4281<AccountsListWidget.Entry> {

		private static final class_2960 checkmark = class_2960.method_60655("axolotlclient", "textures/check.png");
		private static final class_2960 warningSign = class_2960.method_60655("axolotlclient", "textures/warning.png");

		private final AccountsScreen screen;
		@Getter
		private final Account account;
		private final class_310 client;
		private long time;

		public Entry(AccountsScreen screen, Account account) {
			this.screen = screen;
			this.account = account;
			this.client = class_310.method_1551();
		}

		@Override
		public class_2561 method_37006() {
			return class_2561.method_30163(account.getName());
		}

		@Override
		public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
			RenderSystem.enableBlend();
			if (Auth.getInstance().getCurrent().equals(account)) {
				graphics.method_25290(checkmark, x - 35, y + 1, 0, 0, 32, 32, 32, 32);
			} else if (account.isExpired()) {
				graphics.method_25290(warningSign, x - 35, y + 1, 0, 0, 32, 32, 32, 32);
			}
			class_2960 texture = Auth.getInstance().getSkinTexture(account);
			class_7532.method_44443(graphics, texture, x - 1, y - 1, 33);

			graphics.method_51433(client.field_1772, account.getName(), x + 3 + 33, y + 1, -1, false);
			graphics.method_51433(client.field_1772, account.getUuid(), x + 3 + 33, y + 12, 8421504, false);
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			this.screen.select(this);
			if (class_156.method_658() - this.time < 250L && client.field_1687 == null) {
				if (!getAccount().equals(Auth.getInstance().getCurrent())) {
					screen.select(null);
					Auth.getInstance().login(account);
				}
			}

			this.time = class_156.method_658();
			return false;
		}

	}
}
