/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import lombok.Getter;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_490;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class PlayerHud extends PlayerHudCommon {
	@Getter
	private static boolean currentlyRendering;

	public PlayerHud() {
		super();
		Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
	}

	public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
		yawOffset += (event.yaw() - event.prevYaw()) / 2;
	}

	@Override
	public void tick() {
		super.tick();
		var client = class_310.method_1551();
		if (client.field_1724 != null && client.field_1724.method_20232()) {
			float rawPitch = client.field_1724.method_5799() ? -90.0F - client.field_1724.method_36455() : -90.0F;
			float pitch = class_3532.method_16439(client.field_1724.method_6024(1), 0.0F, rawPitch);
			float height = client.field_1724.method_17682();
			// sin = opposite / hypotenuse
			float offset = (float) (Math.sin(Math.toRadians(pitch)) * height);
			yOffset = Math.abs(offset) + 35;
		} else if (client.field_1724 != null && client.field_1724.method_6128()) {
			// Elytra!

			float j = (float) client.field_1724.method_6003() + 1;
			float k = class_3532.method_15363(j * j / 100.0F, 0.0F, 1.0F);

			float pitch = k * (-90.0F - client.field_1724.method_36455()) + 90;
			float height = client.field_1724.method_17682();
			// sin = opposite / hypotenuse
			float offset = (float) (Math.sin(Math.toRadians(pitch)) * height) * 50;
			yOffset = 35 - offset;
			if (pitch < 0) {
				yOffset -= (float) (((1 / (1 + Math.exp(-pitch / 4))) - .5) * 20);
			}
		} else {
			yOffset *= .8f;
		}
	}

	@Override
	protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
		var client = class_310.method_1551();
		var graphics = (class_332) ctx;
		if (client.field_1724 == null) {
			return;
		}

		if (!placeholder && autoHide.get()) {
			if (isPerformingAction()) {
				hide = -1;
			} else if (hide == -1) {
				hide = System.currentTimeMillis();
			}

			if (hide != -1 && System.currentTimeMillis() - hide > 500) {
				return;
			}
		}

		float lerpY = (lastYOffset + ((yOffset - lastYOffset) * delta));

		float scale = getScale() * 40;

		Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0F);

		// Rotate to whatever is wanted. Also make sure to offset the yaw
		float deltaYaw = client.field_1724.method_5705(delta);
		if (dynamicRotation.get()) {
			deltaYaw -= (lastYawOffset + ((yawOffset - lastYawOffset) * delta));
		}
		Quaternionf quaternionf2 = new Quaternionf().fromAxisAngleDeg(new Vector3f(0, 1, 0), deltaYaw - 180 + rotation.get().floatValue());
		quaternion.mul(quaternionf2);

		// Save these to set them back later
		float pastYaw = client.field_1724.method_36454();
		float pastPrevYaw = client.field_1724.field_5982;
		currentlyRendering = true;
		class_490.method_48472(graphics,
			((float) (x + getTrueContentWidth() / 2f)) / getScale(),
			((float) (y + getTrueContentHeight() * client.field_1724.method_17682() / 2f - lerpY)) / getScale(),
			scale, new Vector3f(), quaternion, quaternionf2, client.field_1724);
		currentlyRendering = false;

		client.field_1724.method_36456(pastYaw);
		client.field_1724.field_5982 = pastPrevYaw;
	}

	private boolean isPerformingAction() {
		// inspired by tr7zw's mod
		class_746 player = class_310.method_1551().field_1724;
		//noinspection DataFlowIssue
		return player.method_5715() || player.method_5624() || player.method_6128() || player.method_31549().field_7479
			|| player.method_5869() || player.method_20232() || player.method_5765()
			|| player.method_6115() || player.field_6252 || player.field_6235 > 0 || player.method_5809();
	}
}
