/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;

public class KeystrokesScreen extends class_437 {

	private final List<KeystrokeHud.Keystroke> keys;
	public final KeystrokeHud hud;
	private final class_437 screen;
	public final class_8132 layout = new class_8132(this);
	private final KeyBindsList keyBindsList;

	public KeystrokesScreen(KeystrokeHud hud, class_437 screen) {
		super(class_2561.method_43471("keystrokes.keys"));
		if (hud.keystrokes == null) {
			hud.setKeystrokes();
		}
		this.keys = hud.keystrokes;
		this.hud = hud;
		this.screen = screen;
		this.keyBindsList = new KeyBindsList(this);
	}

	@Override
	protected void method_25426() {
		layout.method_57726(method_25440(), field_22793);
		layout.method_48999(keyBindsList);
		var resetButton = class_4185.method_46430(class_2561.method_43471("controls.resetAll"), button -> {
			keys.clear();
			hud.setDefaultKeystrokes();
			keyBindsList.reload();
			hud.saveKeystrokes();
		}).method_46431();
		class_8667 linearLayout = this.layout.method_48996(class_8667.method_52742().method_52735(8));
		linearLayout.method_52736(resetButton);
		linearLayout.method_52736(class_4185.method_46430(class_5244.field_24334, button -> this.method_25419()).method_46431());
		this.layout.method_48206(this::method_37063);
		this.method_48640();
	}

	@Override
	protected void method_48640() {
		this.layout.method_48222();
		this.keyBindsList.method_57712(this.field_22789, this.layout);
		keyBindsList.reload();
	}

	@Override
	public void method_25419() {
		this.field_22787.method_1507(this.screen);
		hud.saveKeystrokes();
	}

	public void removeKey(KeystrokeHud.Keystroke key) {
		keys.remove(key);
	}
}
