/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.util;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class DrawUtil {

	public static void fillRect(class_332 graphics, Rectangle rectangle, Color color) {
		fillRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
	}

	public static void fillRect(class_332 graphics, int x, int y, int width, int height, int color) {
		graphics.method_25294(x, y, x + width, y + height, color);
	}

	public static void outlineRect(class_332 graphics, Rectangle rectangle, Color color) {
		outlineRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
	}

	public static void outlineRect(class_332 graphics, int x, int y, int width, int height, int color) {
		fillRect(graphics, x, y, 1, height - 1, color);
		fillRect(graphics, x + width - 1, y + 1, 1, height - 1, color);
		fillRect(graphics, x + 1, y, width - 1, 1, color);
		fillRect(graphics, x, y + height - 1, width - 1, 1, color);
	}

	public static void drawCenteredString(class_332 graphics, class_327 renderer, String text, int x, int y,
										  Color color, boolean shadow) {
		drawCenteredString(graphics, renderer, text, x, y, color.toInt(), shadow);
	}

	public static void drawCenteredString(class_332 graphics, class_327 renderer, String text, int x, int y,
										  int color, boolean shadow) {
		drawString(graphics, text, (float) (x - renderer.method_1727(text) / 2), (float) y, color, shadow);
	}

	public static void drawString(class_332 graphics, String text, float x, float y, int color, boolean shadow) {
		graphics.method_51433(class_310.method_1551().field_1772, text, (int) x, (int) y, color, shadow);
	}

	public static void drawString(class_332 graphics, String text, float x, float y, Color color, boolean shadow) {
		drawString(graphics, text, x, y, color.toInt(), shadow);
	}
}
