/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import org.joml.Matrix4f;

public class LoadingImageScreen extends class_437 {

	private static final int bgColor = Colors.DARK_GRAY.toInt();
	private static final int accent = Colors.GRAY.withBrightness(0.5f).withAlpha(128).toInt();

	private final class_437 parent;
	private final CompletableFuture<Void> future;
	private final boolean freeOnClose;
	private final float loadStart = class_156.method_658();

	LoadingImageScreen(class_437 parent, CompletableFuture<Void> future, boolean freeOnClose) {
		super(class_2561.method_43471("gallery.image.loading.title"));
		this.parent = parent;
		this.future = future;
		this.freeOnClose = freeOnClose;
	}

	@Override
	protected void method_25426() {
		class_8132 layout = new class_8132(this);
		class_8667 header = layout.method_48992(class_8667.method_52741()).method_52735(4);
		header.method_52740().method_46467();
		header.method_52736(new class_7842(method_25440(), field_22793));

		int buttonWidth = 75;
		int imageWidth = layout.method_25368() - 20 - buttonWidth - 4;
		int imageHeight = layout.method_57727();

		var contents = layout.method_48999(class_8667.method_52742().method_52735(4));
		var footer = layout.method_48996(class_8667.method_52742().method_52735(4));
		contents.method_52736(new LoadingWidget(imageWidth, imageHeight));
		var actions = contents.method_52736(class_8667.method_52741()).method_52735(4);
		actions.method_52736(new LoadingWidget(buttonWidth, 20));
		actions.method_52736(new LoadingWidget(buttonWidth, 20));

		footer.method_52736(class_4185.method_46430(class_5244.field_24339, b -> method_25419()).method_46431());

		layout.method_48222();
		layout.method_48206(this::method_37063);
	}

	@Override
	public void method_25419() {
		if (freeOnClose) {
			future.cancel(false);
		}
		field_22787.method_1507(parent);
	}

	private void drawHorizontalGradient(class_332 guiGraphics, int x1, int y1, int y2, int x2) {
		class_4588 consumer = field_22787.method_22940().method_23000().getBuffer(class_1921.method_51784());
		Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
		consumer.method_22918(matrix4f, x1, y1, 0).method_39415(LoadingImageScreen.bgColor);
		consumer.method_22918(matrix4f, x1, y2, 0).method_39415(LoadingImageScreen.bgColor);
		consumer.method_22918(matrix4f, x2, y2, 0).method_39415(LoadingImageScreen.accent);
		consumer.method_22918(matrix4f, x2, y1, 0).method_39415(LoadingImageScreen.accent);
	}

	private double easeInOutCubic(double x) {
		return x < 0.5 ? 4 * x * x * x : 1 - Math.pow(-2 * x + 2, 3) / 2;
	}

	private int lerp(float delta, int start, int end) {
		return class_3532.method_15340(class_3532.method_48781(delta, start, end), start, end);
	}

	private class LoadingWidget extends class_339 {

		public LoadingWidget(int width, int height) {
			super(0, 0, width, height, class_2561.method_43473());
			field_22763 = false;
		}

		@Override
		protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
			guiGraphics.method_25294(method_46426(), method_46427(), method_55442(), method_55443(), bgColor);
			drawHorizontalGradient(guiGraphics, method_46426(), method_46427(), method_55443(), lerp((float) easeInOutCubic((class_156.method_658() - loadStart) % 1000f / 1000f), method_46426(), method_55442()));
		}

		@Override
		protected void method_47399(class_6382 builder) {

		}
	}
}
