/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Graphics;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import org.apache.commons.lang3.StringUtils;

public class Util {

	public static class_2561 formatFromCodes(String formattedString) {
		class_5250 text = class_2561.method_43473();
		String[] arr = formattedString.split("§");

		List<class_124> modifiers = new ArrayList<>();
		for (int i = 0, length = arr.length; i < length; i++) {
			String s = arr[i];
			if (s.isEmpty()) {
				continue;
			} else if (i == 0) {
				text.method_27693(s);
				continue;
			}
			class_124 formatting = class_124.method_544(s.charAt(0));
			if (formatting != null && formatting.method_542()) {
				modifiers.add(formatting);
			}
			class_5250 part = class_2561.method_43470(formatting != null ? s.substring(1) : s);
			if (formatting != null) {
				part.method_27692(formatting);

				if (!modifiers.isEmpty()) {
					modifiers.forEach(part::method_27692);
					if (formatting.equals(class_124.field_1070)) {
						modifiers.clear();
					}
				}
			}
			text.method_10852(part);
		}
		return text;
	}

	public static void sendChatMessage(String msg) {
		msg = class_3544.method_43681(StringUtils.normalizeSpace(msg.trim()));
		assert class_310.method_1551().field_1724 != null;
		if (msg.startsWith("/")) {
			class_310.method_1551().field_1724.field_3944.method_45731(msg.substring(1));
		} else {
			class_310.method_1551().field_1724.field_3944.method_45729(msg);
		}
	}

	public static void addMessageToChatHud(class_2561 msg) {
		class_310.method_1551().field_1705.method_1743().method_1812(msg);
	}

	public static class_2960 getTexture(GraphicsOption option) {
		return getTexture(option.get(), option.getName());
	}

	public static class_2960 getTexture(Graphics graphics, String name) {
		class_2960 id = class_2960.method_60655("axolotlclient", "graphics_" + name.toLowerCase(Locale.ROOT));
		try {
			class_1043 texture;
			if (class_310.method_1551().method_1531().method_34590(id, null) == null) {
				texture = new class_1043(class_1011.method_49277(graphics.getPixelData()));
				class_310.method_1551().method_1531().method_4616(id, texture);
			} else {
				texture = (class_1043) class_310.method_1551().method_1531().method_4619(id);
				for (int x = 0; x < graphics.getWidth(); x++) {
					for (int y = 0; y < graphics.getHeight(); y++) {
						texture.method_4525().method_4305(x, y, graphics.getPixelColor(x, y));
					}
				}
			}

			texture.method_4524();
		} catch (IOException e) {
			AxolotlClient.LOGGER.error("Failed to bind texture for " + name + ": ", e);
		}
		return id;
	}

	public static double lerp(double start, double end, double percent) {
		return start + ((end - start) * percent);
	}
}
