/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.options.rounded;

import java.util.Base64;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.rounded.screen.GraphicsEditorScreen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.rounded.widgets.GraphicsWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.rounded.widgets.RoundedButtonWidget;
import io.github.axolotlclient.util.notifications.Notifications;

@SuppressWarnings("unused")
public class AxoGraphicsWidget extends GraphicsWidget {
	private final GraphicsOption option;

	public AxoGraphicsWidget(int x, int y, int width, int height, GraphicsOption option) {
		super(x, y, width, height, option);
		this.option = option;
	}

	@Override
	public void method_25306() {
		class_310.method_1551().method_1507(new AxoGraphicsEditorScreen(class_310.method_1551().field_1755, this.option));
	}

	public static class AxoGraphicsEditorScreen extends GraphicsEditorScreen {

		public AxoGraphicsEditorScreen(class_437 parent, GraphicsOption option) {
			super(parent, option);
		}

		@Override
		public void method_25426() {
			super.method_25426();

			var clear = (RoundedButtonWidget) method_25396().getLast();
			var buttonX = clear.method_46426();
			var buttonY = clear.method_46427();
			var buttonWidth = clear.method_25368();
			method_37063(new RoundedButtonWidget(buttonX, buttonY + 24, class_2561.method_43471("graphics.copy_text"),
				btn -> field_22787.field_1774.method_1455(Base64.getEncoder().encodeToString(option.get().getPixelData())))).method_25358(buttonWidth);
			method_37063(new RoundedButtonWidget(buttonX, buttonY + 48, class_2561.method_43471("graphics.paste_text"),
				btn -> {
					try {
						option.get().setPixelData(Base64.getDecoder().decode(field_22787.field_1774.method_1460()));
					} catch (IllegalArgumentException e) {
						Notifications.getInstance().addStatus("graphics.paste_text.failed", "graphics.paste_text.failed.desc");
					}
				})).method_25358(buttonWidth);
		}

		@Override
		protected int getCurrentHeight() {
			return super.getCurrentHeight() - 24*2;
		}
	}
}
