/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import com.google.common.hash.Hashing;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.util.ClientColors;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SkinManager {
    private final Set<AxoIdentifier> loadedTextures = new ConcurrentSkipListSet<AxoIdentifier>(Comparator.comparing(Object::toString));

    public Skin read(Path p) {
        return this.read(p, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Skin read(Path p, boolean fix) {
        try {
            boolean bl;
            boolean slim;
            byte[] in = Files.readAllBytes(p);
            String sha256 = Hashing.sha256().hashBytes(in).toString();
            try (class_1011 img = class_1011.method_49277((byte[])in);){
                int width = img.method_4307();
                int height = img.method_4323();
                if (width != 64) {
                    Skin skin = null;
                    return skin;
                }
                if (height == 32) {
                    if (fix) {
                        try (class_1011 img2 = SkinManager.remapTexture(img);){
                            img2.method_4314(p);
                        }
                    }
                    slim = false;
                } else {
                    if (height != 64) {
                        Skin img2 = null;
                        return img2;
                    }
                    slim = ClientColors.ARGB.alpha((int)img.method_4315(50, 16)) == 0;
                }
                Map metadata = Skin.LocalSkin.readMetadata((Path)p);
                if (metadata != null && metadata.containsKey("variant_classic")) {
                    slim = (Boolean)metadata.get("variant_classic") == false;
                }
            }
            if (!slim) {
                bl = true;
                return new Skin.LocalSkin(bl, p, in, sha256);
            }
            bl = false;
            return new Skin.LocalSkin(bl, p, in, sha256);
        }
        catch (Exception e) {
            AxolotlClientCommon.getInstance().getLogger().warn("Failed to probe skin: ", new Object[]{e});
            return null;
        }
    }

    private static class_1011 remapTexture(class_1011 skinImage) {
        boolean legacySkin;
        boolean bl = legacySkin = skinImage.method_4323() == 32;
        if (legacySkin) {
            class_1011 nativeImage = new class_1011(64, 64, true);
            nativeImage.method_4317(skinImage);
            skinImage.close();
            skinImage = nativeImage;
            nativeImage.method_4326(0, 32, 64, 32, 0);
            nativeImage.method_4304(4, 16, 16, 32, 4, 4, true, false);
            nativeImage.method_4304(8, 16, 16, 32, 4, 4, true, false);
            nativeImage.method_4304(0, 20, 24, 32, 4, 12, true, false);
            nativeImage.method_4304(4, 20, 16, 32, 4, 12, true, false);
            nativeImage.method_4304(8, 20, 8, 32, 4, 12, true, false);
            nativeImage.method_4304(12, 20, 16, 32, 4, 12, true, false);
            nativeImage.method_4304(44, 16, -8, 32, 4, 4, true, false);
            nativeImage.method_4304(48, 16, -8, 32, 4, 4, true, false);
            nativeImage.method_4304(40, 20, 0, 32, 4, 12, true, false);
            nativeImage.method_4304(44, 20, -8, 32, 4, 12, true, false);
            nativeImage.method_4304(48, 20, -16, 32, 4, 12, true, false);
            nativeImage.method_4304(52, 20, -8, 32, 4, 12, true, false);
        }
        SkinManager.stripAlpha(skinImage, 0, 0, 32, 16);
        if (legacySkin) {
            SkinManager.stripColor(skinImage, 32, 0, 64, 32);
        }
        SkinManager.stripAlpha(skinImage, 0, 16, 64, 32);
        SkinManager.stripAlpha(skinImage, 16, 48, 48, 64);
        return skinImage;
    }

    private static void stripColor(class_1011 image, int x1, int y1, int x2, int y2) {
        int y;
        int x;
        for (x = x1; x < x2; ++x) {
            for (y = y1; y < y2; ++y) {
                int k = image.method_4315(x, y);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (x = x1; x < x2; ++x) {
            for (y = y1; y < y2; ++y) {
                image.method_4305(x, y, image.method_4315(x, y) & 0xFFFFFF);
            }
        }
    }

    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                image.method_4305(x, y, image.method_4315(x, y) | 0xFF000000);
            }
        }
    }

    public AxoIdentifier loadSkin(Skin skin) {
        AxoIdentifier rl = AxoIdentifier.of((String)"axolotlclient", (String)("skins/" + skin.sha256()));
        if (this.loadedTextures.contains(rl)) {
            return rl;
        }
        try {
            class_1043 tex = new class_1043(class_1011.method_49277((byte[])skin.image()));
            class_310.method_1551().method_1531().method_4616((class_2960)rl, (class_1044)tex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.loadedTextures.add(rl);
        return rl;
    }

    public AxoIdentifier loadCape(Cape cape) {
        AxoIdentifier rl = AxoIdentifier.of((String)"axolotlclient", (String)("capes/" + cape.id()));
        if (this.loadedTextures.contains(rl)) {
            return rl;
        }
        try {
            class_1043 tex = new class_1043(class_1011.method_49277((byte[])cape.image()));
            class_310.method_1551().method_1531().method_4616((class_2960)rl, (class_1044)tex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.loadedTextures.add(rl);
        return rl;
    }

    public void releaseAll() {
        this.loadedTextures.forEach(id -> class_310.method_1551().method_1531().method_4615((class_2960)id));
        this.loadedTextures.clear();
    }
}

