/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.hud.PlayerHudCommon;
import lombok.Generated;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_490;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlayerHud
extends PlayerHudCommon {
    private static boolean currentlyRendering;

    public PlayerHud() {
        Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
    }

    public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
        this.yawOffset += (event.yaw() - event.prevYaw()) / 2.0f;
    }

    public void tick() {
        super.tick();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_20232()) {
            float rawPitch = client.field_1724.method_5799() ? -90.0f - client.field_1724.method_36455() : -90.0f;
            float pitch = class_3532.method_16439((float)client.field_1724.method_6024(1.0f), (float)0.0f, (float)rawPitch);
            float height = client.field_1724.method_17682();
            float offset = (float)(Math.sin(Math.toRadians(pitch)) * (double)height);
            this.yOffset = Math.abs(offset) + 35.0f;
        } else if (client.field_1724 != null && client.field_1724.method_6128()) {
            float j = (float)client.field_1724.method_6003() + 1.0f;
            float k = class_3532.method_15363((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
            float pitch = k * (-90.0f - client.field_1724.method_36455()) + 90.0f;
            float height = client.field_1724.method_17682();
            float offset = (float)(Math.sin(Math.toRadians(pitch)) * (double)height) * 50.0f;
            this.yOffset = 35.0f - offset;
            if (pitch < 0.0f) {
                this.yOffset -= (float)((1.0 / (1.0 + Math.exp(-pitch / 4.0f)) - 0.5) * 20.0);
            }
        } else {
            this.yOffset *= 0.8f;
        }
    }

    protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
        class_310 client = class_310.method_1551();
        class_332 graphics = (class_332)ctx;
        if (client.field_1724 == null) {
            return;
        }
        if (!placeholder && ((Boolean)this.autoHide.get()).booleanValue()) {
            if (this.isPerformingAction()) {
                this.hide = -1L;
            } else if (this.hide == -1L) {
                this.hide = System.currentTimeMillis();
            }
            if (this.hide != -1L && System.currentTimeMillis() - this.hide > 500L) {
                return;
            }
        }
        float lerpY = this.lastYOffset + (this.yOffset - this.lastYOffset) * delta;
        float scale = this.getScale() * 40.0f;
        Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
        float deltaYaw = client.field_1724.method_5705(delta);
        if (((Boolean)this.dynamicRotation.get()).booleanValue()) {
            deltaYaw -= this.lastYawOffset + (this.yawOffset - this.lastYawOffset) * delta;
        }
        Quaternionf quaternionf2 = new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), deltaYaw - 180.0f + ((Double)this.rotation.get()).floatValue());
        quaternion.mul((Quaternionfc)quaternionf2);
        float pastYaw = client.field_1724.method_36454();
        float pastPrevYaw = client.field_1724.field_5982;
        currentlyRendering = true;
        class_490.method_48472((class_332)graphics, (float)((float)(x + (double)((float)this.getTrueContentWidth() / 2.0f)) / this.getScale()), (float)((float)(y + (double)((float)this.getTrueContentHeight() * client.field_1724.method_17682() / 2.0f) - (double)lerpY) / this.getScale()), (float)scale, (Vector3f)new Vector3f(), (Quaternionf)quaternion, (Quaternionf)quaternionf2, (class_1309)client.field_1724);
        currentlyRendering = false;
        client.field_1724.method_36456(pastYaw);
        client.field_1724.field_5982 = pastPrevYaw;
    }

    private boolean isPerformingAction() {
        class_746 player = class_310.method_1551().field_1724;
        return player.method_5715() || player.method_5624() || player.method_6128() || player.method_31549().field_7479 || player.method_5869() || player.method_20232() || player.method_5765() || player.method_6115() || player.field_6252 || player.field_6235 > 0 || player.method_5809();
    }

    @Generated
    public static boolean isCurrentlyRendering() {
        return currentlyRendering;
    }
}

