/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.bridge.render.AxoWindow;
import io.github.axolotlclient.mixin.BossBarHudAccessor;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class BossBarHud
extends TextHudEntry {
    public static final class_2960 ID = class_2960.method_60655((String)"kronhud", (String)"bossbarhud");
    private static final class_2960[] BAR_BACKGROUND_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/pink_background"), class_2960.method_60656((String)"boss_bar/blue_background"), class_2960.method_60656((String)"boss_bar/red_background"), class_2960.method_60656((String)"boss_bar/green_background"), class_2960.method_60656((String)"boss_bar/yellow_background"), class_2960.method_60656((String)"boss_bar/purple_background"), class_2960.method_60656((String)"boss_bar/white_background")};
    private static final class_2960[] BAR_PROGRESS_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/pink_progress"), class_2960.method_60656((String)"boss_bar/blue_progress"), class_2960.method_60656((String)"boss_bar/red_progress"), class_2960.method_60656((String)"boss_bar/green_progress"), class_2960.method_60656((String)"boss_bar/yellow_progress"), class_2960.method_60656((String)"boss_bar/purple_progress"), class_2960.method_60656((String)"boss_bar/white_progress")};
    private static final class_2960[] OVERLAY_BACKGROUND_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/notched_6_background"), class_2960.method_60656((String)"boss_bar/notched_10_background"), class_2960.method_60656((String)"boss_bar/notched_12_background"), class_2960.method_60656((String)"boss_bar/notched_20_background")};
    private static final class_2960[] OVERLAY_PROGRESS_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/notched_6_progress"), class_2960.method_60656((String)"boss_bar/notched_10_progress"), class_2960.method_60656((String)"boss_bar/notched_12_progress"), class_2960.method_60656((String)"boss_bar/notched_20_progress")};
    private final class_1259 placeholder = new CustomBossBar((class_2561)class_2561.method_43470((String)"Boss bar"), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
    private final class_1259 placeholder2 = (class_1259)class_156.method_656(() -> {
        CustomBossBar boss = new CustomBossBar((class_2561)class_2561.method_43470((String)"More boss bars..."), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
        boss.method_5408(0.45f);
        return boss;
    });
    private final BooleanOption text = new BooleanOption("text", Boolean.valueOf(true));
    private final BooleanOption bar = new BooleanOption("bar", Boolean.valueOf(true));
    private Map<UUID, class_345> bossBars = new HashMap<UUID, class_345>();
    private final class_310 client;

    public BossBarHud() {
        super(184, 80, false);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext graphics, float delta) {
        this.setBossBars();
        if (this.bossBars == null || this.bossBars.isEmpty()) {
            return;
        }
        DrawPosition scaledPos = this.getContentPos();
        int by = 12;
        for (class_345 bossBar : this.bossBars.values()) {
            this.renderBossBar((class_332)graphics, scaledPos.x() + 1, by + scaledPos.y(), (class_1259)bossBar);
            if ((by += 19) <= this.getContentHeight()) continue;
            break;
        }
    }

    public void setBossBars() {
        int prevLength = this.bossBars.size();
        this.bossBars = ((BossBarHudAccessor)this.client.field_1705.method_1740()).axolotlclient$getBossBars();
        if (this.bossBars != null && this.bossBars.size() != prevLength) {
            if (this.bossBars.isEmpty()) {
                return;
            }
            this.setContentHeight(Math.min(12 + prevLength * 19, (int)AxoWindow.getWindow().br$getScaledHeight() / 3));
            this.onBoundsUpdate();
        }
    }

    private void renderBossBar(class_332 graphics, int x, int y, class_1259 bossBar) {
        if (((Boolean)this.bar.get()).booleanValue()) {
            this.draw(graphics, x, y, bossBar, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES);
            int i = class_3532.method_53063((float)bossBar.method_5412(), (int)0, (int)182);
            if (i > 0) {
                this.draw(graphics, x, y, bossBar, i, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES);
            }
        }
        if (((Boolean)this.text.get()).booleanValue()) {
            class_2561 text = bossBar.method_5414();
            float textX = (float)x + (float)this.getContentWidth() / 2.0f - (float)this.client.field_1772.method_27525((class_5348)text) / 2.0f;
            float textY = y - 9;
            graphics.method_51439(this.client.field_1772, text, (int)textX, (int)textY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue());
        }
    }

    private void draw(class_332 graphics, int x, int y, class_1259 bar, int width, class_2960[] textures, class_2960[] alternativeTextures) {
        RenderSystem.enableBlend();
        graphics.method_52708(textures[bar.method_5420().ordinal()], 182, 5, 0, 0, x, y, width, 5);
        if (bar.method_5415() != class_1259.class_1261.field_5795) {
            graphics.method_52708(alternativeTextures[bar.method_5415().ordinal() - 1], 182, 5, 0, 0, x, y, width, 5);
        }
        RenderSystem.disableBlend();
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
        DrawPosition pos = this.getContentPos();
        this.renderBossBar((class_332)graphics, pos.x() + 1, pos.y() + 12, this.placeholder);
        this.renderBossBar((class_332)graphics, pos.x() + 1, pos.y() + 31, this.placeholder2);
    }

    public class_2960 getId() {
        return ID;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.hide);
        options.add(this.text);
        options.add(this.bar);
        return options;
    }

    public double getDefaultX() {
        return 0.5;
    }

    protected AnchorPoint getDefaultAnchor() {
        return AnchorPoint.TOP_MIDDLE;
    }

    public static class CustomBossBar
    extends class_1259 {
        public CustomBossBar(class_2561 name, class_1259.class_1260 color, class_1259.class_1261 style) {
            super(class_3532.method_15394(), name, color, style);
        }
    }
}

