/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_8646;
import net.minecraft.class_9011;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import net.minecraft.class_9025;

public class ScoreboardHud
extends TextHudEntry {
    public static final class_2960 ID = class_2960.method_60655((String)"kronhud", (String)"scoreboardhud");
    public static final class_266 placeholder = (class_266)class_156.method_656(() -> {
        class_269 placeScore = new class_269();
        class_266 objective = placeScore.method_1168("placeholder", class_274.field_1468, (class_2561)class_2561.method_43470((String)"Scoreboard"), class_274.class_275.field_1472, false, (class_9022)class_9025.field_47567);
        class_9014 dark = placeScore.method_1180(class_9015.method_55422((String)"DarkKronicle"), objective);
        dark.method_55410(8780);
        class_9014 moeh = placeScore.method_1180(class_9015.method_55422((String)"moehreag"), objective);
        moeh.method_55410(743);
        class_9014 kode = placeScore.method_1180(class_9015.method_55422((String)"TheKodeToad"), objective);
        kode.method_55410(2948);
        placeScore.method_1158(class_8646.field_45157, objective);
        return objective;
    });
    private final ColorOption backgroundColor = new ColorOption("backgroundcolor", new Color(0x4C000000));
    private final ColorOption topColor = new ColorOption("topbackgroundcolor", new Color(0x66000000));
    private final IntegerOption topPadding = new IntegerOption("toppadding", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(4));
    private final BooleanOption scores = new BooleanOption("scores", Boolean.valueOf(true));
    private final ColorOption scoreColor = new ColorOption("scorecolor", new Color(-43691));
    private final IntegerOption textAlpha = new IntegerOption("text_alpha", Integer.valueOf(255), Integer.valueOf(0), Integer.valueOf(255));
    private final class_310 client;

    public ScoreboardHud() {
        super(200, 146, true);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void render(AxoRenderContext context, float delta) {
        class_332 graphics = (class_332)context;
        graphics.method_51448().method_22903();
        this.scale((AxoRenderContext)graphics);
        this.renderComponent((AxoRenderContext)graphics, delta);
        graphics.method_51448().method_22909();
    }

    public void renderComponent(AxoRenderContext context, float delta) {
        class_266 scoreboardObjective2;
        int t;
        class_332 graphics = (class_332)context;
        class_269 scoreboard = this.client.field_1687.method_8428();
        class_266 scoreboardObjective = null;
        class_268 team = scoreboard.method_1164(this.client.field_1724.method_5820());
        if (team != null && (t = team.method_1202().method_536()) >= 0) {
            scoreboardObjective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(3 + t));
        }
        class_266 class_2662 = scoreboardObjective2 = scoreboardObjective != null ? scoreboardObjective : scoreboard.method_1189(class_8646.field_45157);
        if (scoreboardObjective2 != null) {
            this.renderScoreboardSidebar(graphics, scoreboardObjective2);
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
        this.renderScoreboardSidebar((class_332)graphics, placeholder);
    }

    private void renderScoreboardSidebar(class_332 graphics, class_266 objective) {
        int titleWidth;
        class_327 font = this.client.field_1772;
        class_269 scoreboard = objective.method_1117();
        class_9022 numberFormat = objective.method_55380((class_9022)class_9025.field_47567);
        @Environment(value=EnvType.CLIENT)
        record DisplayEntry(class_2561 name, class_2561 score, int scoreWidth) {
        }
        DisplayEntry[] entries = (DisplayEntry[])scoreboard.method_1184(objective).stream().filter(entry -> !entry.method_55385()).sorted(Comparator.comparing(class_9011::comp_2128).reversed().thenComparing(class_9011::comp_2127, String.CASE_INSENSITIVE_ORDER)).limit(15L).map(entry -> {
            class_268 playerTeam = scoreboard.method_1164(entry.comp_2127());
            class_2561 componentx = entry.method_55387();
            class_5250 component2 = class_268.method_1142((class_270)playerTeam, (class_2561)componentx);
            class_5250 component3 = entry.method_55386(numberFormat);
            int ix = font.method_27525((class_5348)component3);
            return new DisplayEntry((class_2561)component2, (class_2561)component3, ix);
        }).toArray(x$0 -> new DisplayEntry[x$0]);
        class_2561 title = objective.method_1114();
        int maxWidth = titleWidth = font.method_27525((class_5348)title);
        int textOffset = font.method_1727(": ");
        for (DisplayEntry entry2 : entries) {
            maxWidth = Math.max(maxWidth, font.method_27525((class_5348)entry2.name) + (entry2.scoreWidth > 0 && (Boolean)this.scores.get() != false ? textOffset + entry2.scoreWidth : 0));
        }
        maxWidth += 3;
        int m = entries.length;
        int mainHeight = m * 9;
        int newHeight = mainHeight + 10 + (Integer)this.topPadding.get() * 2;
        boolean updated = false;
        if (newHeight + 1 != this.height) {
            this.setHeight(newHeight + 1);
            updated = true;
        }
        if (maxWidth + 1 != this.width) {
            this.setWidth(maxWidth + 1);
            updated = true;
        }
        if (updated) {
            this.onBoundsUpdate();
        }
        Rectangle bounds = this.getBounds();
        int yEnd = bounds.y() + bounds.height();
        int textX = bounds.x() + 3;
        int xEnd = bounds.x() + bounds.width() - 1;
        int titleEnd = yEnd - mainHeight;
        if (((Boolean)this.background.get()).booleanValue()) {
            graphics.method_25294(textX - 2, titleEnd - 9 - 1 - (Integer)this.topPadding.get() * 2, xEnd, titleEnd - 1, this.topColor.get().toInt());
            graphics.method_25294(textX - 2, titleEnd - 1, xEnd, yEnd, this.backgroundColor.get().toInt());
        }
        graphics.method_51439(font, title, textX + maxWidth / 2 - titleWidth / 2, titleEnd - 9 - (Integer)this.topPadding.get(), class_5253.class_5254.method_58144((int)((Integer)this.textAlpha.get()), (int)-1), ((Boolean)this.shadow.get()).booleanValue());
        for (int v = 0; v < m; ++v) {
            DisplayEntry lv2 = entries[v];
            int w = yEnd - (m - v) * 9;
            graphics.method_51439(font, lv2.name, textX, w, class_5253.class_5254.method_58144((int)((Integer)this.textAlpha.get()), (int)-1), ((Boolean)this.shadow.get()).booleanValue());
            if (!((Boolean)this.scores.get()).booleanValue()) continue;
            graphics.method_51439(font, lv2.score, xEnd - lv2.scoreWidth, w, this.scoreColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue());
        }
        if (((Boolean)this.outline.get()).booleanValue() && this.outlineColor.get().getAlpha() > 0) {
            DrawUtil.outlineRect(graphics, bounds, this.outlineColor.get());
        }
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.remove(this.backgroundPadding);
        options.remove(this.backgroundRounding);
        options.remove(this.roundBackground);
        options.set(options.indexOf(((TextHudEntry)this).backgroundColor), this.backgroundColor);
        options.add(this.hide);
        options.add(this.topColor);
        options.add(this.scores);
        options.add(this.scoreColor);
        options.add(this.topPadding);
        options.remove(this.textColor);
        options.add(this.textAlpha);
        return options;
    }

    public class_2960 getId() {
        return ID;
    }

    protected AnchorPoint getDefaultAnchor() {
        return AnchorPoint.MIDDLE_RIGHT;
    }

    public double getDefaultX() {
        return 1.0;
    }

    public double getDefaultY() {
        return 0.5;
    }
}

